/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Ide;
import oracle.ideimpl.memwatch.ConfFileUtils;
import oracle.ideimpl.memwatch.JavaChecker;
import oracle.ideimpl.memwatch.MemoryArb;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialog;

final class LowMemoryHandler {
    private static final boolean DISABLED = Boolean.getBoolean("LowMemoryHandler.disabled");
    private static final int HEAP_STEP = 128;
    private static final int PERMGEN_STEP = 32;
    static final int TYPE_HEAP = 0;
    static final int TYPE_PERMGEN = 1;
    private static final String XMS_FLAG = "-Xms";
    private static final String XMX_FLAG = "-Xmx";
    private static final String PERMGEN_FLAG = "-XX:MaxPermSize=";
    private static String heapConfPath;
    private static String permConfPath;

    LowMemoryHandler() {
    }

    static void handleLowMemory(int type, long current, long max) {
        if (DISABLED) {
            LowMemoryHandler.notifyManual(type, current, max);
            return;
        }
        String[] flags = new String[]{XMS_FLAG, XMX_FLAG, PERMGEN_FLAG};
        List<String>[] currentSettings = LowMemoryHandler.getCurrentSettings(flags);
        if (currentSettings[0].size() > 1 || currentSettings[1].size() != 1 || currentSettings[2].size() != 1) {
            LowMemoryHandler.notifyManual(type, current, max);
            return;
        }
        List<String>[] confSettings = LowMemoryHandler.getConfSettings(flags);
        for (int i = 0; i < flags.length; ++i) {
            if (currentSettings[i].size() == confSettings[i].size()) continue;
            LowMemoryHandler.notifyManual(type, current, max);
            return;
        }
        String xms = currentSettings[0].size() == 0 ? null : currentSettings[0].get(0).trim();
        String xmx = currentSettings[1].get(0).trim();
        String perm = currentSettings[2].get(0).trim();
        if (xms != null && !xms.equals(confSettings[0].get(0).trim()) || !xmx.equals(confSettings[1].get(0).trim()) || !perm.equals(confSettings[2].get(0).trim())) {
            LowMemoryHandler.notifyManual(type, current, max);
            return;
        }
        LowMemoryHandler.notifyAutomatic(type, current, max, xms, xmx, perm);
    }

    private static void notifyManual(int type, long current, long max) {
        SwingUtilities.invokeLater(WarningRunnable.manual(type, current, max));
    }

    private static void notifyAutomatic(int type, long current, long max, String xms, String xmx, String perm) {
        SwingUtilities.invokeLater(WarningRunnable.automatic(type, current, max, xms, xmx, perm));
    }

    private static String increase(String current, int delta) {
        try {
            String upper = current.toUpperCase();
            String sizeS = current.substring(0, current.length() - 1);
            if (upper.endsWith("K")) {
                long valueL = Long.parseLong(sizeS) >> 10;
                return (valueL += (long)delta) + "M";
            }
            if (upper.endsWith("M")) {
                long valueL = Long.parseLong(sizeS);
                return (valueL += (long)delta) + "M";
            }
            if (upper.endsWith("G")) {
                long valueL = Long.parseLong(sizeS) << 10;
                return (valueL += (long)delta) + "M";
            }
            long valueL = Long.parseLong(current) >> 20;
            return (valueL += (long)delta) + "M";
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to decode value " + current);
            e.printStackTrace();
            return null;
        }
    }

    private static void increaseMemory(int type, String xms, String xmx, String perm) {
        boolean memoryUpdated = false;
        String newValue = null;
        if (type == 0) {
            String newxmx = xmx.substring(XMX_FLAG.length());
            newValue = newxmx = LowMemoryHandler.increase(newxmx, 128);
            if (newxmx != null && (memoryUpdated = JavaChecker.checkJava(xms, newxmx = XMX_FLAG + newxmx, perm))) {
                memoryUpdated = ConfFileUtils.updateConfSettings(LowMemoryHandler.getConfFile(type), XMX_FLAG, newxmx);
            }
        } else if (type == 1) {
            String newperm = perm.substring(PERMGEN_FLAG.length());
            newValue = newperm = LowMemoryHandler.increase(newperm, 32);
            if (newperm != null && (memoryUpdated = JavaChecker.checkJava(xms, xmx, newperm = PERMGEN_FLAG + newperm))) {
                memoryUpdated = ConfFileUtils.updateConfSettings(LowMemoryHandler.getConfFile(type), PERMGEN_FLAG, newperm);
            }
        }
        SwingUtilities.invokeLater(memoryUpdated ? ConfirmRunnable.success(type, newValue) : ConfirmRunnable.failure(type));
    }

    private static List<String>[] getCurrentSettings(String[] flags) {
        ArrayList[] settings = new ArrayList[flags.length];
        for (int i = 0; i < settings.length; ++i) {
            settings[i] = new ArrayList();
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = runtimeMXBean.getInputArguments();
            block3: for (String string : aList) {
                for (int i = 0; i < flags.length; ++i) {
                    if (!string.startsWith(flags[i])) continue;
                    settings[i].add(string);
                    continue block3;
                }
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to process input arguments");
            t.printStackTrace();
        }
        return settings;
    }

    private static List<String>[] getConfSettings(String[] flags) {
        List<String>[] settings1 = ConfFileUtils.getConfSettings(LowMemoryHandler.getConfFile(0), flags);
        List<String>[] settings2 = ConfFileUtils.getConfSettings(LowMemoryHandler.getConfFile(1), flags);
        for (int i = 0; i < flags.length; ++i) {
            settings1[i].addAll(settings2[i]);
        }
        return settings1;
    }

    static String getConfFilePath(int type) {
        String path = null;
        if (type == 1) {
            if (permConfPath == null) {
                permConfPath = System.getProperty("ide.conf");
            }
            path = permConfPath;
        } else if (type == 0 && heapConfPath == null) {
            if (permConfPath == null) {
                permConfPath = System.getProperty("ide.conf");
            }
            if (permConfPath != null) {
                File file = new File(permConfPath);
                if (file.exists()) {
                    List<String> incls = ConfFileUtils.getConfIncludes(file);
                    for (String incl : incls) {
                        if (!incl.endsWith("ide.conf")) continue;
                        File heapFile = new File(permConfPath, incl);
                        try {
                            heapConfPath = heapFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            heapConfPath = heapFile.getAbsolutePath();
                        }
                        break;
                    }
                }
                if (heapConfPath == null) {
                    heapConfPath = permConfPath;
                }
                path = heapConfPath;
            }
        }
        return path;
    }

    private static File getConfFile(int type) {
        File file = null;
        String path = LowMemoryHandler.getConfFilePath(type);
        if (path != null) {
            file = new File(path);
        }
        return file;
    }

    private static final class ConfirmRunnable
    implements Runnable {
        private final int type;
        private final String newValue;
        private final boolean success;

        static ConfirmRunnable success(int type, String newValue) {
            return new ConfirmRunnable(type, newValue, true);
        }

        static ConfirmRunnable failure(int type) {
            return new ConfirmRunnable(type, null, false);
        }

        private ConfirmRunnable(int type, String newValue, boolean success) {
            this.type = type;
            this.newValue = newValue;
            this.success = success;
        }

        @Override
        public void run() {
            AbstractButton restart = null;
            String title = MemoryArb.getString(this.success ? 4 : 5);
            int type = this.success ? 2 : 1;
            BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)((Object)Ide.getMainWindow()), (String)title, (int)type);
            if (this.success) {
                String typeName = MemoryArb.getString(type == 0 ? 6 : 7);
                String message = MemoryArb.format(8, typeName, this.newValue);
                JPanel panel = new JPanel(new BorderLayout(0, 15));
                MultiLineLabel m_text = new MultiLineLabel();
                m_text.setTextWrapper(WordWrapper.getTextWrapper());
                m_text.setPreferredAspectRatio(5.0f);
                m_text.setText(message);
                restart = new JCheckBox(MemoryArb.getString(11));
                panel.add((Component)m_text, "Center");
                panel.add((Component)restart, "South");
                dialog.setMessage((Object)panel);
            } else {
                dialog.setMessageText(MemoryArb.getString(9));
            }
            if (dialog.runDialog() && this.success && restart != null && restart.isSelected()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Ide.restart();
                        }
                        catch (UnsupportedOperationException e) {
                            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)MemoryArb.getString(12), (String)MemoryArb.getString(10), null);
                        }
                    }
                }.start();
            }
        }
    }

    private static final class WarningRunnable
    implements Runnable {
        private final int type;
        private final long current;
        private final long max;
        private final String xms;
        private final String xmx;
        private final String perm;

        static WarningRunnable manual(int type, long current, long max) {
            return new WarningRunnable(type, current, max, null, null, null);
        }

        static WarningRunnable automatic(int type, long current, long max, String xms, String xmx, String perm) {
            return new WarningRunnable(type, current, max, xms, xmx, perm);
        }

        private WarningRunnable(int type, long current, long max, String xms, String xmx, String perm) {
            this.type = type;
            this.current = current;
            this.max = max;
            this.xms = xms;
            this.xmx = xmx;
            this.perm = perm;
        }

        @Override
        public void run() {
            boolean automatic;
            String confPath = LowMemoryHandler.getConfFilePath(this.type);
            String confFileName = confPath != null ? new File(confPath).getName() : "conf";
            String message = MemoryArb.getString(this.type == 0 ? 1 : 2);
            message = MessageFormat.format(message, this.current, this.max, confPath);
            AbstractButton updateConf = null;
            BaseMessageDialog dialog = BaseMessageDialog.createMessageDialogImpl((Component)((Object)Ide.getMainWindow()), (String)MemoryArb.getString(0), (int)2);
            boolean bl = automatic = this.xmx != null;
            if (automatic) {
                JPanel panel = new JPanel(new BorderLayout(0, 15));
                MultiLineLabel m_text = new MultiLineLabel();
                m_text.setTextWrapper(WordWrapper.getTextWrapper());
                m_text.setPreferredAspectRatio(5.0f);
                m_text.setText(message);
                updateConf = new JCheckBox(MemoryArb.format(3, confFileName));
                panel.add((Component)m_text, "Center");
                panel.add((Component)updateConf, "South");
                dialog.setMessage((Object)panel);
            } else {
                dialog.setMessageText(message);
            }
            if (dialog.runDialog() && automatic && updateConf.isSelected()) {
                new Thread(){

                    @Override
                    public void run() {
                        LowMemoryHandler.increaseMemory(WarningRunnable.this.type, WarningRunnable.this.xms, WarningRunnable.this.xmx, WarningRunnable.this.perm);
                    }
                }.start();
            }
        }
    }
}

