/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.ide.extension.Extension;
import javax.ide.progress.ProgressManager;
import javax.ide.util.MetaClass;
import javax.ide.util.Version;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeRunStatus;
import oracle.ide.ProductInformation;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSystemMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ideimpl.migration.MigrationClassInfo;
import oracle.ideimpl.migration.MigrationDialog;
import oracle.ideimpl.migration.MigratorsHook;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class MigrationManagerImpl
extends MigrationManager {
    private final String MINIMUM_JDEVELOPER_SUPPORTED_VERSION = "10.1.29999";
    private final String MINIMUM_OTHER_SUPPORTED_VERSION = "0";
    private final String SYSTEM_DIR_PREFIX = "system";
    private final String ORACLE_JDEVELOPER_DIR_PREFIX = "oracle.jdeveloper.";
    private boolean migrationInitiated = false;
    private Map<MigrationClassInfo, Extension> _registrations = new HashMap<MigrationClassInfo, Extension>();
    private List<Migrator> _migrators;
    private HashMap<Extension, List<Migrator>> _migratorsPerExtensionMap = new HashMap();
    private boolean migrationDone;
    private static MigrationManager _instance;
    private final boolean DEFAULT_VALUE_USER_CANCELLED = false;
    private static String previousMigrationChoice;
    private static File sourceInstallation;
    private static boolean migrateFlag;
    private static boolean noMigrateFlag;
    private static boolean noNagFlag;
    private static boolean headless;
    private Version sourceVersion;
    private Version currentVersion;
    private HashMap<Extension, ArrayList<MetaClass>> lazyRegisterdMigrators = new HashMap();
    private static boolean initialMigrationDone;

    public static synchronized MigrationManager getInstance() {
        if (_instance == null) {
            _instance = new MigrationManagerImpl();
        }
        return _instance;
    }

    private List<Migrator> getMigrators(Extension descriptor) {
        this.getMigrators();
        return this._migratorsPerExtensionMap.get(descriptor);
    }

    @Override
    public synchronized List<Migrator> getMigrators() {
        if (this._migrators == null) {
            this.registerHookMigrators();
            this._migrators = new ArrayList<Migrator>();
            for (Map.Entry<MigrationClassInfo, Extension> entry : this._registrations.entrySet()) {
                Migrator migrator = this.buildMigrator(entry.getKey());
                if (migrator == null) continue;
                Extension desc = entry.getValue();
                List<Migrator> list = this.getMigrators(desc);
                if (list == null) {
                    list = new ArrayList<Migrator>();
                    this._migratorsPerExtensionMap.put(desc, list);
                }
                list.add(migrator);
                this._migrators.add(migrator);
            }
        }
        return this._migrators;
    }

    private void registerHookMigrators() {
        ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
        MigratorsHook migHook = (MigratorsHook)reg.getHook(MigratorsHook.ELEMENT);
        if (migHook != null) {
            for (Map.Entry<Extension, Collection<MigrationClassInfo>> entry : migHook.getMigratorClassesByExtension().entrySet()) {
                Extension ext = entry.getKey();
                for (MigrationClassInfo migratorClassInfo : entry.getValue()) {
                    this.registerMigrator(migratorClassInfo, ext);
                }
            }
        }
    }

    private Migrator buildMigrator(MigrationClassInfo migrationClassInfo) {
        Migrator migrator = null;
        try {
            MetaClass metaClass = migrationClassInfo.getMetaClass();
            Class<?> clazz = Class.forName(metaClass.getClassName(), true, metaClass.getClassLoader());
            migrator = (Migrator)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            Assert.println((String)("WARNING: Failed trying to load migrator: " + migrationClassInfo.getClassName() + ", " + e.getMessage()));
        }
        catch (Exception e) {
            Assert.println((String)("WARNING: Failed trying to load migrator: " + migrationClassInfo.getClassName() + ", " + e.getMessage()));
        }
        return migrator;
    }

    @Override
    public Migrator getMigrator(Class cls) {
        for (Migrator migrator : this.getMigrators()) {
            if (cls != migrator.getClass()) continue;
            return migrator;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getOracleHomeDirectory(File systemDir) {
        try {
            String path = Ide.getInstallDirectory(systemDir);
            if (path != null && ModelUtil.hasLength((String)path)) {
                File jDevBinDir = new File(path);
                return jDevBinDir.getParentFile().getParentFile();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            File paletteXmlFile = new File(systemDir, "palette.xml");
            if (paletteXmlFile.exists()) {
                in = new BufferedInputStream(new FileInputStream(paletteXmlFile));
                DOMParser domParser = new DOMParser();
                domParser.parse((InputStream)in);
                XMLDocument doc = domParser.getDocument();
                final XMLElement rootElem = (XMLElement)doc.getDocumentElement();
                NSResolver xmlns = new NSResolver(){
                    private final String uri;
                    {
                        this.uri = rootElem.getNamespaceURI();
                    }

                    public String resolveNamespacePrefix(String prefix) {
                        return "a".equals(prefix) ? this.uri : null;
                    }
                };
                NodeList bc4jTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='jbo' or a:prefix='bc4juix' or a:prefix='uix']/a:location/text()", xmlns);
                File oracleHome = MigrationManagerImpl.findOracleHome(bc4jTaglibs, 3);
                if (oracleHome != null) {
                    File file = oracleHome;
                    return file;
                }
                NodeList ojspTaglibs = rootElem.selectNodes("a:jsplibrary[a:prefix='email' or a:prefix='fileaccess' or a:prefix='JESI' or a:prefix='jwcache' or a:prefix='database' or a:prefix='util' or a:prefix='XML' or a:prefix='EJB']/a:location/text()", xmlns);
                File file = MigrationManagerImpl.findOracleHome(ojspTaglibs, 4);
                return file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static File findOracleHome(NodeList nodes, int levelsUp) {
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node = nodes.item(i);
            String dirStr = node.getNodeValue();
            if (!ModelUtil.hasLength((String)dirStr)) continue;
            File dir = new File(dirStr);
            for (int j = 0; j < levelsUp && dir != null; dir = dir.getParentFile(), ++j) {
            }
            if (dir == null) continue;
            return dir;
        }
        return null;
    }

    @Override
    public void registerMigrator(String className, Extension desc) {
        this.registerMigrator(new MigrationClassInfo(className, new MetaClass(this.getClass().getClassLoader(), className)), desc);
    }

    private synchronized void registerMigrator(MigrationClassInfo migrationClassInfo, Extension desc) {
        Migrator migrator;
        if (migrationClassInfo == null || desc == null) {
            return;
        }
        if (!this._registrations.containsKey(migrationClassInfo)) {
            this._registrations.put(migrationClassInfo, desc);
        }
        if (this._migrators != null && (migrator = this.buildMigrator(migrationClassInfo)) != null) {
            this._migrators.add(migrator);
            List<Migrator> list = this.getMigrators(desc);
            if (list == null) {
                list = new ArrayList<Migrator>();
                this._migratorsPerExtensionMap.put(desc, list);
            }
            list.add(migrator);
        }
    }

    @Override
    public String migrate(boolean userDirectoryCreated, boolean systemDirectoryCreated) {
        initialMigrationDone = true;
        IdeArgs args = Ide.getIdeArgs();
        noMigrateFlag = args.contains(IdeArgs.Arguments.NOMIGRATE);
        noNagFlag = args.contains(IdeArgs.Arguments.NONAG);
        migrateFlag = args.contains(IdeArgs.Arguments.MIGRATE);
        String migrateDirectory = null;
        if (migrateFlag) {
            migrateDirectory = args.getOption(IdeArgs.Arguments.MIGRATE);
        }
        boolean bl = headless = !args.getCreateUI();
        if (noMigrateFlag || noNagFlag || headless) {
            return null;
        }
        URL currentSystemDirectory = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        this.currentVersion = this.versionFromFolderName(currentSystemDirectory);
        SortedMap<Version, String> previousInstallations = this.getPreviousInstallations(this.currentVersion);
        previousMigrationChoice = IdeRunStatus.getInstance().getUserMigrationChoice();
        if (previousMigrationChoice != null) {
            sourceInstallation = new File(IdeRunStatus.getInstance().getPreviousMigrationSource());
        } else if (!previousInstallations.isEmpty()) {
            sourceInstallation = new File((String)previousInstallations.get(previousInstallations.firstKey()));
        }
        this.migratorsAvailable();
        IdeRunStatus ideRunStatus = IdeRunStatus.getInstance();
        if (migrateFlag) {
            File userSelectedSourceInstallation = this.getUserSelectionSourceInstallation(previousInstallations, this.currentVersion, true, migrateDirectory);
            if (userSelectedSourceInstallation == null) {
                return null;
            }
            sourceInstallation = userSelectedSourceInstallation;
            ideRunStatus.setUserMigrationChoice("true");
            ideRunStatus.setPreviousMigrationSource(userSelectedSourceInstallation.getAbsolutePath());
            return this.executeMigration(sourceInstallation);
        }
        if (userDirectoryCreated) {
            return null;
        }
        if (previousInstallations.isEmpty() && !systemDirectoryCreated) {
            return null;
        }
        if (!this.newExtensionInstalled()) {
            return null;
        }
        if (!this.newExtensionExisted(previousInstallations)) {
            return null;
        }
        if (previousMigrationChoice != null && previousMigrationChoice.equalsIgnoreCase("false")) {
            return null;
        }
        File userSelectedSourceInstallation = null;
        if (previousMigrationChoice == null) {
            userSelectedSourceInstallation = this.getUserSelectionSourceInstallation(previousInstallations, this.currentVersion, false, migrateDirectory);
            if (userSelectedSourceInstallation == null) {
                ideRunStatus.setUserMigrationChoice("false");
                ideRunStatus.setPreviousMigrationSource("");
                return null;
            }
            sourceInstallation = userSelectedSourceInstallation;
            ideRunStatus.setUserMigrationChoice("true");
            ideRunStatus.setPreviousMigrationSource(sourceInstallation.getAbsolutePath());
        }
        return this.executeMigration(sourceInstallation);
    }

    public Version versionFromFolderName(URL dir) {
        Version version = null;
        String folderName = URLFileSystem.getFileName((URL)dir);
        if (folderName.startsWith("system") && folderName.length() > "system".length()) {
            String versionNumber = folderName.substring("system".length());
            if (!Version.isValid((String)versionNumber)) {
                return null;
            }
            try {
                version = new Version(versionNumber);
            }
            catch (NumberFormatException nfe) {}
        } else if (folderName.equalsIgnoreCase("system")) {
            URL[] subdirs;
            for (URL subdir : subdirs = URLFileSystem.list((URL)dir)) {
                String subdirName = URLFileSystem.getFileName((URL)subdir);
                if (!subdirName.startsWith("oracle.jdeveloper.")) continue;
                String versionNumber = subdirName.substring("oracle.jdeveloper.".length());
                try {
                    version = new Version(versionNumber);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return version;
    }

    private String executeMigration(File sourceInstallation) {
        StringBuilder errorBuffer = new StringBuilder();
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection allExtensions = extReg.getExtensions();
        try {
            String productID = ProductInformation.getProductID();
            boolean isSameSystemDirectoryAsBefore = new File(Ide.getSystemDirectory()).equals(sourceInstallation);
            int totalCount = allExtensions.size();
            ProgressManager.finalizeProgress((String)"migration", (int)totalCount);
            for (Object o : allExtensions) {
                File preferencesFileSrc;
                Iterator<Migrator> iter;
                if (!(o instanceof Extension)) {
                    ProgressManager.updateProgress((String)"migration", (int)1);
                    continue;
                }
                Extension extension = (Extension)o;
                ProgressManager.updateProgressDescription((String)"migration", (String)extension.getName(), (int)1);
                URL sourceInstallationURL = MigrationManagerImpl.findNewestSystemDir(URLFactory.newFileURL((File)sourceInstallation), extension, isSameSystemDirectoryAsBefore);
                File src = new File(URLFileSystem.getPlatformPathName((URL)sourceInstallationURL));
                URL url = extReg.getSystemDirectory(extension.getID());
                File dest = new File(url.getPath());
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (src == null || src.equals(dest)) continue;
                List<Migrator> list = this.getMigrators(extension);
                Iterator<Migrator> iterator = iter = list != null ? list.iterator() : null;
                if (iter != null) {
                    while (iter.hasNext()) {
                        Migrator migrator = iter.next();
                        int[] categories = migrator.getMigrationCategories();
                        for (int index = 0; index < categories.length; ++index) {
                            int category = categories[index];
                            migrator.setSelected(category, migrator.canMigrate(category, src));
                        }
                        String[] errors = null;
                        try {
                            errors = migrator.migrate(src, dest);
                            IdeRunStatus.getInstance().setExtensionMigratorExecuted(extension, migrator.getClass().getName());
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            FeedbackManager.reportException(t);
                        }
                        if (errors == null || errors.length <= 0) continue;
                        for (int j = 0; j < errors.length; ++j) {
                            errorBuffer.append(errors[j]);
                            errorBuffer.append("\n");
                        }
                        errorBuffer.append("\n");
                    }
                }
                if (productID.equals(extension.getID())) {
                    File productPrefsSrc = new File(src, "product-preferences.xml");
                    HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:preferences");
                    try {
                        Preferences prefs = Preferences.getPreferences();
                        io.open(URLFactory.newFileURL((File)productPrefsSrc), (Object)prefs.getProperties());
                        EnvironOptions.getInstance(prefs).adjustAfterMigration();
                        prefs.save();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (!(preferencesFileSrc = new File(src, "preferences.xml")).isFile() || !preferencesFileSrc.canRead()) continue;
                File preferencesFileDest = new File(dest, "preferences.xml");
                try {
                    URLFileSystem.copy((URL)URLFactory.newFileURL((File)preferencesFileSrc), (URL)URLFactory.newFileURL((File)preferencesFileDest));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.migrationInitiated = true;
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            errorBuffer.append(pw.toString());
        }
        return errorBuffer.toString();
    }

    private String executeExtensionMigration(Extension extension, Migrator migrator) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        StringBuilder errorBuffer = new StringBuilder();
        if (!migrateFlag && !extReg.isNewlyInstalled(extension.getID())) {
            return "";
        }
        try {
            File preferencesFileSrc;
            String productID = ProductInformation.getProductID();
            boolean isSameSystemDirectoryAsBefore = new File(Ide.getSystemDirectory()).equals(sourceInstallation);
            URL sourceInstallationURL = MigrationManagerImpl.findNewestSystemDir(URLFactory.newFileURL((File)sourceInstallation), extension, isSameSystemDirectoryAsBefore);
            File src = new File(URLFileSystem.getPlatformPathName((URL)sourceInstallationURL));
            URL url = extReg.getSystemDirectory(extension.getID());
            File dest = new File(url.getPath());
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if (src != null && !src.equals(dest)) {
                int[] categories = migrator.getMigrationCategories();
                for (int index = 0; index < categories.length; ++index) {
                    int category = categories[index];
                    migrator.setSelected(category, migrator.canMigrate(category, src));
                }
                String[] errors = null;
                try {
                    errors = migrator.migrate(src, dest);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    FeedbackManager.reportException(t);
                }
                if (errors != null && errors.length > 0) {
                    for (int j = 0; j < errors.length; ++j) {
                        errorBuffer.append(errors[j]);
                        errorBuffer.append("\n");
                    }
                    errorBuffer.append("\n");
                }
            }
            if ((preferencesFileSrc = new File(src, "preferences.xml")).isFile() && preferencesFileSrc.canRead()) {
                File preferencesFileDest = new File(dest, "preferences.xml");
                try {
                    URLFileSystem.copy((URL)URLFactory.newFileURL((File)preferencesFileSrc), (URL)URLFactory.newFileURL((File)preferencesFileDest));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            errorBuffer.append(pw.toString());
        }
        return errorBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getUserSelectionSourceInstallation(SortedMap<Version, String> previousInstallations, Version currentVersion, boolean migrateFlag, String migrateDirectory) {
        File temp;
        File result = null;
        if (migrateDirectory != null && this.isValidSystemDirectory(temp = new File(migrateDirectory))) {
            result = temp;
        }
        if (result == null) {
            MigrationDialog dlg = new MigrationDialog(SwingUtils.getToplevelWindow(), previousInstallations, migrateFlag, currentVersion, this);
            try {
                if (dlg.runDialog()) {
                    result = dlg.sourceSelected();
                }
            }
            finally {
                dlg.dispose();
            }
        }
        return result;
    }

    private boolean migratorsAvailable() {
        List<Migrator> migrators = this.getMigrators();
        return migrators != null && !migrators.isEmpty();
    }

    private boolean newExtensionExisted(SortedMap previousInstallations) {
        return true;
    }

    private boolean newExtensionInstalled() {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection allExtensions = extReg.getExtensions();
        for (Extension extension : allExtensions) {
            if (!extReg.isNewlyInstalled(extension.getID())) continue;
            return true;
        }
        return false;
    }

    private SortedMap<Version, String> getPreviousInstallations(Version currentVersion) {
        if (ProductInformation.getProductInformation().getShortName() == null) {
            return new TreeMap<Version, String>();
        }
        String product = ProductInformation.getProductInformation().getShortName();
        Version MIN_VERSION_FOR_MIGRATION = product.startsWith("JDev") ? new Version("10.1.29999") : new Version("0");
        URL currentSystemDirectory = URLFactory.newDirURL((String)Ide.getSystemDirectory());
        URL userDirectory = URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
        URL[] subFolders = URLFileSystem.list((URL)userDirectory);
        TreeMap<Version, String> previousInstallations = new TreeMap<Version, String>();
        if (subFolders != null) {
            for (URL dir : subFolders) {
                Version candiateVersionToMigrateFrom;
                if (!URLFileSystem.isDirectory((URL)dir) || URLFileSystem.equals((URL)dir, (URL)currentSystemDirectory) || (candiateVersionToMigrateFrom = this.versionFromFolderName(dir)) == null || candiateVersionToMigrateFrom.compareTo(currentVersion) >= 0 || candiateVersionToMigrateFrom.compareTo(MIN_VERSION_FOR_MIGRATION) < 0) continue;
                previousInstallations.put(candiateVersionToMigrateFrom, URLFileSystem.getPlatformPathName((URL)dir));
            }
        }
        return previousInstallations;
    }

    private boolean isValidSystemDirectory(File dir) {
        boolean result = false;
        URI uri = dir.toURI();
        if (uri != null) {
            try {
                URL url = uri.toURL();
                if (URLFileSystem.isDirectory((URL)url) && this.versionFromFolderName(url) != null) {
                    result = true;
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void migrate() {
        boolean userDirectoryCreated = false;
        boolean systemDirectoryCreated = false;
        this.migrate(userDirectoryCreated, systemDirectoryCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishMigration() {
        block9: {
            XMLMigrator migrator;
            XMLMigrator xMLMigrator = migrator = this.migrationInitiated ? (XMLMigrator)this.getMigrator(IdeSystemMigrator.class) : null;
            if (migrator == null || !migrator.isSelected(0)) break block9;
            MigrationManagerImpl migrationManagerImpl = this;
            synchronized (migrationManagerImpl) {
                SwingUtilities.invokeLater(new WorkspacesMigrator(this));
                while (!this.migrationDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break;
                        throw (ThreadDeath)t;
                    }
                }
            }
        }
    }

    private static String expandExtensionId(String name) {
        if (name != null && name.startsWith("o.") && name.length() > "o.".length()) {
            return "oracle." + name.substring("o.".length());
        }
        return name;
    }

    private static boolean hasPrefix(String text, String prefix) {
        return text.startsWith(prefix) && text.length() > prefix.length();
    }

    private static String removePrefix(String text, String prefix) {
        return text.substring(prefix.length());
    }

    private static boolean isNewerThan(Version one, Version two) {
        return one.compareTo(two) > 0;
    }

    private static boolean isOlderThan(Version one, Version two) {
        return one.compareTo(two) < 0;
    }

    private static Version versionOrNull(String version) {
        try {
            return new Version(version);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    static URL findNewestSystemDir(URL root, Extension extension, boolean isSameSystemDirectoryAsBefore) {
        URL[] subdirs = URLFileSystem.list((URL)root);
        if (subdirs == null) {
            return root;
        }
        String extensionId = extension.getID();
        Version extensionVersion = extension.getVersion();
        Version productVersion = null;
        String rootName = URLFileSystem.getFileName((URL)root);
        if (MigrationManagerImpl.hasPrefix(rootName, "system")) {
            productVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(rootName, "system"));
        }
        Version latestVersion = null;
        URL latestUrl = null;
        for (URL dir : subdirs) {
            if (!URLFileSystem.isDirectory((URL)dir)) continue;
            String name = MigrationManagerImpl.expandExtensionId(URLFileSystem.getFileName((URL)dir));
            Version candidateVersion = null;
            if (productVersion != null && name.equals(extensionId)) {
                candidateVersion = productVersion;
            } else if (MigrationManagerImpl.hasPrefix(name, extensionId + ".")) {
                candidateVersion = MigrationManagerImpl.versionOrNull(MigrationManagerImpl.removePrefix(name, extensionId + "."));
            }
            if (candidateVersion == null) continue;
            if (!isSameSystemDirectoryAsBefore && candidateVersion.equals((Object)extensionVersion)) {
                latestVersion = candidateVersion;
                latestUrl = dir;
                break;
            }
            if (!MigrationManagerImpl.isOlderThan(candidateVersion, extensionVersion) || latestVersion != null && !MigrationManagerImpl.isNewerThan(candidateVersion, latestVersion)) continue;
            latestVersion = candidateVersion;
            latestUrl = dir;
            break;
        }
        if (latestUrl == null) {
            return root;
        }
        return latestUrl;
    }

    @Override
    public boolean startMigratingOnDemand() {
        return initialMigrationDone;
    }

    private void migrateOnDemand(Extension extension, MetaClass metaClass) {
        if (noNagFlag || noMigrateFlag || headless) {
            return;
        }
        if (!migrateFlag && previousMigrationChoice != null && previousMigrationChoice.equalsIgnoreCase("false")) {
            return;
        }
        String savedSourceInstallation = IdeRunStatus.getInstance().getPreviousMigrationSource();
        if (savedSourceInstallation == null || savedSourceInstallation == "") {
            return;
        }
        String className = metaClass.getClassName();
        if (!migrateFlag && IdeRunStatus.getInstance().isExtensionMigratorExecuted(extension, className)) {
            return;
        }
        Migrator migrator = null;
        this.sourceVersion = this.versionFromFolderName(URLFactory.newDirURL((String)savedSourceInstallation));
        boolean isSameSystemDirectoryAsBefore = new File(Ide.getSystemDirectory()).equals(savedSourceInstallation);
        URL sourceInstallationURL = MigrationManagerImpl.findNewestSystemDir(URLFactory.newFileURL((String)savedSourceInstallation), extension, isSameSystemDirectoryAsBefore);
        File src = new File(URLFileSystem.getPlatformPathName((URL)sourceInstallationURL));
        URL url = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(extension.getID());
        File dest = new File(url.getPath());
        try {
            Class<?> clazz = Class.forName(metaClass.getClassName(), true, metaClass.getClassLoader());
            migrator = (Migrator)clazz.newInstance();
            int[] categories = migrator.getMigrationCategories();
            for (int index = 0; index < categories.length; ++index) {
                int category = categories[index];
                migrator.setSelected(category, migrator.canMigrate(category, src));
            }
            String[] errors = null;
            errors = migrator.migrate(src, dest);
            IdeRunStatus.getInstance().setExtensionMigratorExecuted(extension, className);
        }
        catch (ClassNotFoundException ex) {
            Assert.println((String)("WARNING: Failed trying to load migrator: " + metaClass.getClassName() + ", " + ex.getMessage()));
        }
        catch (Exception ex) {
            Assert.println((String)("WARNING: Failed trying to load migrator: " + metaClass.getClassName() + ", " + ex.getMessage()));
        }
    }

    @Override
    public void addLazyMigrator(Extension extension, MetaClass metaClass) {
        ArrayList<Object> ml = this.lazyRegisterdMigrators.get(extension);
        if (ml == null) {
            ml = new ArrayList();
            this.lazyRegisterdMigrators.put(extension, ml);
        }
        ml.add(metaClass);
    }

    @Override
    public void migrateExtension(Extension extension) {
        if (this.lazyRegisterdMigrators.containsKey(extension)) {
            ArrayList<MetaClass> mclist = this.lazyRegisterdMigrators.remove(extension);
            for (MetaClass metaClass : mclist) {
                this.migrateOnDemand(extension, metaClass);
            }
        }
    }

    @Override
    public void migrateRecentlyInitializedExtension() {
        HashMap<Extension, ArrayList<MetaClass>> lazyRegisterdMigratorsCopy = this.lazyRegisterdMigrators;
        this.lazyRegisterdMigrators = new HashMap();
        for (Extension ext : lazyRegisterdMigratorsCopy.keySet()) {
            ArrayList<MetaClass> mclist = lazyRegisterdMigratorsCopy.get(ext);
            for (MetaClass metaClass : mclist) {
                this.migrateOnDemand(ext, metaClass);
            }
        }
    }

    @Override
    public File getSourceInstallationIfAvailable() {
        return sourceInstallation;
    }

    @Override
    public Version getSourceVersion() {
        return this.sourceVersion;
    }

    protected void setSourceVersion(Version v) {
        this.sourceVersion = v;
    }

    @Override
    public Version getCurrentVersion() {
        return this.currentVersion;
    }

    static {
        Object2Dom.obsoleteClassNames.add("oracle.jdeveloper.ceditor.template.TemplateOptions");
        Object2Dom.obsoleteClassNames.add("oracle.jdevimpl.runner.profile.ProfilerSettings");
        Object2Dom.obsoleteClassNames.add("oracle.jdevimpl.cm.dt.config.ConnectionOptions");
        previousMigrationChoice = null;
        sourceInstallation = null;
        migrateFlag = false;
        noMigrateFlag = false;
        noNagFlag = false;
        headless = false;
    }

    private static final class WorkspacesMigrator
    implements Runnable {
        MigrationManagerImpl _manager;

        WorkspacesMigrator(MigrationManagerImpl manager) {
            this._manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MigrationManagerImpl migrationManagerImpl = this._manager;
            synchronized (migrationManagerImpl) {
                block20: {
                    try {
                        Node[] workspaceNodes;
                        MigrationInfo[] minfos;
                        Workspaces workspacesToMigrate = null;
                        Iterator iter = Ide.getSystem().getChildren();
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Element o = iter.next();
                                if (!(o instanceof Workspaces)) continue;
                                workspacesToMigrate = (Workspaces)o;
                                break;
                            }
                        }
                        if (workspacesToMigrate == null) {
                            return;
                        }
                        ArrayList list = new ArrayList();
                        iter = workspacesToMigrate.getChildren();
                        if (iter != null) {
                            while (iter.hasNext()) {
                                Object wo = iter.next();
                                if (!(wo instanceof Workspace)) continue;
                                list.add(wo);
                            }
                        }
                        if (list.size() == 0) {
                            return;
                        }
                        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey((Node)list.get(0)));
                        if (nodeMigrator == null || nodeMigrator.checkVersions(minfos = nodeMigrator.getMigrationInfos(workspaceNodes = list.toArray(new Node[list.size()]))) != MigrationInfo.MIGRATION_PENDING) break block20;
                        MigrationInfo[] resultInfo = nodeMigrator.migrate(minfos);
                        ArrayList<Node> nodes = null;
                        for (int i = 0; i < resultInfo.length; ++i) {
                            if (resultInfo[i].getMigrationStatus() == MigrationInfo.MIGRATION_DONE) continue;
                            Node toRemove = resultInfo[i].getNode();
                            workspacesToMigrate.remove(toRemove);
                            if (nodes == null) {
                                nodes = new ArrayList<Node>();
                            }
                            nodes.add(toRemove);
                        }
                        if (nodes != null && nodes.size() > 0) {
                            UpdateMessage.fireChildrenRemoved(workspacesToMigrate, nodes);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this._manager.migrationDone = true;
                        this._manager.notifyAll();
                    }
                }
                try {
                    Ide.getDefaultProject().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }
}

