/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.ModelUtil;

public class TechnologyScopeUpdateMigrator
extends NodeMigratorHelper {
    private static Logger LOG = Logger.getLogger(TechnologyScopeUpdateMigrator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        try {
            LOG.entering(TechnologyScopeUpdateMigrator.class.getName(), "migrate(MigrationInfo[],TraversableContext)");
            MigrationInfo currInfo = null;
            Workspace workspace = (Workspace)context.get("workspace-node-instance");
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            for (int i = 0; i < infos.length; ++i) {
                Node node;
                currInfo = infos[i];
                if (currInfo.getMigrationStatus() != MigrationInfo.MIGRATION_PENDING || !((node = currInfo.getNode()) instanceof Project)) continue;
                this.migrateProject((Project)node, workspace);
            }
        }
        catch (InterruptedException ie) {
            LOG.log(Level.SEVERE, "Interrupted while migrating to determine technology scopes. Migration was incomplete", ie);
        }
        finally {
            LOG.exiting(TechnologyScopeUpdateMigrator.class.getName(), "migrate(MigrationInfo[],TraversableContext)");
        }
    }

    public void migrateProject(Project project, Workspace workspace) throws InterruptedException {
        Collection<String> detectedTechScopeIds = TechnologyScopeManager.getTechnologyScopeManager().getDetector().detectTechnologyScopeIds(workspace, project);
        ArrayList<String> newTechScopeIds = new ArrayList<String>(detectedTechScopeIds);
        TechnologyScopeConfiguration oldTechScopeConfiguration = TechnologyScopeConfiguration.getInstance(project);
        TechnologyScope oldTechScope = oldTechScopeConfiguration.getTechnologyScope();
        for (String oldTechKey : oldTechScope.getTechnologyKeys()) {
            TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
            if (techRegistry.containsTechKey(oldTechKey)) {
                TechId techId = TechnologyRegistry.getInstance().getTechId(oldTechKey);
                if (techId.isObsolete() || newTechScopeIds.contains(oldTechKey)) continue;
                newTechScopeIds.add(oldTechKey);
                continue;
            }
            newTechScopeIds.add(oldTechKey);
        }
        TechnologyScope techScope = new TechnologyScope();
        techScope.setTechnologyKeys(newTechScopeIds.toArray(new String[newTechScopeIds.size()]));
        if (ModelUtil.areDifferent((Object)oldTechScope, (Object)techScope)) {
            boolean setTechnologies = TechnologyScopeConfiguration.getInstance(project).setTechnologyScope(techScope);
            if (setTechnologies) {
                LOG.log(Level.FINEST, "Added the following technology scopes to project " + project.getShortLabel() + " as result of migration: " + newTechScopeIds);
            } else {
                LOG.log(Level.FINE, "Failed to add the following technology scopes to project " + project.getShortLabel() + " as result of migration: " + newTechScopeIds + ". A possible effect of that is that the project might not initialize all relevant extensions on opening it." + "As a workaround issues arising from that, consider adding all technology scopes you know are relevant to the project manually");
            }
        }
    }

    @Override
    public String getNodeMigratorHelperVersion() {
        return "11.1.2.0.0.5";
    }

    @Override
    public String getNodeMigratorHelperKey() {
        return TechnologyScopeUpdateMigrator.class.getName();
    }
}

