/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.EditorNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.navigation.NavigationPointFactory;
import oracle.ide.navigation.NavigationPointListener;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;

public final class NavigationManagerImpl
extends NavigationManager
implements EditorListener,
NavigationPointListener,
Addin {
    private final Stack<NavigationPoint> _STACK = new Stack();
    private final Map<Class, Class> _EDITOR_MAP = new HashMap<Class, Class>();
    private final Map<NavigationPoint, Action> _ACTION_MAP = new HashMap<NavigationPoint, Action>();
    private final int _HISTORY_MAX = 15;
    private int _navigationLevel = 100;
    private int _stackPointer = -1;
    private int _navigating = 0;
    private NavigationPoint _lastEditLocation;
    private Map<NavigationPoint, View> viewNavigationMap = new HashMap<NavigationPoint, View>();

    public NavigationManagerImpl() {
        EditorManager mgr = EditorManager.getEditorManager();
        if (mgr != null) {
            mgr.addEditorListener(this);
        }
        EnvironOptions options = Ide.getEnvironOptions();
        options.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int level = ((EnvironOptions)((Object)e.getSource())).getNavigationLevel();
                NavigationManagerImpl.this.navigationLevelChanged(level);
            }
        });
        this.navigationLevelChanged(options.getNavigationLevel());
    }

    @Override
    public void initialize() {
        NavigationManager.setNavigationManager(this);
        AddinManager addMgr = AddinManager.getAddinManager();
        Action[] emptyActions = new Action[]{};
        IdeAction backAction = IdeAction.get(73, addMgr.getCommand(73, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(432)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(432)), OracleIcons.getIcon((String)"navigateBack.png"), null, false);
        backAction.putValue("ActionMenuActions", emptyActions);
        IdeAction forwardAction = IdeAction.get(74, addMgr.getCommand(74, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(436)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, StringUtils.getMnemonicKeyCode((String)IdeArb.getString(436)), OracleIcons.getIcon((String)"navigateForward.png"), null, false);
        forwardAction.putValue("ActionMenuActions", emptyActions);
        IdeAction lastEditAction = IdeAction.get(75, addMgr.getCommand(75, "oracle.ide.cmd.NotImplementedCommand"), StringUtils.stripMnemonic((String)IdeArb.getString(440)), IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)StringUtils.getMnemonicKeyCode((String)IdeArb.getString(440)), IdeArb.getInstance(), 442, null, false);
        Menubar menuMgr = Ide.getMenubar();
        JMenu navigateMenu = MenuManager.getJMenu("Navigate");
        JMenuItem backItem = menuMgr.createMenuItem(backAction, 1.0f);
        JMenuItem forwardItem = menuMgr.createMenuItem(forwardAction, MenuConstants.WEIGHT_NAVIGATE_FORWARD);
        JMenuItem lastEditItem = menuMgr.createMenuItem(lastEditAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_LAST_EDIT);
        menuMgr.add(backItem, navigateMenu, 1.0f);
        menuMgr.add(forwardItem, navigateMenu, 1.0f);
        menuMgr.add(lastEditItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        ElementName NAVIGATION_POINT_PROVIDER_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "navigation-point-provider-hook");
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HashStructureHook hook = (HashStructureHook)registry.getHook(NAVIGATION_POINT_PROVIDER_HOOK_NAME);
        if (hook != null) {
            hook.addHashStructureHookListener(new NavigationPointProviderListener());
        }
    }

    @Override
    public synchronized boolean canNavigateBack() {
        return this._stackPointer > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int navigateBack() throws Exception {
        int status = 1;
        try {
            ++this._navigating;
            if (this.canNavigateBack()) {
                this.updateNavigationPoint();
                NavigationPoint point = (NavigationPoint)this._STACK.get(this._stackPointer - 1);
                status = point.navigate();
                if (status == 0) {
                    --this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    @Override
    public synchronized boolean canNavigateForward() {
        int size = this._STACK.size();
        return size > 0 && this._stackPointer < size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int navigateForward() throws Exception {
        int status = 1;
        try {
            ++this._navigating;
            if (this.canNavigateForward()) {
                this.updateNavigationPoint();
                NavigationPoint point = (NavigationPoint)this._STACK.get(this._stackPointer + 1);
                status = point.navigate();
                if (status == 0) {
                    ++this._stackPointer;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int navigateTo(NavigationPoint destination) throws Exception {
        Context context;
        View view;
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().warning("This method must be called on AWT thread. Current thread: " + Thread.currentThread().getName());
        }
        if ((view = (context = destination.getContext()).getView()) != null) {
            this.viewNavigationMap.put(destination, view);
        }
        int status = 1;
        try {
            NavigationPoint stackTopPoint;
            ++this._navigating;
            if (this._navigating == 1) {
                this.updateNavigationPoint();
            }
            status = destination.navigate();
            boolean addToStack = true;
            if (this._STACK.size() > 0 && (stackTopPoint = (NavigationPoint)this._STACK.lastElement()).equals(destination)) {
                addToStack = false;
            }
            if (status == 0 && this._navigating == 1 && addToStack) {
                for (int last = this._STACK.size() - 1; last > this._stackPointer; --last) {
                    NavigationPoint point = this._STACK.pop();
                    point.removeNavigationPointListener(this);
                    this._ACTION_MAP.remove(point);
                }
                this._STACK.push(destination);
                destination.addNavigationPointListener(this);
                if (this._STACK.size() > this._navigationLevel) {
                    NavigationPoint point = (NavigationPoint)this._STACK.remove(0);
                    point.removeNavigationPointListener(this);
                    this._ACTION_MAP.remove(point);
                } else {
                    ++this._stackPointer;
                }
                this.updateHistory();
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    @Override
    public synchronized int navigateTo(NavigationPoint point, boolean isEdit) throws Exception {
        int status = 1;
        if (point != null && (status = this.navigateTo(point)) == 0 && isEdit) {
            this.setLastEdit((NavigationPoint)point.copyTo(null));
        }
        return status;
    }

    @Override
    public void registerEditorNavigationPoint(Class pt, Class editor) {
        if (editor != null) {
            if (pt != null) {
                this._EDITOR_MAP.put(editor, pt);
            } else {
                this._EDITOR_MAP.remove(editor);
            }
        }
    }

    @Override
    public synchronized void setLastEdit(Context context) {
        EditorNavigationPoint point = this.createDefaultNavigationPoint(context);
        if (point != null) {
            try {
                point.navigate();
                point.refresh();
                this.setLastEdit(point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canNavigateToLastEdit() {
        return this._lastEditLocation != null;
    }

    @Override
    public synchronized int navigateToLastEdit() throws Exception {
        int status = 1;
        if (this._lastEditLocation != null) {
            status = this.navigateTo((NavigationPoint)this._lastEditLocation.copyTo(null));
        }
        return status;
    }

    private void setLastEdit(NavigationPoint point) {
        if (point != null) {
            try {
                point.addNavigationPointListener(this);
                if (this._lastEditLocation != null) {
                    this._lastEditLocation.removeNavigationPointListener(this);
                }
                this._lastEditLocation = point;
                this.updateLastEdit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private EditorNavigationPoint createDefaultNavigationPoint(Context context) {
        View view;
        EditorNavigationPoint point = null;
        View view2 = view = context != null ? context.getView() : null;
        if (view == null && context != null) {
            Context ctx;
            EditorManager mgr = EditorManager.getEditorManager();
            Editor editor = mgr != null ? mgr.getCurrentEditor() : null;
            Context context2 = ctx = editor != null ? editor.getContext() : null;
            if (ctx != null && ctx.getNode() == context.getNode()) {
                context = new Context(context);
                context.setView(editor);
                view = editor;
            }
        }
        if (view instanceof Editor) {
            try {
                Class<?> viewCls = view.getClass();
                Class enpCls = this._EDITOR_MAP.get(viewCls);
                if (enpCls == null) {
                    for (viewCls = viewCls.getSuperclass(); viewCls != null && Editor.class.isAssignableFrom(viewCls) && (enpCls = this._EDITOR_MAP.get(viewCls)) == null; viewCls = viewCls.getSuperclass()) {
                    }
                    if (enpCls == null) {
                        enpCls = DefaultNavigationPoint.class;
                    }
                }
                point = (EditorNavigationPoint)enpCls.newInstance();
                point.setContext(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return point;
    }

    private synchronized void navigationLevelChanged(int level) {
        int overage = this._STACK.size() - ++level;
        NavigationPoint orphan = null;
        if (this._stackPointer < overage && level > 0) {
            orphan = (NavigationPoint)this._STACK.remove(this._stackPointer);
        }
        if (overage > 0) {
            List sublist = this._STACK.subList(0, overage);
            ArrayList uniqueList = new ArrayList(sublist);
            Iterator i = uniqueList.iterator();
            if (i != null) {
                while (i.hasNext()) {
                    NavigationPoint point = (NavigationPoint)i.next();
                    point.removeNavigationPointListener(this);
                    this._ACTION_MAP.remove(point);
                }
            }
            this._STACK.removeAll(uniqueList);
            if (orphan != null) {
                this._STACK.add(0, orphan);
                this._stackPointer = 0;
            } else {
                this._stackPointer -= overage;
            }
        }
        this._navigationLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int jumpTo(NavigationPoint destination) throws Exception {
        int status = 1;
        int index = destination != null ? this._STACK.indexOf(destination) : -1;
        try {
            ++this._navigating;
            if (index >= 0) {
                if (this._navigating == 1) {
                    this.updateNavigationPoint();
                }
                if ((status = destination.navigate()) == 0 && this._navigating == 1) {
                    this._stackPointer = index;
                    this.updateHistory();
                }
            }
        }
        finally {
            --this._navigating;
        }
        return status;
    }

    private void updateNavigationPoint() {
        NavigationPoint current = this.getCurrentNavigationPoint();
        if (current != null) {
            current.refresh();
        }
    }

    private synchronized NavigationPoint getCurrentNavigationPoint() {
        return this._stackPointer >= 0 ? (NavigationPoint)this._STACK.get(this._stackPointer) : null;
    }

    private synchronized void updateHistory() {
        IdeAction forwardAction;
        final IdeAction backAction = IdeAction.find(73);
        if (backAction != null) {
            final ArrayList<Action> history = new ArrayList<Action>();
            int minimum = this._stackPointer > 15 ? this._stackPointer - 15 : 0;
            for (int i = this._stackPointer - 1; i >= minimum; --i) {
                history.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(i)));
            }
            Runnable actionUpdater = new Runnable(){

                @Override
                public void run() {
                    backAction.putValue("ActionMenuActions", history.toArray(new Action[history.size()]));
                    if (history.size() > 0) {
                        NavigationManagerImpl.this.updateBackTooltip((Action)history.get(0));
                    } else {
                        NavigationManagerImpl.this.updateBackTooltip(null);
                    }
                    backAction.updateAction();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                actionUpdater.run();
            } else {
                SwingUtilities.invokeLater(actionUpdater);
            }
        }
        if ((forwardAction = IdeAction.find(74)) != null) {
            final ArrayList<Action> history = new ArrayList<Action>();
            int size = this._STACK.size();
            int maximum = size - 1 - this._stackPointer > 15 ? this._stackPointer + 15 : size - 1;
            for (int i = this._stackPointer + 1; i <= maximum; ++i) {
                history.add(this.findOrCreateAction((NavigationPoint)this._STACK.get(i)));
            }
            Runnable actionUpdater = new Runnable(){

                @Override
                public void run() {
                    forwardAction.putValue("ActionMenuActions", history.toArray(new Action[history.size()]));
                    if (history.size() > 0) {
                        NavigationManagerImpl.this.updateForwardTooltip((Action)history.get(0));
                    } else {
                        NavigationManagerImpl.this.updateForwardTooltip(null);
                    }
                    forwardAction.updateAction();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                actionUpdater.run();
            } else {
                SwingUtilities.invokeLater(actionUpdater);
            }
        }
    }

    private void updateBackTooltip(Action action) {
        IdeAction backAction = IdeAction.find(73);
        if (backAction != null) {
            if (action != null) {
                String tooltip = (String)action.getValue("ShortDescription");
                backAction.putValue("ShortDescription", IdeArb.format(435, new String[]{tooltip}));
            } else {
                backAction.putValue("ShortDescription", IdeArb.getString(432));
            }
        }
    }

    private void updateForwardTooltip(Action action) {
        IdeAction forwardAction = IdeAction.find(74);
        if (forwardAction != null) {
            if (action != null) {
                String tooltip = (String)action.getValue("ShortDescription");
                forwardAction.putValue("ShortDescription", IdeArb.format(439, new String[]{tooltip}));
            } else {
                forwardAction.putValue("ShortDescription", IdeArb.getString(436));
            }
        }
    }

    private void updateLastEdit() {
        IdeAction lastEditAction = IdeAction.find(75);
        if (lastEditAction != null) {
            lastEditAction.setEnabled(this.canNavigateToLastEdit());
        }
    }

    private synchronized Action findOrCreateAction(NavigationPoint point) {
        Action action = null;
        if (point != null && (action = this._ACTION_MAP.get(point)) == null) {
            action = new HistoryAction(point);
            this._ACTION_MAP.put(point, action);
        }
        return action;
    }

    @Override
    public void editorOpened(Editor editor) {
    }

    @Override
    public void editorDeactivated(Editor editor) {
    }

    @Override
    public synchronized void editorClosed(Editor editor) {
        EditorManager eMgr;
        List<Editor> editorList;
        if (this._navigating == 0 && ((editorList = (eMgr = EditorManager.getEditorManager()).getAllEditors()) == null || editorList.size() == 0)) {
            this._STACK.clear();
            this.viewNavigationMap.clear();
            this._stackPointer = -1;
            return;
        }
        ArrayList<NavigationPoint> iterationList = new ArrayList<NavigationPoint>(this._STACK);
        for (NavigationPoint point : iterationList) {
            View view = this.viewNavigationMap.get(point);
            if (view == null || !editor.equals(view) || this.isRestorable(editor)) continue;
            this.expired(point);
        }
        HashSet<NavigationPoint> points = new HashSet<NavigationPoint>(this.viewNavigationMap.keySet());
        for (NavigationPoint point : points) {
            if (!this.viewNavigationMap.get(point).equals(editor)) continue;
            this.viewNavigationMap.remove(point);
        }
        HashMap<NavigationPoint, View> _viewNavigationMap = new HashMap<NavigationPoint, View>();
        for (NavigationPoint point : this._STACK) {
            View view = this.viewNavigationMap.get(point);
            if (view == null) continue;
            _viewNavigationMap.put(point, this.viewNavigationMap.get(point));
        }
        this.viewNavigationMap = _viewNavigationMap;
    }

    private boolean isRestorable(Editor editor) {
        Context context = editor.getContext();
        View view = context.getView();
        if (view instanceof Editor) {
            EditorAddin addin = ((Editor)view).getEditorAddin();
            if (addin == null) {
                Class<?> viewClass = view.getClass();
                addin = EditorManager.getEditorManager().getEditorAddin(viewClass);
            }
            if (addin != null && !EditorManagerImpl.isRestorable(context, addin)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void editorActivated(Editor editor) {
        if (this._navigating == 0) {
            View view;
            NavigationPoint current = this.getCurrentNavigationPoint();
            Context context = current != null ? current.getContext() : null;
            View view2 = view = context != null ? context.getView() : null;
            if (view != null) {
                this.viewNavigationMap.put(current, view);
            }
            if (view == editor) {
                return;
            }
            Context context2 = context = editor != null ? editor.getContext() : null;
            if (context != null) {
                try {
                    EditorNavigationPoint point = this.createDefaultNavigationPoint(context);
                    if (point != null) {
                        this.navigateTo(point);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void expired(NavigationPointEvent e) {
        NavigationPoint point = e != null ? (NavigationPoint)e.getSource() : null;
        this.expired(point);
    }

    private void expired(NavigationPoint point) {
        if (point != null) {
            int index = this._STACK.indexOf(point);
            if (index >= 0) {
                point.removeNavigationPointListener(this);
                this._STACK.remove(point);
                this._ACTION_MAP.remove(point);
                if (this._stackPointer >= index) {
                    --this._stackPointer;
                }
                this.updateHistory();
            } else if (point == this._lastEditLocation) {
                point.removeNavigationPointListener(this);
                this._lastEditLocation = null;
                this.updateLastEdit();
            }
        }
    }

    @Override
    public synchronized void descriptionChanged(NavigationPointEvent e) {
        Action action;
        NavigationPoint point = e != null ? (NavigationPoint)e.getSource() : null;
        Action action2 = action = point != null ? this._ACTION_MAP.get(point) : null;
        if (action != null) {
            int index;
            Object newValue = point.getIcon();
            if (action.getValue("SmallIcon") != newValue) {
                action.putValue("SmallIcon", newValue);
            }
            newValue = point.getLongLabel();
            if (action.getValue("Name") != newValue) {
                action.putValue("Name", newValue);
            }
            newValue = point.getShortLabel();
            if (action.getValue("ShortDescription") != newValue) {
                action.putValue("ShortDescription", newValue);
            }
            if ((index = this._STACK.indexOf(point)) == this._stackPointer - 1) {
                this.updateBackTooltip(action);
            } else if (index == this._stackPointer + 1) {
                this.updateForwardTooltip(action);
            }
        }
    }

    private static class NavigationPointProviderListener
    implements HashStructureHookListener {
        private NavigationPointProviderListener() {
        }

        @Override
        public void elementVisited(HashStructureHookEvent e) {
            this.handleData(e.getNewElementHashStructure());
        }

        @Override
        public void listenerAttached(HashStructureHookEvent e) {
            this.handleData(e.getCombinedHashStructure());
        }

        private void handleData(HashStructure hashStructure) {
            List l = hashStructure.getAsList("factory-class");
            if (l != null) {
                for (HashStructure o : l) {
                    LazyClassAdapter classAdapter = LazyClassAdapter.getInstance(o);
                    navigationPointFactories.add(classAdapter.createInstance(NavigationPointFactory.class, "#text"));
                }
            }
        }
    }

    private final class HistoryAction
    extends ToggleAction
    implements MenuToolButton.UpdatableMenuAction {
        NavigationPoint point;

        HistoryAction(NavigationPoint point) {
            super(point.getLongLabel(), point.getIcon());
            this.point = point;
            this.putValue("ShortDescription", point.getShortLabel());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                NavigationManagerImpl.this.jumpTo(this.point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object getValue(String key) {
            if (key == "Name") {
                return this.point.getLongLabel();
            }
            if (key == "ShortDescription") {
                return this.point.getShortLabel();
            }
            return super.getValue(key);
        }

        @Override
        public void updateAction() {
            this.putValue("Name", this.getValue("Name"));
            this.putValue("ShortDescription", this.getValue("ShortDescription"));
        }
    }
}

