/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.ui;

import java.io.File;
import java.text.MessageFormat;
import oracle.ide.model.Node;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeNameRenderer;

class ExternalSourceNameRenderer
implements IdeModelTreeNameRenderer {
    final String m_name;
    final String m_message;

    ExternalSourceNameRenderer(String projectName, String message) {
        this.m_name = projectName;
        this.m_message = message;
    }

    ExternalSourceNameRenderer(String message) {
        this("", message);
    }

    ExternalSourceNameRenderer deriveNewExternalSourceNameRenderer(String projectName) {
        return new ExternalSourceNameRenderer(projectName, this.m_message);
    }

    @Override
    public String fileToText(File f) {
        String file = f.getPath();
        return file + " " + MessageFormat.format(this.m_message, this.m_name);
    }

    @Override
    public String fileToTooltipText(File f) {
        return f.getAbsolutePath();
    }

    @Override
    public String nodeToString(Node n) {
        return this.fileToText(FileSystemModelUtils.urlToFile(n.getURL()));
    }
}

