/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.util.BitField;

public final class DropFileUtil {
    private static DropTargetListener defaultDropFileListener;
    public static final DataFlavor uriListFlavor;

    private DropFileUtil() {
    }

    public static DropTargetListener getDefaultDropFileListener() {
        if (defaultDropFileListener == null) {
            defaultDropFileListener = new DropFileListener();
        }
        return defaultDropFileListener;
    }

    public static boolean canDrop(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        boolean isValidAction = BitField.isSet(dropAction, 1) || BitField.isSet(dropAction, 2);
        return isValidAction && (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(uriListFlavor));
    }

    public static boolean canDropEditorNode(DropTargetDragEvent dtde) {
        boolean isValidAction;
        int dropAction = dtde.getDropAction();
        boolean bl = isValidAction = BitField.isSet(dropAction, 1) || BitField.isSet(dropAction, 2);
        if (!isValidAction) {
            return false;
        }
        boolean hasAddin = false;
        if (dtde.isDataFlavorSupported(TransferableContext.contextFlavor)) {
            Collection<Context> contexts = DropFileUtil.getContextForDnDEvent(dtde.getTransferable());
            for (Context context : contexts) {
                if (EditorManager.getEditorManager().getDefaultAddin(context) == null) continue;
                hasAddin = true;
                break;
            }
        }
        return isValidAction && hasAddin;
    }

    public static boolean canDrop(DropTargetDropEvent dtde) {
        int dropAction = dtde.getDropAction();
        boolean isValidAction = BitField.isSet(dropAction, 1) || BitField.isSet(dropAction, 2);
        return isValidAction && (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(uriListFlavor));
    }

    public static boolean drop(DropTargetDropEvent dtde) {
        boolean bRet = false;
        try {
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(uriListFlavor)) {
                EditorManager editorManager = EditorManager.getEditorManager();
                dtde.acceptDrop(3);
                List list = dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? (List)transferable.getTransferData(DataFlavor.javaFileListFlavor) : DropFileUtil.uriTransferableToFileList(transferable);
                for (File file : list) {
                    bRet &= DropFileUtil.drop(editorManager, file);
                }
                dtde.getDropTargetContext().dropComplete(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public static List uriTransferableToFileList(Transferable transferable) throws UnsupportedFlavorException, IOException {
        String data = (String)transferable.getTransferData(uriListFlavor);
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return list;
    }

    private static boolean drop(EditorManager editorManager, File f) {
        boolean bRet = true;
        if (f.isFile()) {
            URL fileURL = URLFactory.newFileURL((File)f);
            Editor ed = EditorUtil.openDefaultEditorInFrame(fileURL);
            if (ed == null) {
                bRet = false;
            } else {
                EditorManager.getEditorManager().setExplicit(ed, true);
            }
        } else {
            File[] subs = f.listFiles();
            for (int i = 0; i < subs.length; ++i) {
                bRet &= DropFileUtil.drop(editorManager, subs[i]);
            }
        }
        return bRet;
    }

    public static void dropEditorFile(DropTargetDropEvent dtde) {
        if (dtde.isDataFlavorSupported(TransferableContext.contextFlavor)) {
            Collection<Context> contexts = DropFileUtil.getContextForDnDEvent(dtde.getTransferable());
            EditorManager editorManager = EditorManager.getEditorManager();
            for (Context context : contexts) {
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                editorManager.openEditor(openEditorOptions);
            }
        } else if (DropFileUtil.canDrop(dtde)) {
            DropFileUtil.drop(dtde);
        }
    }

    private static Collection<Context> getContextForDnDEvent(Transferable transferable) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        try {
            TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
            Context context = transferableContext.getContext();
            Element[] selection = context.getSelection();
            if (selection != null) {
                for (Element element : selection) {
                    if (!(element instanceof Node)) continue;
                    Node node = (Node)element;
                    Context myContext = new Context(context.getView(), context.getWorkspace(), context.getProject(), node);
                    contexts.add(myContext);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contexts;
    }

    static {
        DataFlavor tempUriListFlavor = null;
        try {
            tempUriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage());
        }
        uriListFlavor = tempUriListFlavor;
    }

    public static class DropFileListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.handleDropTargetDragEvent(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropFileUtil.drop(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        private void handleDropTargetDragEvent(DropTargetDragEvent dtde) {
            if (DropFileUtil.canDrop(dtde)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }
    }
}

