/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.vcs.VCSRegistry;
import oracle.ideimpl.vcs.VCSRecognizer;
import oracle.ideimpl.vcs.VCSRecognizers;

public final class VCSOnDemandURLFileSystemHelper
extends URLFileSystemHelperDecorator {
    private final NodeListener _l = new NodeListener(){

        @Override
        public void nodeOpened(NodeEvent e) {
            VCSOnDemandURLFileSystemHelper.this._nodeOpened(e.getNode());
        }
    };
    private final ExecutorService _executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();

        @Override
        public final Thread newThread(Runnable r) {
            Thread t = this._delegate.newThread(r);
            t.setName("VCSOnDemandURLFileSystemHelper");
            return t;
        }
    });
    private boolean _attached;
    private boolean _checkenv = true;

    public VCSOnDemandURLFileSystemHelper(URLFileSystemHelper helper) {
        super(helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(URL url) throws IOException {
        String suffix = this.getSuffix(url);
        if (!this._attached && (suffix.equals(".jws") || suffix.equals(".jpr"))) {
            VCSOnDemandURLFileSystemHelper vCSOnDemandURLFileSystemHelper = this;
            synchronized (vCSOnDemandURLFileSystemHelper) {
                if (!this._attached) {
                    Node.addNodeListenerForType(Project.class, this._l);
                    Node.addNodeListenerForType(Workspace.class, this._l);
                    this._attached = true;
                }
            }
        }
        return super.openInputStream(url);
    }

    private final void _nodeOpened(final Node node) {
        this._executor.submit(new Runnable(){

            @Override
            public final void run() {
                if (VCSOnDemandURLFileSystemHelper.this._checkenv) {
                    if (VCSOnDemandURLFileSystemHelper.this.isCheckEnvironmentVarsRequired()) {
                        VCSOnDemandURLFileSystemHelper.this.checkEnvironmentVars();
                    }
                    VCSOnDemandURLFileSystemHelper.this._checkenv = false;
                }
                if (node instanceof Workspace) {
                    VCSOnDemandURLFileSystemHelper.this.checkForAdminPath(URLFileSystem.getParent((URL)((Workspace)node).getURL()));
                }
                if (node instanceof Project) {
                    VCSOnDemandURLFileSystemHelper.this.checkForAdminPath(URLFileSystem.getParent((URL)((Project)node).getURL()));
                    node.runUnderReadLock(new Runnable(){

                        @Override
                        public final void run() {
                            for (URL contentDir : ProjectContent.getInstance((Project)node).getAllContents().getAllRootDirs()) {
                                VCSOnDemandURLFileSystemHelper.this.checkForAdminPath(contentDir);
                            }
                        }
                    });
                }
            }
        });
    }

    private final boolean isCheckEnvironmentVarsRequired() {
        for (VCSRecognizer recognizer : VCSRecognizers.getInstance().getRecognizers()) {
            if (recognizer.getEnvironmentVariableName() == null) continue;
            return true;
        }
        return false;
    }

    private final void checkEnvironmentVars() {
        Map<String, String> env = System.getenv();
        for (VCSRecognizer recognizer : VCSRecognizers.getInstance().getRecognizers()) {
            String name = recognizer.getEnvironmentVariableName();
            if (name == null || !env.containsKey(name)) continue;
            String valueRegExp = recognizer.getEnvironmentVariableValueRegexp();
            if (valueRegExp == null) {
                this.loadExtension(recognizer);
                continue;
            }
            String value = env.get(name);
            if (value == null || !value.matches(valueRegExp)) continue;
            this.loadExtension(recognizer);
        }
    }

    private final void checkForAdminPath(URL contentDir) {
        for (VCSRecognizer recognizer : VCSRecognizers.getInstance().getRecognizers()) {
            String adminPath = recognizer.getAdministrativePath();
            if (adminPath == null || !URLFileSystem.exists((URL)URLFactory.newURL((URL)contentDir, (String)adminPath))) continue;
            this.loadExtension(recognizer);
        }
    }

    private final void loadExtension(VCSRecognizer recognizer) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        er.fullyLoadExtension(er.findExtension(recognizer.getExtensionID()));
        VCSRegistry.getInstance();
        if (VCSRegistry.lookup(recognizer.getExtensionID()) == null) {
            throw new IllegalStateException("Illegal attempt to load non-VCS extension using vcs-recognizer-hook");
        }
    }
}

