/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbbridge;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import oracle.ide.net.FileLocator;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class IdeClassLoaderDelegateHook
implements ClassLoaderDelegateHook,
HookConfigurator {
    private AtomicInteger stackOverFlowProtectionCounter = new AtomicInteger(0);
    private static String jaxbContextFactory = System.getProperty(JAXBContext.class.getName());
    private static List<String> RESOURCE_EXEMPT_PATHS = new ArrayList<String>();

    public Class<?> preFindClass(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws ClassNotFoundException {
        return null;
    }

    private static String getPackageFromFQN(String FQN) {
        int indexOfLastPackageDot = FQN.lastIndexOf(".");
        if (indexOfLastPackageDot != -1) {
            return FQN.substring(0, indexOfLastPackageDot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<?> postFindClass(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws ClassNotFoundException {
        if (!string.equals(jaxbContextFactory)) return null;
        if (this.stackOverFlowProtectionCounter.getAndIncrement() == 0) {
            try {
                Bundle br = bundleClassLoader.getBundle();
                br.start();
                BundleContext bundleContext = br.getBundleContext();
                ServiceReference ref = bundleContext.getServiceReference(PackageAdmin.class);
                PackageAdmin admin = (PackageAdmin)bundleClassLoader.getBundle().getBundleContext().getService(ref);
                String packageOfJAXBFactoryValue = IdeClassLoaderDelegateHook.getPackageFromFQN(jaxbContextFactory);
                ExportedPackage exportedPackage = admin.getExportedPackage(packageOfJAXBFactoryValue);
                if (exportedPackage == null) return null;
                Bundle bundle = exportedPackage.getExportingBundle();
                Class clazz = bundle.loadClass(string);
                return clazz;
            }
            catch (BundleException be) {
                return null;
            }
            finally {
                this.stackOverFlowProtectionCounter.getAndDecrement();
            }
        } else {
            this.stackOverFlowProtectionCounter.getAndDecrement();
        }
        return null;
    }

    public URL preFindResource(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        if (string != null && string.endsWith("NativeLibLoader.class")) {
            try {
                URL untranslatedURL = bundleClassLoader.findLocalResource(string);
                return untranslatedURL != null ? FileLocator.resolve((URL)untranslatedURL) : untranslatedURL;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public URL postFindResource(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> preFindResources(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> postFindResources(String resPath, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        for (String resourceExemptPath : RESOURCE_EXEMPT_PATHS) {
            if (!resourceExemptPath.equals(resPath)) continue;
            throw new FileNotFoundException("not an error: this is used as flow control to skip buddy loading of resources");
        }
        return null;
    }

    public String preFindLibrary(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) throws FileNotFoundException {
        return null;
    }

    public String postFindLibrary(String string, BundleClassLoader bundleClassLoader, BundleData bundleData) {
        return null;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoaderDelegateHook((ClassLoaderDelegateHook)this);
    }

    static {
        String buddyDelegationResourceExempts = System.getProperty("oracle.ide.osgi.buddy.delegate.resource.exempt.paths");
        if (buddyDelegationResourceExempts != null) {
            String[] exemptPaths;
            for (String exemptPath : exemptPaths = buddyDelegationResourceExempts.split(",")) {
                if (exemptPaths == null) continue;
                RESOURCE_EXEMPT_PATHS.add(exemptPath);
            }
        }
    }
}

