/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;

public class UpgradeRunner
extends AbstractMigrationProgressRunnable {
    private int m_currentRepoVsn;
    private int m_firstVsn;
    private int m_lastVsn;
    private ArrayList<String> m_scripts;
    private RunRepositoryScripts m_worker;
    private JPanel m_downPanel;
    private JLabel m_downLabel;
    private int m_softwareVsn;
    HashMap<Integer, Integer> _upgrades = new HashMap();

    public UpgradeRunner(int n, int n2, ArrayList<String> arrayList, RunRepositoryScripts runRepositoryScripts) {
        this.m_currentRepoVsn = n;
        this.m_softwareVsn = n2;
        this.m_scripts = arrayList;
        this.m_worker = runRepositoryScripts;
        this.m_worker.setProgressBar(this);
        this.m_worker.setMode(3);
        this.setUseBuzyBar(true);
        this.setTitle(MigrationAddinArb.getString("MIGRATION_REPOSITORY_UPGRADE"));
        this.m_downPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.m_downPanel.setLayout(borderLayout);
        this.m_downLabel = new JLabel();
        this.m_downPanel.add((Component)this.m_downLabel, "West");
    }

    @Override
    protected Object doWork() throws Exception {
        int n = this.m_currentRepoVsn;
        boolean bl = true;
        this.setVersionNumbers(this.m_scripts);
        if (!this.upgradeAvailable(this.m_currentRepoVsn, this.m_softwareVsn)) {
            this.m_worker.setSuccess(false);
        } else {
            String string;
            while (n < this.m_softwareVsn && (string = RepositoryManager.findNextUpgradeScript(n, this.m_scripts)) != null) {
                this.m_worker.setScript(string);
                this.setMessage(this.getUpgradeMessage(string));
                this.m_worker.run();
                try {
                    n = RepositoryManager.getCurentRepoVersion(this.m_worker.getConnection());
                }
                catch (Exception exception) {
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.setMessage(this.getFinalMessage());
            } else {
                this.setMessage(MigrationAddinArb.getString("REPO_VSN_FOR_UPGRADE"));
            }
        }
        return this.m_worker.getSuccess();
    }

    private boolean upgradeAvailable(int n, int n2) {
        Integer n3 = n;
        while (n3 != null && this._upgrades.containsKey(n3) && n3 < n2) {
            n3 = this._upgrades.get(n3);
        }
        return n3 == n2;
    }

    private String getFinalMessage() {
        String string = MigrationAddinArb.getString("MIGRATION_UPGRADED") + " " + this.m_firstVsn + " " + this.m_lastVsn + MigrationAddinArb.getString("MIGRATION_COMPLETE");
        return string;
    }

    private void setVersionNumbers(ArrayList<String> arrayList) {
        this.m_firstVsn = this.m_currentRepoVsn;
        for (String string : arrayList) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this._upgrades.put(Integer.parseInt(string2), Integer.parseInt(string3));
            this.m_lastVsn = Integer.parseInt(string3);
        }
    }

    public void setScript(String string) {
        this.m_worker.setScript(string);
        this.setMessage(this.getUpgradeMessage(string));
    }

    private String getUpgradeMessage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = MigrationAddinArb.getString("MIGRATION_UPGRADING") + " " + string2 + " " + MigrationAddinArb.getString("MIGRATION_TO") + " " + string3;
        return string4;
    }

    @Override
    public void updateAbovePanel(Object object) {
    }

    public void setUpgradeScripts(ArrayList<String> arrayList) {
        this.m_scripts = arrayList;
    }

    @Override
    public JPanel getTopPanel() {
        return null;
    }

    @Override
    public JPanel getDownPanel() {
        return this.m_downPanel;
    }

    @Override
    public void updateBelowPanel(final Object object) {
        if (object instanceof String) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UpgradeRunner.this.m_downLabel.setText((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

