/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.PlatformDatabaseListProvider;
import oracle.dbtools.raptor.utils.Connections;

public class PostgreSQLDatabaseListProvider
implements PlatformDatabaseListProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getOnlineDatabaseNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            int n = connection.getMetaData().getDatabaseMajorVersion();
            String string2 = null;
            if (n >= 8) {
                string2 = "select SCHEMA_NAME \"DATABASE\" from information_schema.schemata where (SCHEMA_NAME NOT IN ('information_schema','pg_catalog'))";
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("DATABASE");
                if (string3 == null) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return arrayList;
    }

    @Override
    public boolean isSystemDatabase(String string) {
        boolean bl = string != null ? string.equals("PostgreSQL") || string.equals("information_schema") : false;
        return bl;
    }

    @Override
    public ArrayList<String> getAvailableOnlineDatabaseList(String string) {
        return this.getOnlineDatabaseNames(string);
    }

    @Override
    public ArrayList<String> getAvailableOfflineDatabaseList(String string) {
        return null;
    }
}

