/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.ddtestframework.DirOnlyFilter;
import oracle.dbtools.ddtestframework.FileUtil;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.TranslationLogging;
import oracle.dbtools.migration.core.util.MultiLevelLogManager;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.PluginDescriptor;

public class TranslateCmd
extends MigrationCmd {
    public static final String CMDNAME = "translate";
    private TranslateDetails m_translateDetails = null;

    public TranslateCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_translateDetails = new TranslateDetails(migrationDetails);
        this.m_isPersistenceManagerRequired = false;
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        ArrayList<File> arrayList = this.getFiles();
        for (File file : arrayList) {
            String string = this.readFile(file);
            String string2 = this.translate(string);
            this.saveFile(this.getOutputFile(file), string2);
        }
    }

    private File getOutputFile(File file) {
        File file2 = null;
        if (this.m_translateDetails.hasDirList()) {
            ArrayList<File> arrayList = this.m_translateDetails.getDirList();
            String string = file.getAbsolutePath();
            for (File file3 : arrayList) {
                String string2 = file3.getAbsolutePath();
                if (!string.startsWith(string2)) continue;
                String string3 = string.substring(string.indexOf(string2) + string2.length());
                file2 = new File(this.getMigrationDetails().getOutputDir() + string3);
                return file2;
            }
            file2 = new File(this.getMigrationDetails().getOutputDir() + File.separator + file.getName());
            return file2;
        }
        file2 = new File(this.getMigrationDetails().getOutputDir() + File.separator + file.getName());
        return file2;
    }

    private String translate(String string) {
        Object object;
        String string2;
        Object object2;
        Map<String, PluginDescriptor> map = MigrationAddin.getPlugins();
        MigrationPlugin migrationPlugin = null;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = map.get(iterator.next());
            string2 = this.m_translateDetails.getTranslator().toLowerCase().trim();
            object = ((PluginDescriptor)object2).getClassName().replaceAll(" ", "").toLowerCase().trim();
            if (!((String)object).endsWith(string2)) continue;
            migrationPlugin = ((PluginDescriptor)object2).getPlugin();
        }
        object2 = (ITranslationAll)migrationPlugin.getConverter().getPlaformTranslator();
        string2 = null;
        object = new MultiLevelLogManager();
        TranslationLogging translationLogging = new TranslationLogging(MigrationAddin.getPersistenceManager(), (MultiLevelLogManager)object);
        try {
            string2 = object2.translateAndGetASTS(string);
        }
        catch (Exception exception) {
            return null;
        }
        return string2.getTargetString();
    }

    private void saveFile(File file, String string) {
        try {
            file.getParentFile().mkdirs();
            FileUtil.appendToFile((File)file, (String)string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String readFile(File file) {
        return FileUtil.readFile((String)file.getAbsolutePath());
    }

    private ArrayList<File> getFiles() {
        ArrayList<File> arrayList = null;
        if (this.m_translateDetails.hasFileList()) {
            arrayList = this.m_translateDetails.getFileList();
        } else if (this.m_translateDetails.hasDirList()) {
            arrayList = new ArrayList();
            ArrayList<File> arrayList2 = this.m_translateDetails.getDirList();
            for (File file : arrayList2) {
                arrayList.addAll(this.getFiles(file, this.m_translateDetails.isRecursive()));
            }
            return arrayList;
        }
        return arrayList;
    }

    private ArrayList<File> getFiles(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return !file2.isDirectory();
            }
        };
        if (this.m_translateDetails.hasExtFilter()) {
            filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (file2.isDirectory()) {
                        return false;
                    }
                    ArrayList<String> arrayList = TranslateCmd.this.m_translateDetails.getFilterList();
                    for (String string2 : arrayList) {
                        if (!string.endsWith(string2)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        File[] fileArray = file.listFiles(filenameFilter);
        if (file == null) {
            System.out.println("Cannot find directory:" + file.getPath());
        }
        arrayList.addAll(Arrays.asList(fileArray));
        if (bl) {
            File[] fileArray2;
            for (File file2 : fileArray2 = file.listFiles((FilenameFilter)new DirOnlyFilter())) {
                arrayList.addAll(this.getFiles(file2, bl));
            }
        }
        return arrayList;
    }

    class TranslateDetails {
        MigrationDetails m_details = null;

        TranslateDetails(MigrationDetails migrationDetails) {
            this.m_details = migrationDetails;
        }

        public ArrayList<File> getDirList() {
            String[] stringArray;
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = this.m_details.get("dir");
            for (String string2 : stringArray = string.split(",")) {
                File file = new File(string2);
                arrayList.add(file);
            }
            return arrayList;
        }

        public String getTranslator() {
            return this.m_details.get("translator");
        }

        public ArrayList<String> getFilterList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = this.m_details.get("ext");
            String[] stringArray = string.split(",");
            arrayList.addAll(Arrays.asList(stringArray));
            return arrayList;
        }

        public boolean hasExtFilter() {
            return this.m_details.contains("ext");
        }

        public boolean isRecursive() {
            return this.m_details.contains("r");
        }

        public boolean hasDirList() {
            return this.m_details.contains("dir");
        }

        public ArrayList<File> getFileList() {
            String[] stringArray;
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = this.m_details.get("file");
            for (String string2 : stringArray = string.split(",")) {
                File file = new File(string2);
                arrayList.add(file);
            }
            return arrayList;
        }

        public boolean hasFileList() {
            return this.m_details.contains("file");
        }
    }
}

