/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.Messages;

public class DataTypeConversionMap {
    private HashMap<DataTypeSpecification, DataTypeMappingRule> m_map = new HashMap();
    private HashMap<DataTypeSpecification, DataTypeMappingRule> m_udtMap = new HashMap();

    public void addRule(DataTypeMappingRule dataTypeMappingRule) {
        if (this.m_map.containsKey(dataTypeMappingRule.getSourceDataType())) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("DataTypeConversionMap.0"), dataTypeMappingRule.getSourceDataType().toString()));
        }
        this.m_map.put(dataTypeMappingRule.getSourceDataType(), dataTypeMappingRule);
    }

    public void addOrReplaceRule(DataTypeMappingRule dataTypeMappingRule) {
        if (this.m_map.containsKey(dataTypeMappingRule.getSourceDataType())) {
            this.m_map.remove(dataTypeMappingRule.getSourceDataType());
        }
        this.addRule(dataTypeMappingRule);
    }

    public void addUDTRule(DataTypeMappingRule dataTypeMappingRule) {
        if (this.m_udtMap.containsKey(dataTypeMappingRule.getSourceDataType())) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("DataTypeConversionMap.1"), dataTypeMappingRule.getSourceDataType().toString()));
        }
        this.m_udtMap.put(dataTypeMappingRule.getSourceDataType(), dataTypeMappingRule);
    }

    /*
     * WARNING - void declaration
     */
    public DataTypeSpecification mapDataType(DataTypeSpecification dataTypeSpecification) {
        void var7_10;
        Integer n;
        DataTypeMappingRule dataTypeMappingRule = null;
        int n2 = 0;
        if (this.m_map.containsKey(dataTypeSpecification)) {
            dataTypeMappingRule = this.m_map.get(dataTypeSpecification);
            return dataTypeMappingRule.getTargetDataType();
        }
        if (this.m_udtMap != null && this.m_udtMap.containsKey(dataTypeSpecification)) {
            dataTypeMappingRule = this.m_udtMap.get(dataTypeSpecification);
            return dataTypeMappingRule.getTargetDataType();
        }
        Collection<DataTypeMappingRule> collection = this.m_map.values();
        for (DataTypeMappingRule object2 : collection) {
            int n3 = object2.getRuleMatchScore(dataTypeSpecification);
            if (n3 <= n2) continue;
            dataTypeMappingRule = object2;
            n2 = n3;
        }
        if (n2 == 0) {
            return new DataTypeSpecification("UDT." + dataTypeSpecification.getName() + "%TYPE", dataTypeSpecification.getPrecision(), dataTypeSpecification.getScale());
        }
        String string = dataTypeMappingRule.getTargetDataType().getName();
        if (dataTypeMappingRule.getSourceDataType().hasPrecision()) {
            Integer n3 = dataTypeMappingRule.getTargetDataType().getPrecision();
            n = dataTypeMappingRule.getSourceDataType().hasScale() ? dataTypeMappingRule.getTargetDataType().getScale() : dataTypeSpecification.getScale();
        } else {
            Integer n4 = dataTypeSpecification.getPrecision();
            n = dataTypeSpecification.getScale();
        }
        return new DataTypeSpecification(string, (Integer)var7_10, n);
    }

    public Collection<DataTypeMappingRule> values() {
        return this.m_map.values();
    }
}

