/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.copy;

import java.sql.Connection;
import oracle.dbtools.migration.copy.BridgeParser;
import oracle.dbtools.migration.copy.BridgeTableDef;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class BridgeCmd
extends CommandListener {
    BridgeParser _bridgeParser = null;
    boolean statusOK = true;

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSQLOrig();
        this._bridgeParser = new BridgeParser(string);
        for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
            bridgeTableDef.setDefaultConn(connection);
            bridgeTableDef.setScriptRunnerContext(scriptRunnerContext);
            this.statusOK = bridgeTableDef.execute();
            if (this.statusOK) continue;
            break;
        }
        if (this._bridgeParser.getQuery() == null) {
            iSQLCommand.setSql("SELECT 1 FROM DUAL");
        }
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = "";
        boolean bl = false;
        for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
            String string2;
            String string3 = bridgeTableDef.getReport();
            if (string3 != null && !string3.equals("")) {
                scriptRunnerContext.write(string3);
            }
            if ((string2 = bridgeTableDef.getError()) == null || string2.equals("")) continue;
            scriptRunnerContext.write(string2);
            string = string + string2;
            bl = true;
        }
        if (bl) {
            scriptRunnerContext.putProperty("sqldev.error", (Object)Boolean.TRUE);
            scriptRunnerContext.putProperty("sqldev.last.err.message", (Object)string);
        }
        if (this._bridgeParser.getQuery() != null) {
            for (BridgeTableDef bridgeTableDef : this._bridgeParser.getTableDefs()) {
                if (bridgeTableDef._isReplace) continue;
                bridgeTableDef.drop();
            }
        }
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (this.statusOK) {
            if (this._bridgeParser.getQuery() != null) {
                iSQLCommand.setSql(this._bridgeParser.getQuery());
                return false;
            }
            return true;
        }
        return true;
    }

    private String JDBCToOracle(String string) {
        return string;
    }
}

