/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class ClobToBlobHandler {
    protected PersistenceManager m_persistenceManager = null;
    protected DBObjectId m_connectionId = null;
    private static final String TEMPLATEPATH = "oracle/dbtools/migration/datamove/offline/streams/templates";
    private StringTemplateGroup clobTemplateGroup;
    private static String ORACLE = "oracle";
    private static final String QUERY_FIND_BLOBS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_NAME, B.COLUMN_ORDER, B.NULLABLE FROM MGV_ALL_TABLES A, MD_COLUMNS B WHERE UPPER(B.COLUMN_TYPE) = 'BLOB' AND A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? AND A.CATALOG_NAME = ? AND A.SCHEMA_NAME = ? ORDER BY A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_ORDER ";

    public ClobToBlobHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
        this.m_connectionId = dBObjectId;
        RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader(TEMPLATEPATH, this.getClass().getClassLoader());
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        this.clobTemplateGroup = StringTemplateGroup.loadGroup((String)ORACLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeAddAndModify(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CloseableResultSet closeableResultSet = null;
            try {
                PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                preparedStatement.setLong(1, this.m_connectionId.getId());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                closeableResultSet = new CloseableResultSet(null, resultSet);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    String string6 = resultSet.getString(5);
                    StringTemplate stringTemplate = null;
                    stringTemplate = this.clobTemplateGroup.getInstanceOf("alterTableAddClob");
                    stringTemplate.setAttribute("schemaName", (Object)string3);
                    stringTemplate.setAttribute("tableName", (Object)string4);
                    stringTemplate.setAttribute("columnOrder", n);
                    stringBuilder.append(stringTemplate.toString());
                    if (!string6.equals("N")) continue;
                    stringTemplate = null;
                    stringTemplate = this.clobTemplateGroup.getInstanceOf("alterTableColumnNull");
                    stringTemplate.setAttribute("schemaName", (Object)string3);
                    stringTemplate.setAttribute("tableName", (Object)string4);
                    stringTemplate.setAttribute("columnName", (Object)string5);
                    stringBuilder.append(stringTemplate.toString());
                }
            }
            finally {
                if (closeableResultSet != null) {
                    closeableResultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", sQLException.getLocalizedMessage());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeProcedureCallAndNotNull(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            CloseableResultSet closeableResultSet = null;
            try {
                PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                preparedStatement.setLong(1, this.m_connectionId.getId());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                closeableResultSet = new CloseableResultSet(null, resultSet);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    String string6 = resultSet.getString(5);
                    StringTemplate stringTemplate = null;
                    stringTemplate = this.clobTemplateGroup.getInstanceOf("alterTableAddClobProcedure");
                    stringTemplate.setAttribute("schemaName", (Object)string3);
                    stringTemplate.setAttribute("tableName", (Object)string4);
                    stringTemplate.setAttribute("columnOrder", n);
                    stringTemplate.setAttribute("columnName", (Object)string5);
                    stringBuffer.append(stringTemplate.toString());
                    if (!string6.equals("N")) continue;
                    stringTemplate = null;
                    stringTemplate = this.clobTemplateGroup.getInstanceOf("alterTableColumnNull");
                    stringTemplate.setAttribute("schemaName", (Object)string3);
                    stringTemplate.setAttribute("tableName", (Object)string4);
                    stringTemplate.setAttribute("columnName", (Object)string5);
                    stringBuffer.append(stringTemplate.toString());
                }
            }
            finally {
                if (closeableResultSet != null) {
                    closeableResultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", sQLException.getLocalizedMessage());
        }
        return stringBuffer.toString();
    }
}

