/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.MigrationSchedulingRule;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;

public class DataMoveRunnerTask
extends RaptorTask<Object> {
    private DataMoveWorker m_worker;
    private String m_sourceConnName;
    private String m_targetConnName;
    private MdConnection m_convertedConnection;

    public DataMoveRunnerTask(DataMoveWorker dataMoveWorker, String string, String string2, MdConnection mdConnection) {
        super(MigrationAddinArb.getString("DATAMOVERUNNER_TITLE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this.m_worker = dataMoveWorker;
        this.m_sourceConnName = string;
        this.m_targetConnName = string2;
        this.m_convertedConnection = mdConnection;
        this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_INITIAL_MESSAGE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doWork() throws TaskException {
        try {
            this.setMessage(MigrationAddinArb.getString("FULLMIGRATION_TAB_DATAMOVE"));
            this.m_worker.doWork();
            this.setMessage(MigrationAddinArb.getString("FULLMIGRATION_TAB_DATAMOVE") + " " + MigrationAddinArb.getString("MIGRATION_COMPLETE"));
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule iSchedulingRule = ConnectionMutexFactory.getRule((String)this.m_sourceConnName);
        ISchedulingRule iSchedulingRule2 = ConnectionMutexFactory.getRule((String)this.m_targetConnName);
        ISchedulingRule iSchedulingRule3 = ConnectionMutexFactory.getRule((String)this.m_convertedConnection.getName());
        ObjectMutexRule objectMutexRule = new ObjectMutexRule((Object)"MigrationSession");
        return new MigrationSchedulingRule(iSchedulingRule, iSchedulingRule2, objectMutexRule, iSchedulingRule3);
    }

    public boolean cancel() {
        this.m_worker.signalCancel();
        return true;
    }
}

