/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.Ide;

public class OfflineGenerationOutputStream
implements GenerationOutputStream {
    private MigrationConfig m_generationOptions;
    private long m_linesWritten = 0L;
    private int m_fileIndex = 0;
    private PrintStream m_currentStream;
    private String m_fileBase;
    private String m_fileExtension;
    private String m_currentObjectType;
    private String m_currentSchemaName = null;
    private ArrayList<String> m_createdFiles;
    private String m_controllingScriptName;
    private String m_encoding;
    private static final TypeToExtensionTuple[] FILE_EXTENSION_MAP = new TypeToExtensionTuple[]{new TypeToExtensionTuple("MD_SCHEMAS", "db"), new TypeToExtensionTuple("MD_CATALOGS", "cat"), new TypeToExtensionTuple("MD_CONSTRAINTS", "cons"), new TypeToExtensionTuple("MD_GROUPS", "grp"), new TypeToExtensionTuple("MD_INDEXES", "ind"), new TypeToExtensionTuple("MD_PACKAGES", "pks"), new TypeToExtensionTuple("MD_OTHER_OBJECTS", "sql"), new TypeToExtensionTuple("MD_PRIVILEGES", "prv"), new TypeToExtensionTuple("MD_SEQUENCES", "seq"), new TypeToExtensionTuple("MD_STORED_PROGRAMS", "sql"), new TypeToExtensionTuple("MD_TABLES", "tbl"), new TypeToExtensionTuple("MD_USERS", "user"), new TypeToExtensionTuple("MD_VIEWS", "view"), new TypeToExtensionTuple("MD_TRIGGERS", "trg")};

    public OfflineGenerationOutputStream(MigrationConfig migrationConfig) {
        this.setGenerationOptions(migrationConfig);
        this.m_encoding = Ide.getEnvironOptions().getEncoding();
    }

    private void closeCurrentStream() {
        this.m_currentStream.close();
        this.m_currentStream = null;
    }

    @Override
    public void endObject() {
        if (this.m_generationOptions.getFileOutputOption() == 2) {
            this.closeCurrentStream();
        }
        this.m_currentObjectType = null;
    }

    private static int countLines(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    @Override
    public void println(String string) {
        assert (this.m_currentStream != null);
        int n = OfflineGenerationOutputStream.countLines(string);
        int n2 = this.m_generationOptions.getMaxNumberOfLines();
        if (n2 != -1 && this.m_linesWritten + (long)n > (long)n2) {
            try {
                this.openNewStream(this.m_fileBase, ++this.m_fileIndex, this.m_fileExtension);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
        }
        this.m_currentStream.println(string);
        this.m_linesWritten += (long)n;
    }

    @Override
    public void startObject(String string, String string2) {
        this.m_currentObjectType = string2;
        if (this.m_generationOptions.getFileOutputOption() == 2) {
            try {
                this.openStream(string, string2, 0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
        }
    }

    private void openStream(String string, String string2, int n) throws FileNotFoundException, UnsupportedEncodingException {
        String string3 = this.getExtensionForType(string2);
        this.m_fileIndex = n;
        StringBuffer stringBuffer = new StringBuffer("OutputDir");
        stringBuffer.append(File.separatorChar);
        if (this.m_currentSchemaName != null) {
            stringBuffer.append(this.m_currentSchemaName);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(string);
        this.openNewStream(stringBuffer.toString(), n, string3);
    }

    private void openSingleStream(int n) throws FileNotFoundException, UnsupportedEncodingException {
        String string = "OutputDir";
        int n2 = string.lastIndexOf(46);
        if (n2 != -1 && n2 > 1) {
            this.openNewStream(string.substring(0, n2 - 1), n, string.substring(n2 + 1));
        } else {
            this.openNewStream(string, n, null);
        }
    }

    private void openNewStream(String string, int n, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_fileBase = string;
        this.m_fileIndex = n;
        this.m_fileExtension = string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (this.m_fileIndex != 0) {
            stringBuffer.append(this.m_fileIndex);
        }
        if (this.m_fileExtension != null) {
            stringBuffer.append('.');
            stringBuffer.append(this.m_fileExtension);
        }
        this.m_currentStream = this.m_encoding == null ? new PrintStream(new File(stringBuffer.toString())) : new PrintStream(new File(stringBuffer.toString()), this.m_encoding);
        this.m_createdFiles.add(stringBuffer.toString());
    }

    @Override
    public void finished() {
        if (this.m_generationOptions.getGenerateControllingScript()) {
            try {
                this.openStream(this.m_controllingScriptName, "ctl", 0);
                this.m_createdFiles.remove(this.m_createdFiles.size() - 1);
                for (String string : this.m_createdFiles) {
                    this.m_currentStream.println("@" + string);
                }
                this.closeCurrentStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
        }
    }

    protected MigrationConfig getGenerationOptions() {
        return this.m_generationOptions;
    }

    protected void setGenerationOptions(MigrationConfig migrationConfig) {
        this.m_generationOptions = migrationConfig;
    }

    @Override
    public void startSchema(String string) {
        this.m_currentSchemaName = string;
        if (this.m_currentSchemaName != null) {
            File file;
            StringBuffer stringBuffer = new StringBuffer("OutputDir");
            stringBuffer.append(File.separatorChar);
            if (this.m_currentSchemaName != null) {
                stringBuffer.append(this.m_currentSchemaName);
            }
            if ((file = new File(stringBuffer.toString())).exists() && !file.isDirectory()) {
                Exception exception = new Exception(stringBuffer.toString());
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            } else if (!file.exists()) {
                file.mkdir();
            }
        }
    }

    @Override
    public void endSchema() {
        this.m_currentSchemaName = null;
    }

    @Override
    public void endDatabase() {
    }

    @Override
    public void startDatabase(String string) {
    }

    @Override
    public void endPreamble() {
        if (this.m_generationOptions.getFileOutputOption() != 0) {
            this.closeCurrentStream();
        }
    }

    @Override
    public void startPreamble(String string) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_createdFiles = new ArrayList();
        this.m_controllingScriptName = string;
        this.openStream(string + "_USERS", "sql", 0);
    }

    private String getExtensionForType(String string) {
        for (TypeToExtensionTuple typeToExtensionTuple : FILE_EXTENSION_MAP) {
            if (!typeToExtensionTuple.getType().equals(string)) continue;
            return typeToExtensionTuple.getExtension();
        }
        return string;
    }

    @Override
    public void close() {
    }

    private static class TypeToExtensionTuple {
        private String m_type;
        private String m_extension;

        public TypeToExtensionTuple(String string, String string2) {
            this.setType(string);
            this.setExtension(string2);
        }

        public String getExtension() {
            return this.m_extension;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setExtension(String string) {
            this.m_extension = string;
        }

        protected void setType(String string) {
            this.m_type = string;
        }
    }
}

