/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.ArrayList;
import java.util.ListIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.Messages;

public class MigrationObjectFilter {
    public static final int FILTERTYPE_ALL = 0;
    public static final int FILTERTYPE_NAMELIST = 1;
    public static final int FILTERTYPE_WHERECLAUSE = 2;
    public static final int FILTERTYPE_OBJECTIDLIST = 3;
    private String m_objectType;
    private ArrayList<String> m_objectNames;
    private String m_whereClause;
    private ArrayList<DBObjectId> m_objectIdList;
    private int m_filterType;
    private String m_databaseListString;
    private static final MigrationRepoMeta[] S_REPOINFO = new MigrationRepoMeta[]{new MigrationRepoMeta("MD_CATALOGS", "CATALOG_NAME"), new MigrationRepoMeta("MD_COLUMNS", "COLUMN_NAME"), new MigrationRepoMeta("MD_CONSTRAINTS"), new MigrationRepoMeta("MD_GROUPS", "GROUP_NAME"), new MigrationRepoMeta("MD_INDEXES", "INDEX_NAME"), new MigrationRepoMeta("MD_OTHER_OBJECTS"), new MigrationRepoMeta("MD_PACKAGES"), new MigrationRepoMeta("MD_PRIVILEGES", "PRIVILEGE_NAME"), new MigrationRepoMeta("MD_SCHEMAS"), new MigrationRepoMeta("MD_SEQUENCES"), new MigrationRepoMeta("MD_STORED_PROGRAMS"), new MigrationRepoMeta("MD_SYNONYMS"), new MigrationRepoMeta("MD_TABLES", "TABLE_NAME"), new MigrationRepoMeta("MD_TABLESPACES", "TABLESPACE_NAME"), new MigrationRepoMeta("MD_TRIGGERS", "TRIGGER_NAME"), new MigrationRepoMeta("MD_USER_DEFINED_DATA_TYPES", "DATA_TYPE_NAME"), new MigrationRepoMeta("MD_USERS", "USERNAME"), new MigrationRepoMeta("MD_VIEWS", "VIEW_NAME")};

    protected MigrationObjectFilter(int n, String string) {
        this.setFilterType(n);
        this.setObjectType(string);
    }

    public MigrationObjectFilter(String string) {
        this(0, string);
    }

    public MigrationObjectFilter(String string, String[] stringArray) {
        this(1, string);
        this.m_objectNames = new ArrayList();
        for (String string2 : stringArray) {
            this.addObjectName(string2);
        }
    }

    public MigrationObjectFilter(String string, String string2) {
        this(2, string);
        this.setWhereClause(string2);
    }

    public MigrationObjectFilter(String string, DBObjectId[] dBObjectIdArray) {
        this(3, string);
        this.m_objectIdList = new ArrayList();
        for (DBObjectId dBObjectId : dBObjectIdArray) {
            this.addObjectId(dBObjectId);
        }
    }

    public int getFilterType() {
        return this.m_filterType;
    }

    protected void setFilterType(int n) {
        this.m_filterType = n;
    }

    public String[] getObjectNames() {
        if (this.getFilterType() != 1) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.0"));
        }
        return this.m_objectNames.toArray(new String[this.m_objectNames.size()]);
    }

    public DBObjectId[] getObjectIds() {
        if (this.getFilterType() != 3) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.1"));
        }
        return this.m_objectIdList.toArray(new DBObjectId[this.m_objectIdList.size()]);
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    protected void setObjectType(String string) {
        this.m_objectType = string;
    }

    public String getWhereClause() {
        if (this.getFilterType() != 2) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.2"));
        }
        return this.m_whereClause;
    }

    public void setWhereClause(String string) {
        if (this.getFilterType() != 2) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.3"));
        }
        this.m_whereClause = string;
    }

    public void addObjectName(String string) {
        if (this.getFilterType() != 1) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.4"));
        }
        this.m_objectNames.add(string);
    }

    public void addObjectId(DBObjectId dBObjectId) {
        if (this.getFilterType() != 3) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.5"));
        }
        this.m_objectIdList.add(dBObjectId);
    }

    private String getQuotedNameList() {
        if (this.m_objectNames.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IN (");
        ListIterator<String> listIterator = this.m_objectNames.listIterator();
        while (listIterator.hasNext()) {
            String string = listIterator.next();
            if (string.length() > 0) {
                stringBuffer.append('\'');
                stringBuffer.append(string);
                stringBuffer.append('\'');
            }
            if (!listIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String getObjectIdInClause() {
        if (this.m_objectIdList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IN (");
        ListIterator<DBObjectId> listIterator = this.m_objectIdList.listIterator();
        while (listIterator.hasNext()) {
            DBObjectId dBObjectId = listIterator.next();
            stringBuffer.append(dBObjectId.getId());
            if (!listIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private String toWhereCondition(String string) {
        if (this.getFilterType() == 0) {
            return "1=1";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(' ');
        if (this.getFilterType() == 2) {
            stringBuffer.append(this.getWhereClause());
        } else if (this.getFilterType() == 1) {
            stringBuffer.append(this.getQuotedNameList());
        } else {
            stringBuffer.append(this.getObjectIdInClause());
        }
        return stringBuffer.toString();
    }

    public String toWhereClause(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ");
        stringBuffer.append(this.toWhereCondition(string));
        return stringBuffer.toString();
    }

    public String toConditionClause(String string, String string2) {
        if (this.getFilterType() == 3) {
            return this.toWhereCondition(string2);
        }
        return this.toWhereCondition(string);
    }

    public String toWhereConditionForMigrationRepository() {
        String string = this.findNameField();
        String string2 = this.findIdField();
        if (string == null || string2 == null) {
            throw new IllegalStateException(Messages.getString("MigrationObjectFilter.14"));
        }
        return this.toConditionClause(string, string2);
    }

    public void setSelectedDatabaseListString(String string) {
        this.m_databaseListString = string;
    }

    public String getSelectedDatabaseListString() {
        return this.m_databaseListString;
    }

    private String findNameField() {
        for (MigrationRepoMeta migrationRepoMeta : S_REPOINFO) {
            if (!migrationRepoMeta.m_tableName.equals(this.getObjectType())) continue;
            return migrationRepoMeta.m_nameField;
        }
        return null;
    }

    private String findIdField() {
        for (MigrationRepoMeta migrationRepoMeta : S_REPOINFO) {
            if (!migrationRepoMeta.m_tableName.equals(this.getObjectType())) continue;
            return migrationRepoMeta.m_idField;
        }
        return null;
    }

    private static class MigrationRepoMeta {
        public String m_tableName;
        public String m_nameField;
        public String m_idField;

        public MigrationRepoMeta(String string, String string2, String string3) {
            this.m_tableName = string;
            this.m_nameField = string2;
            this.m_idField = string3;
        }

        public MigrationRepoMeta(String string, String string2) {
            this(string, string2, "ID");
        }

        public MigrationRepoMeta(String string) {
            this(string, "NAME");
        }
    }
}

