/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;

public final class ConvertedDatabases
extends MigrationRepositoryDatabases {
    private static ConvertedDatabases s_instance;

    public static synchronized ConvertedDatabases getInstance() {
        if (s_instance == null) {
            s_instance = new ConvertedDatabases();
        }
        return s_instance;
    }

    @Override
    public CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getUtility().getAllConvertedConnections();
    }

    @Override
    public String getShortLabel() {
        return MigrationAddinArb.getString("CONVERTED_ROOT_LABEL");
    }

    @Override
    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        return new ConvertedConnectionNode(string, string2, mdConnection);
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    public Icon getIcon() {
        String string = MigrationAddinArb.getString("MIGRATION_CONVERT_ICON");
        if (string == null) {
            return null;
        }
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

