/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.DataQualityToolbar;
import oracle.dbtools.migration.workbench.core.navigator.ModelValue;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.javatools.data.PropertyStorage;

public class ModelCompareToolbar
implements IModifyToolbar {
    public static final String FIRSTCAPCONNID = "&FIRSTCAPCONNID";
    public static final String SECONDCAPCONNID = "&SECONDCAPCONNID";
    static String _defaultConn = null;
    Vector<ModelValue> _models = null;
    HashMap<Long, String> _projects = null;

    public void modifyToolbar(Toolbar toolbar) {
        toolbar.add((Component)new JLabel("First:"));
        toolbar.add((Component)this.getFirstModelComboBox());
        toolbar.add((Component)new JLabel("Second:"));
        toolbar.add((Component)this.getSecondModelComboBox());
    }

    private JComboBox getFirstModelComboBox() {
        JComboBox jComboBox = this.getCaptureModelComboBox();
        jComboBox.addItemListener(new ComboListener(jComboBox, FIRSTCAPCONNID));
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        HashMap<String, String> hashMap = migrationConfig.getBridgeReplace();
        if (hashMap.containsKey(FIRSTCAPCONNID)) {
            String string = hashMap.get(FIRSTCAPCONNID);
            for (ModelValue modelValue : this._models) {
                if (modelValue.getCapturedId() == null || !modelValue.getCapturedId().equals(string)) continue;
                jComboBox.setSelectedItem(modelValue);
                break;
            }
        }
        return jComboBox;
    }

    private JComboBox getSecondModelComboBox() {
        JComboBox jComboBox = this.getCaptureModelComboBox();
        jComboBox.addItemListener(new ComboListener(jComboBox, SECONDCAPCONNID));
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        HashMap<String, String> hashMap = migrationConfig.getBridgeReplace();
        if (hashMap.containsKey(SECONDCAPCONNID)) {
            String string = hashMap.get(SECONDCAPCONNID);
            for (ModelValue modelValue : this._models) {
                if (modelValue.getCapturedId() == null || !modelValue.getCapturedId().equals(string)) continue;
                jComboBox.setSelectedItem(modelValue);
                break;
            }
        }
        return jComboBox;
    }

    private JComboBox getCaptureModelComboBox() {
        JComboBox jComboBox = DataQualityToolbar.getModelChooser(this.getCapturedModels());
        return jComboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<ModelValue> getCapturedModels() {
        if (this._models == null) {
            this._models = new Vector();
            this._projects = new HashMap();
            this._models.add(new ModelValue("", null, null));
            CloseableIterator closeableIterator = null;
            CloseableIterator closeableIterator2 = null;
            try {
                PersistableObject persistableObject;
                closeableIterator = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager()).getAllProjects();
                while (closeableIterator.hasNext()) {
                    persistableObject = (MdProject)closeableIterator.next();
                    this._projects.put(persistableObject.getKey().getId(), ((MdProject)persistableObject).getProjectName());
                }
                closeableIterator2 = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager()).getAllCapturedConnections();
                while (closeableIterator2.hasNext()) {
                    persistableObject = (MdConnection)closeableIterator2.next();
                    this._models.add(new ModelValue(this._projects.get(((MdConnection)persistableObject).getProjectId().getId()) + " - " + ((MdConnection)persistableObject).getName(), "" + persistableObject.getKey().getId(), null));
                }
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace();
            }
            finally {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
                if (closeableIterator2 != null) {
                    closeableIterator2.close();
                }
            }
        }
        return this._models;
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        this.modifyToolbar(toolbar);
    }

    public class ComboListener
    implements ItemListener {
        private JComboBox _combo;
        private String _type;

        public ComboListener(JComboBox jComboBox, String string) {
            this._combo = jComboBox;
            this._type = string;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = ((ModelValue)itemEvent.getItem()).getCapturedId();
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                migrationConfig.setBridgeReplace(this._type, string);
            }
        }
    }
}

