/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdApplication;
import oracle.dbtools.metadata.persistence.MdApplicationFile;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationFileFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationFileNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.PlatformUtils;

public class ApplicationNode
extends DefaultContainerCustomNode
implements IPersistableObjectNode {
    protected static final Logger LOGGER = Logger.getLogger(ApplicationNode.class.getName());
    private MdApplication _application;
    private List<MdApplicationFile> _applicationFiles = new ArrayList<MdApplicationFile>();
    public static final char SLASH_CHAR = '/';
    public static final String SLASH_STR = Character.toString('/');
    private boolean _closing;
    static final JFileChooser CHOOSER = new JFileChooser();
    public static final String BACKUP_SUFFIX = ".backup";

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ApplicationNode(MdApplication mdApplication) {
        assert (mdApplication != null);
        this._application = mdApplication;
        String string = this._application.getKey().toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string)));
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE);
    }

    public MdApplication getMdApplication() {
        return this._application;
    }

    public String getShortLabel() {
        return this.getMdApplication().getName();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"application.png");
    }

    List<Element> getChildren(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (MdApplicationFile mdApplicationFile : this._applicationFiles) {
            StringBuilder stringBuilder = new StringBuilder(mdApplicationFile.getUri());
            if (stringBuilder.charAt(0) == '/') {
                stringBuilder.deleteCharAt(0);
            }
            if (!string.isEmpty() && stringBuilder.indexOf(string) != 0) continue;
            int n = stringBuilder.length();
            int n2 = n - mdApplicationFile.getName().length();
            stringBuilder.delete(n2, n);
            int n3 = stringBuilder.indexOf(SLASH_STR, string.length() + 1);
            if (n3 > -1) {
                String string2 = stringBuilder.substring(0, n3);
                if (arrayList2.contains(string2)) continue;
                arrayList.add((Element)new ApplicationFileFolderNode(this, string2));
                arrayList2.add(string2);
                continue;
            }
            arrayList.add((Element)new ApplicationFileNode(this, mdApplicationFile));
        }
        return arrayList;
    }

    void loadApplicationFileFolderNode(final ApplicationFileFolderNode applicationFileFolderNode) {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)applicationFileFolderNode){

            protected List<Element> doWork() throws TaskException {
                return ApplicationNode.this.getChildren(applicationFileFolderNode.getPath());
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        boolean bl = false;
        if (!this._children.isEmpty()) {
            return true;
        }
        CloseableIterator<?> closeableIterator = null;
        try {
            closeableIterator = this.getMdApplicationFileIterator();
            if (closeableIterator.hasNext()) {
                bl = true;
            }
        }
        catch (PersistenceException persistenceException) {
            ApplicationNode.log(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        return bl;
    }

    private PersistenceUtility getPersistenceUtility() {
        return PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
    }

    private CloseableIterator<?> getMdApplicationFileIterator() throws PersistenceException {
        return this.getPersistenceUtility().getFilesForApplication(this._application.getKey());
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                CloseableIterator closeableIterator = null;
                try {
                    closeableIterator = ApplicationNode.this.getMdApplicationFileIterator();
                    while (closeableIterator.hasNext()) {
                        MdApplicationFile mdApplicationFile = (MdApplicationFile)closeableIterator.next();
                        ApplicationNode.this._applicationFiles.add(mdApplicationFile);
                    }
                    arrayList.addAll(ApplicationNode.this.getChildren(""));
                }
                catch (PersistenceException persistenceException) {
                    this.log(persistenceException);
                }
                finally {
                    if (closeableIterator != null) {
                        closeableIterator.close();
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    @Override
    public String getObjectName() {
        return "MD_APPLICATIONS";
    }

    @Override
    public String getObjectType() {
        return "APPLICATION";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            this._dict = new HashMap();
            this._dict.put("IDAPPLICATION", this.getMdApplication().getKey().toString());
        }
        return this._dict;
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getMdApplication();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl() throws IOException {
        block6: {
            try {
                if (this._closing) break block6;
                this._closing = true;
                List<MdApplicationFile> list = this._applicationFiles;
                synchronized (list) {
                    this._applicationFiles.clear();
                }
            }
            finally {
                this._closing = false;
            }
        }
    }

    public String getFQPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._application.getOutputDir() == null) {
            stringBuilder.append(this._application.getBaseDir());
        } else {
            stringBuilder.append(this._application.getOutputDir());
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String getOriginalFQPath(String string) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(this._application.getBaseDir());
        stringBuilder.append(string);
        boolean bl2 = bl = this._application.getInplace() != null && this._application.getInplace() == 1;
        if (bl) {
            stringBuilder.append(BACKUP_SUFFIX);
        }
        return stringBuilder.toString();
    }

    static Icon getIcon(URL uRL, Icon icon) {
        return ApplicationNode.getIcon(uRL, icon, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Icon getIcon(URL uRL, Icon icon, String string, String string2) {
        Icon icon2 = icon;
        File file = null;
        try {
            File file2 = new File(uRL.toURI());
            if (null == file2 || !file2.exists()) {
                if (string != null && string.length() > 2) {
                    file = File.createTempFile(string, string2);
                }
                file2 = file;
            }
            if (file2 != null) {
                Icon icon3 = null;
                if (PlatformUtils.isWindows()) {
                    icon3 = FileSystemView.getFileSystemView().getSystemIcon(file2);
                    if (icon3 != null) {
                        icon2 = icon3;
                    }
                } else {
                    icon3 = CHOOSER.getIcon(file2);
                    if (icon3 != null) {
                        icon2 = icon3;
                    }
                }
            }
        }
        catch (Exception exception) {
            ApplicationNode.log(exception);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return icon2;
    }
}

