/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.impl.DatabaseTreeNode;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.model.Element;

public class MigrationProjectTreeNode
extends DatabaseTreeNode {
    protected static void fillInInheritedInitialProperties(DBItemInstance dBItemInstance, MigrationConnectionNode migrationConnectionNode) {
        HashMap<String, Object> hashMap = migrationConnectionNode.getDict();
        if (hashMap != null) {
            for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
                dBItemInstance.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public MigrationProjectTreeNode() {
        this.setComparator(new C());
    }

    protected RaptorTask<Collection<Element>> getLoadingTask() {
        final MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getElement();
        String string = migrationConnectionNode != null ? migrationConnectionNode.getQualifiedConnectionName() : null;
        NavigatorQueryTask navigatorQueryTask = new NavigatorQueryTask(MigrationProjectTreeNode.getTaskName((Element)this.getElement()), MigrationAddin.getRepositoryConnectionName(), true){

            protected Collection<Element> doWorkImpl() throws TaskException {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    MigrationProjectTreeNode.this.updateToolTipText(migrationConnectionNode.getShortLabel() + DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_CONNECTED_MSG"));
                    DBObjectId dBObjectId = migrationConnectionNode.getMdConnection().getKey();
                    this.checkStatus("getCapturedObjectsFolderNode");
                    CapturedObjectsFolderNode capturedObjectsFolderNode = MigrationProjectTreeNode.this.getCapturedObjectsFolderNode(dBObjectId, migrationConnectionNode);
                    capturedObjectsFolderNode.setParentElement((Element)migrationConnectionNode);
                    arrayList.add((Element)capturedObjectsFolderNode);
                    this.checkStatus("getConvertedModelsFolderNode");
                    ConvertedModelsFolderNode convertedModelsFolderNode = MigrationProjectTreeNode.this.getConvertedModelsFolderNode(dBObjectId, migrationConnectionNode);
                    convertedModelsFolderNode.setParentElement((Element)migrationConnectionNode);
                    if (convertedModelsFolderNode.hasChildren()) {
                        arrayList.add((Element)convertedModelsFolderNode);
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (exception instanceof WrappedException) {
                        throwable = exception.getCause();
                    }
                    throw new TaskException(throwable);
                }
                return arrayList;
            }
        };
        return navigatorQueryTask;
    }

    protected ObjectFactory getObjectFactory(AbstractConnectionNode abstractConnectionNode) throws IOException {
        return AbstractMigrationNavigatorManager.getRegistry().getFactory(abstractConnectionNode.getShortLabel(), abstractConnectionNode.getConnection());
    }

    private ConvertedModelsFolderNode getConvertedModelsFolderNode(DBObjectId dBObjectId, MigrationConnectionNode migrationConnectionNode) {
        return new ConvertedModelsFolderNode(dBObjectId, migrationConnectionNode);
    }

    private CapturedObjectsFolderNode getCapturedObjectsFolderNode(DBObjectId dBObjectId, MigrationConnectionNode migrationConnectionNode) {
        return new CapturedObjectsFolderNode(dBObjectId, migrationConnectionNode);
    }

    private ApplicationsFolderNode getApplicationsFolderNode(DBObjectId dBObjectId) {
        return new ApplicationsFolderNode(dBObjectId);
    }

    private static class C
    implements Comparator<NavigatorTreeNode> {
        private C() {
        }

        @Override
        public int compare(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            if (navigatorTreeNode == navigatorTreeNode2) {
                return 0;
            }
            return this.compareTNodes(navigatorTreeNode, navigatorTreeNode2);
        }

        private int compareTNodes(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            Element element = navigatorTreeNode.getElement();
            Element element2 = navigatorTreeNode2.getElement();
            if (element instanceof ApplicationsFolderNode) {
                return 1;
            }
            if (element2 instanceof ApplicationsFolderNode) {
                return -1;
            }
            if (element instanceof ConvertedModelsFolderNode) {
                return 1;
            }
            if (element2 instanceof ConvertedModelsFolderNode) {
                return -1;
            }
            if (element instanceof CapturedObjectsFolderNode) {
                return 1;
            }
            if (element2 instanceof CapturedObjectsFolderNode) {
                return -1;
            }
            if (element instanceof OtherSchemasFolder) {
                return 1;
            }
            if (element2 instanceof OtherSchemasFolder) {
                return -1;
            }
            if (element instanceof ObjectFolder && element2 instanceof ObjectFolder) {
                return this.compareObjectFolders((ObjectFolder)element, (ObjectFolder)element2);
            }
            return element.toString().compareTo(element2.toString());
        }

        private int compareObjectFolders(ObjectFolder objectFolder, ObjectFolder objectFolder2) {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            DBFolderInstance dBFolderInstance2 = objectFolder2.getFolderInstance();
            DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
            DatabaseFolder databaseFolder2 = (DatabaseFolder)dBFolderInstance2.getDescriptor();
            double d = databaseFolder.getWeight() - databaseFolder2.getWeight();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return dBFolderInstance.getType().compareTo(dBFolderInstance2.getType());
        }
    }
}

