/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Driver;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.Messages;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.ObjectTypesPanel;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class GeneratePreferencesPanel
extends DefaultTraversablePanel {
    public static final String TITLE = MigrationAddinArb.getString("GENERATE_PREFERENCES_TITLE");
    private static final long serialVersionUID = 4843227636357117485L;
    private JCheckBox m_checkComments;
    private JRadioButton m_radioPerObject;
    private JRadioButton m_radioPerObjectType;
    private JRadioButton m_radioSingle;
    private JCheckBox m_checkSingleSchema;
    private JCheckBox m_generateFailedObjects;
    private JCheckBox m_generateClobToBlob;
    private JCheckBox m_genEntireEmulationPkgField;
    private JCheckBox m_generate12c;
    private JCheckBox m_createUser;
    protected ObjectTypesPanel m_objectTypesPanel = new ObjectTypesPanel();
    private Object[] m_iotOptions = new Object[]{MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_NONE"), MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_PROMOTE_UNIQUE"), MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_PRIMARY_KEYS")};
    private boolean m_show12 = true;
    JComboBox m_IOTCombo = new JComboBox<Object>(this.m_iotOptions);
    private JCheckBox m_checkAll = new JCheckBox();
    private JCheckBox m_doTables = new JCheckBox();
    private JCheckBox m_doView = new JCheckBox();
    private JCheckBox m_doTriggers = new JCheckBox();
    private JCheckBox m_doSequence = new JCheckBox();
    private JCheckBox m_doProcedure = new JCheckBox();
    private JCheckBox m_doFunction = new JCheckBox();
    private JCheckBox m_doIndex = new JCheckBox();
    private JCheckBox m_doPackages = new JCheckBox();
    private JCheckBox m_doSynonymn = new JCheckBox();

    public GeneratePreferencesPanel() {
        this.initComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_migprefgeneration_html");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, MigrationAddinArb.getString("GEN_FILE_CREATION_OPTIONS"), 0, 0, null, null));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.add(jPanel2, gridBagConstraints2);
        this.m_radioSingle = new JRadioButton();
        this.m_radioSingle.setText(MigrationAddinArb.getString("GEN_SINGLE_OBJECT"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        jPanel2.add((Component)this.m_radioSingle, gridBagConstraints3);
        this.m_radioPerObjectType = new JRadioButton();
        this.m_radioPerObjectType.setText(MigrationAddinArb.getString("GEN_SINGLE_OBJECT_TYPE"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridx = 0;
        jPanel2.add((Component)this.m_radioPerObjectType, gridBagConstraints4);
        this.m_radioPerObject = new JRadioButton();
        this.m_radioPerObject.setText(MigrationAddinArb.getString("GEN_PRE_OBJECT"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.gridx = 0;
        jPanel2.add((Component)this.m_radioPerObject, gridBagConstraints5);
        buttonGroup.add(this.m_radioSingle);
        buttonGroup.add(this.m_radioPerObjectType);
        buttonGroup.add(this.m_radioPerObject);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, MigrationAddinArb.getString("GEN_GENERAL_OPTIONS"), 0, 0, null, null));
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.gridx = 0;
        this.add(jPanel3, gridBagConstraints6);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(null, MigrationAddinArb.getString("OBJECTTYPES_OPTIONS"), 0, 0, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridx = 0;
        this.add(jPanel4, gridBagConstraints7);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder());
        jPanel4.add((Component)this.getObjectTypePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jPanel5, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_checkComments = new JCheckBox();
        this.m_checkComments.setText(MigrationAddinArb.getString("GEN_CHECK_COMMENTS"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.gridx = 0;
        jPanel3.add((Component)this.m_checkComments, gridBagConstraints8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.gridy = 2;
        gridBagConstraints9.gridx = 0;
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 18;
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.gridx = 0;
        jPanel3.add((Component)jPanel6, gridBagConstraints10);
        this.m_checkSingleSchema = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_checkSingleSchema, (String)MigrationAddinArb.getString("GEN_LEAST_PRIVILEGE"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 4;
        gridBagConstraints11.gridx = 0;
        jPanel3.add((Component)this.m_checkSingleSchema, gridBagConstraints11);
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.gridx = 2;
        jPanel6.add((Component)jLabel, gridBagConstraints12);
        ResourceUtils.resButton((AbstractButton)this.m_radioSingle, (String)MigrationAddinArb.getString("RADIO_SINGLE"));
        ResourceUtils.resButton((AbstractButton)this.m_radioPerObjectType, (String)MigrationAddinArb.getString("RADIO_PEROBJECTTYPE"));
        ResourceUtils.resButton((AbstractButton)this.m_radioPerObject, (String)MigrationAddinArb.getString("RADIO_PEROBJECT"));
        ResourceUtils.resButton((AbstractButton)this.m_checkComments, (String)MigrationAddinArb.getString("CHECK_GENERATE_COMMENTS"));
        this.m_generateFailedObjects = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_generateFailedObjects, (String)MigrationAddinArb.getString("MIGRATION_GENERATE_FAILED_OBJECTS"));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.weighty = 0.0;
        gridBagConstraints13.anchor = 18;
        gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridy = 6;
        gridBagConstraints13.gridx = 0;
        jPanel3.add((Component)this.m_generateFailedObjects, gridBagConstraints13);
        this.m_generateClobToBlob = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_generateClobToBlob, (String)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_MOVE_USE_CLOBTOBLOB"));
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.weighty = 0.0;
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.gridy = 7;
        gridBagConstraints14.gridx = 0;
        jPanel3.add((Component)this.m_generateClobToBlob, gridBagConstraints14);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.weighty = 0.0;
        gridBagConstraints15.anchor = 18;
        gridBagConstraints15.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridy = 8;
        gridBagConstraints15.gridx = 0;
        jPanel3.add((Component)this.getCreateUserPanel(), gridBagConstraints15);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.weighty = 0.0;
        gridBagConstraints16.anchor = 18;
        gridBagConstraints16.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.gridy = 9;
        gridBagConstraints16.gridx = 0;
        jPanel3.add((Component)this.getGenerateEntireEmulationPkgPanel(), gridBagConstraints16);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_IOTCombo, (String)MigrationAddinArb.getString("MIGRATION_GENERATE_IOT"));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.weighty = 0.0;
        gridBagConstraints17.anchor = 10;
        gridBagConstraints17.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.gridy = 0;
        gridBagConstraints17.gridx = 0;
        jPanel7.add((Component)jLabel2, gridBagConstraints17);
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.weighty = 0.0;
        gridBagConstraints18.anchor = 10;
        gridBagConstraints18.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridy = 0;
        gridBagConstraints18.gridx = 1;
        jPanel7.add((Component)this.m_IOTCombo, gridBagConstraints18);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.weightx = 1.0;
        gridBagConstraints19.weighty = 0.0;
        gridBagConstraints19.anchor = 10;
        gridBagConstraints19.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.gridy = 0;
        gridBagConstraints19.gridx = 2;
        jPanel7.add(Box.createHorizontalGlue(), gridBagConstraints19);
        Driver driver = null;
        Throwable throwable = null;
        try {
            driver = (Driver)Class.forName("oracle.jdbc.OracleDriver").newInstance();
            if (driver != null && driver.getMajorVersion() >= 12) {
                this.m_show12 = true;
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throwable = exceptionInInitializerError;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        if (throwable != null) {
            MigrationLogUtil.logThrowable(throwable.getLocalizedMessage(), ((Object)((Object)this)).getClass().getName(), throwable);
        }
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.weightx = 1.0;
        gridBagConstraints20.weighty = this.m_show12 ? 0.0 : 1.0;
        gridBagConstraints20.anchor = 18;
        gridBagConstraints20.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints20.fill = 2;
        gridBagConstraints20.gridy = 10;
        gridBagConstraints20.gridx = 0;
        jPanel3.add((Component)jPanel7, gridBagConstraints20);
        this.m_generate12c = new JCheckBox();
        if (this.m_show12) {
            ResourceUtils.resButton((AbstractButton)this.m_generate12c, (String)MigrationAddinArb.getString("MIGRATION_USE_12C"));
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.anchor = 18;
            gridBagConstraints21.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridy = 11;
            gridBagConstraints21.gridx = 0;
            jPanel3.add((Component)this.m_generate12c, gridBagConstraints21);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onEntry(traversableContext);
        this.m_checkComments.setSelected(migrationConfig.getGenerateComments());
        switch (migrationConfig.getFileOutputOption()) {
            case 2: {
                this.m_radioPerObject.setSelected(true);
                break;
            }
            case 1: {
                this.m_radioPerObjectType.setSelected(true);
                break;
            }
            case 0: {
                this.m_radioSingle.setSelected(true);
            }
        }
        this.m_checkSingleSchema.setSelected(migrationConfig.getSingleSchemaLeastPrivilege());
        this.m_generateFailedObjects.setSelected(migrationConfig.getGenerateFailedObjects());
        this.m_generateClobToBlob.setSelected(migrationConfig.getGenerateClobToBlob());
        this.m_IOTCombo.setSelectedIndex(migrationConfig.getIOTOption());
        this.m_genEntireEmulationPkgField.setSelected(migrationConfig.getGenerateEntireEmulationPkg());
        this.m_generate12c.setSelected(migrationConfig.getMigrate12c());
        this.m_createUser.setSelected(migrationConfig.getCreateUser());
        this.getSelectObjectTypes(migrationConfig);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onExit(traversableContext);
        migrationConfig.setGenerateComments(this.m_checkComments.isSelected());
        if (this.m_radioPerObject.isSelected()) {
            migrationConfig.setFileOutputOption(2);
        } else if (this.m_radioSingle.isSelected()) {
            migrationConfig.setFileOutputOption(0);
        } else if (this.m_radioPerObjectType.isSelected()) {
            migrationConfig.setFileOutputOption(1);
        }
        migrationConfig.setSingleSchemaLeastPrivilege(this.m_checkSingleSchema.isSelected());
        migrationConfig.setGenerateFailedObjects(this.m_generateFailedObjects.isSelected());
        migrationConfig.setGenerateClobToBlob(this.m_generateClobToBlob.isSelected());
        migrationConfig.setIOTOption(this.m_IOTCombo.getSelectedIndex());
        migrationConfig.setGenerateEntireEmulationPkg(this.m_genEntireEmulationPkgField.isSelected());
        migrationConfig.setCreateUser(this.m_createUser.isSelected());
        if (!this.m_show12) {
            this.m_generate12c.setSelected(false);
        }
        migrationConfig.setMigrate12c(this.m_generate12c.isSelected());
        this.setSelectObjectTypes(migrationConfig);
    }

    private JPanel getGenerateEntireEmulationPkgPanel() {
        this.m_genEntireEmulationPkgField = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_genEntireEmulationPkgField, (String)Messages.getString("ConfigurationPanelData.9"));
        return this.getPanelWithLabelAndComponent(null, this.m_genEntireEmulationPkgField);
    }

    private JPanel getCreateUserPanel() {
        this.m_createUser = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_createUser, (String)Messages.getString("ConfigurationPanelData.10"));
        return this.getPanelWithLabelAndComponent(null, this.m_createUser);
    }

    private JPanel getPanelWithLabelAndComponent(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        if (jLabel != null) {
            jPanel.add((Component)jLabel, null);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        jPanel.add((Component)jComponent, null);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel getObjectTypePanel() {
        ResourceUtils.resButton((AbstractButton)this.m_checkAll, (String)UiResources.getString((String)"TOGGLE"));
        ResourceUtils.resButton((AbstractButton)this.m_doTables, (String)UiResources.getString((String)"TAB"));
        ResourceUtils.resButton((AbstractButton)this.m_doView, (String)UiResources.getString((String)"VIEW"));
        ResourceUtils.resButton((AbstractButton)this.m_doTriggers, (String)UiResources.getString((String)"TRIG"));
        ResourceUtils.resButton((AbstractButton)this.m_doSequence, (String)UiResources.getString((String)"SEQ"));
        ResourceUtils.resButton((AbstractButton)this.m_doFunction, (String)UiResources.getString((String)"FUN"));
        ResourceUtils.resButton((AbstractButton)this.m_doProcedure, (String)UiResources.getString((String)"PROC"));
        ResourceUtils.resButton((AbstractButton)this.m_doIndex, (String)UiResources.getString((String)"IND"));
        ResourceUtils.resButton((AbstractButton)this.m_doPackages, (String)UiResources.getString((String)"PACK"));
        ResourceUtils.resButton((AbstractButton)this.m_doSynonymn, (String)UiResources.getString((String)"SYN"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.m_checkAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 7, 5, 0), 0, 0));
        int n = 0;
        int n2 = 0;
        jPanel.add((Component)this.m_doTables, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 24), 0, 0));
        jPanel.add((Component)this.m_doView, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 24), 0, 0));
        jPanel.add((Component)this.m_doTriggers, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 24), 0, 0));
        n2 = 0;
        jPanel.add((Component)this.m_doIndex, new GridBagConstraints(++n, ++n2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 24, 0, 24), 0, 0));
        jPanel.add((Component)this.m_doSequence, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 24), 0, 0));
        jPanel.add((Component)this.m_doSynonymn, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 24, 0, 24), 0, 0));
        n2 = 0;
        jPanel.add((Component)this.m_doPackages, new GridBagConstraints(++n, ++n2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.m_doProcedure, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.m_doFunction, new GridBagConstraints(n, ++n2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.m_checkAll.setSelected(true);
        this.m_doView.setSelected(true);
        this.m_doTables.setSelected(true);
        this.m_doSequence.setSelected(true);
        this.m_doProcedure.setSelected(true);
        this.m_doFunction.setSelected(true);
        this.m_doPackages.setSelected(true);
        this.m_doSynonymn.setSelected(true);
        this.m_doTriggers.setSelected(true);
        this.m_doIndex.setSelected(true);
        this.m_checkAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneratePreferencesPanel.this.m_doView.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doTables.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doSequence.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doProcedure.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doFunction.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doPackages.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doSynonymn.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doTriggers.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
                GeneratePreferencesPanel.this.m_doIndex.setSelected(GeneratePreferencesPanel.this.m_checkAll.isSelected());
            }
        });
        return jPanel;
    }

    private void getSelectObjectTypes(MigrationConfig migrationConfig) {
        this.m_checkAll.setSelected(migrationConfig.getGenObjectTypeCheckAll());
        this.m_doView.setSelected(migrationConfig.getGenObjectTypeViews());
        this.m_doTables.setSelected(migrationConfig.getGenObjectTypeTables());
        this.m_doSequence.setSelected(migrationConfig.getGenObjectTypeSequences());
        this.m_doProcedure.setSelected(migrationConfig.getGenObjectTypeProcedures());
        this.m_doFunction.setSelected(migrationConfig.getGenObjectTypeFunctions());
        this.m_doPackages.setSelected(migrationConfig.getGenObjectTypePackages());
        this.m_doSynonymn.setSelected(migrationConfig.getGenObjectTypeSynonyms());
        this.m_doTriggers.setSelected(migrationConfig.getGenObjectTypeTriggers());
        this.m_doIndex.setSelected(migrationConfig.getGenObjectTypeIndexes());
    }

    private void setSelectObjectTypes(MigrationConfig migrationConfig) {
        migrationConfig.setGenObjectTypeCheckAll(this.m_checkAll.isSelected());
        migrationConfig.setGenObjectTypeViews(this.m_doView.isSelected());
        migrationConfig.setGenObjectTypeTables(this.m_doTables.isSelected());
        migrationConfig.setGenObjectTypeSequences(this.m_doSequence.isSelected());
        migrationConfig.setGenObjectTypeProcedures(this.m_doProcedure.isSelected());
        migrationConfig.setGenObjectTypeFunctions(this.m_doFunction.isSelected());
        migrationConfig.setGenObjectTypePackages(this.m_doPackages.isSelected());
        migrationConfig.setGenObjectTypeSynonyms(this.m_doSynonymn.isSelected());
        migrationConfig.setGenObjectTypeTriggers(this.m_doTriggers.isSelected());
        migrationConfig.setGenObjectTypeIndexes(this.m_doIndex.isSelected());
    }
}

