/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.online.DataMoveRunnerTask;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.DataMoveDialogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.DataMoveSelectionPanel;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class DataMoveDialog
extends AbstractMenuAction {
    private MdConnection m_mdConnection = null;
    private JEWTDialog m_dlg;
    private static final long serialVersionUID = 5025669709731183466L;
    private DataMoveSelectionPanel m_dmsp;
    private JButton m_okButton;

    public DataMoveDialog(MdConnection mdConnection) {
        this.m_mdConnection = mdConnection;
        this.setupDialog();
    }

    public DataMoveDialog() {
        this.setupDialog();
    }

    private void setupDialog() {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        final int n = migrationConfig.getNumDataMoveThreads();
        final int n2 = migrationConfig.getDataMoveCommitInterval();
        this.m_dmsp = new DataMoveSelectionPanel(this.m_mdConnection);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_dmsp, null, (String)MigrationAddinArb.getString("DATAMOVE_DIALOG_TITLE"), (int)6);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_dmsp, "f1_onlinedatamove_html");
        this.m_okButton = new JButton(Messages.getString("DataMoveDialog.1"));
        this.m_dlg.addCustomButton((Component)this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (DataMoveDialog.this.m_dmsp.getSourceConnectionName() == null || DataMoveDialog.this.m_dmsp.getTargetConnectionName() == null || DataMoveDialog.this.m_dmsp.getTargetConnectionName() == null || DataMoveDialog.this.m_dmsp.getConvertedConnection() == null) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("INFO_DATA_MOVE_DETAIL"), (String)MigrationAddinArb.getString("INFO_DATA_MOVE_TITLE"), (String)"f1_chooseDataMove");
                        return;
                    }
                    DataMoveWorker dataMoveWorker = new DataMoveWorker(MigrationAddin.getPersistenceManager(), DataMoveDialog.this.m_dmsp.getSourceConnectionName(), DataMoveDialog.this.m_dmsp.getTargetConnectionName(), DataMoveDialog.this.m_dmsp.getConvertedConnection().getKey(), n, n2, DataMoveDialog.this.m_dmsp.getUseQualifiedNames(), false);
                    DataMoveRunnerTask dataMoveRunnerTask = new DataMoveRunnerTask(dataMoveWorker, DataMoveDialog.this.m_dmsp.getSourceConnectionName(), DataMoveDialog.this.m_dmsp.getTargetConnectionName(), DataMoveDialog.this.m_dmsp.getConvertedConnection());
                    final DataMoveDialogTaskUI dataMoveDialogTaskUI = new DataMoveDialogTaskUI(dataMoveRunnerTask.getDescriptor());
                    dataMoveWorker.addListener(dataMoveDialogTaskUI);
                    DataMoveDialog.this.m_dlg.closeDialog(true);
                    MigrationLogUtil.startMigrationLogSession(DataMoveDialog.this.m_dmsp.getConvertedConnection().getKey());
                    RaptorTaskManager.getInstance().addTask((RaptorTask)dataMoveRunnerTask, Collections.singletonList(new ITaskViewer(){

                        public void addTaskUI(ITaskUI iTaskUI) {
                        }

                        public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                            return dataMoveDialogTaskUI;
                        }

                        public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                            return this.getTaskUI(raptorTaskDescriptor);
                        }

                        public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                        }

                        public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                        }
                    }));
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        this.m_dlg.pack();
        this.m_dlg.setResizable(false);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
    }

    public void setVisible(boolean bl) {
        this.m_dlg.setVisible(bl);
    }

    public void launch() {
        MdConnection mdConnection;
        DBObject dBObject = this.getDBObject();
        this.m_mdConnection = mdConnection = MigrationUtils.getConnforDBObject(dBObject);
        DataMoveDialog dataMoveDialog = new DataMoveDialog(this.m_mdConnection);
        dataMoveDialog.setVisible(true);
    }
}

