/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.sql.CHAR;
import oracle.sql.NUMBER;

public class ModelConvertColumnCellEditor
implements ICellEditor {
    private JComponent m_comp = null;
    private static final int TARGET_COLUMN_NAME = 2;
    private static final int TARGET_COLUMN_DATATYPE = 4;
    private static final int TARGET_COLUMN_PRECISION = 6;
    private static final int TARGET_COLUMN_SCALE = 8;
    private static final int TARGET_COLUMN_DEFAULT_VALUE = 10;
    private static final int TARGET_COLUMN_NULLABLE = 12;
    private static final int TARGET_ID = 13;
    private static String[] m_datatypes = new String[]{"VARCHAR2", "NUMBER", "INTEGER", "DATE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "CLOB", "BLOB", "CHAR", "NCHAR", "NVARCHAR2", "NCLOB", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "LONG", "LONG RAW", "NUMERIC", "RAW", "REAL", "ROWID", "BFILE", "FLOAT", "DECIMAL"};

    public Component getComponent(JTable jTable, Object object, int n, int n2) {
        if (n2 == 4) {
            JComboBox<String> jComboBox = new JComboBox<String>(m_datatypes);
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
            if (object instanceof CHAR) {
                String string = "";
                try {
                    jComboBox.setSelectedItem(((CHAR)object).getString());
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                }
            }
            this.m_comp = jComboBox;
        } else if (n2 == 6 || n2 == 8) {
            JSpinner jSpinner = new JSpinner();
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
            jSpinner.setModel(spinnerNumberModel);
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
            String string = "";
            if (object instanceof NUMBER) {
                try {
                    jSpinner.getModel().setValue(((NUMBER)object).intValue());
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                }
            } else if (object instanceof Integer) {
                try {
                    jSpinner.getModel().setValue((int)((Integer)object));
                }
                catch (Exception exception) {
                    string = exception.getMessage();
                }
            }
            this.m_comp = jSpinner;
        } else {
            this.m_comp = object != null ? new JTextField(object.toString()) : new JTextField("");
        }
        return this.m_comp;
    }

    public Object getValue() {
        Object object = null;
        if (this.m_comp != null) {
            if (this.m_comp instanceof JTextField) {
                object = ((JTextField)this.m_comp).getText();
            } else if (this.m_comp instanceof JComboBox) {
                object = ((JComboBox)this.m_comp).getSelectedItem();
            } else if (this.m_comp instanceof JSpinner) {
                try {
                    ((JSpinner)this.m_comp).commitEdit();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object = ((JSpinner)this.m_comp).getValue();
            }
        }
        return object;
    }
}

