/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.DatabaseProviderRegistry;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.logging.MigrationFileHandler;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.SchemaFolderNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.CapturePageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.ConvertPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MoveDataPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.ProjectPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.RepoPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SourceDBPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.TargetDBPageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.TranslatePageMigration;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.WelcomePageMigration;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class QMWizard {
    private static Logger m_logger = null;
    public static final String QM_NAME = "raptor.qmwizard";
    public static final int QM_ACTION = Ide.findOrCreateCmdID((String)"raptor.qmwizard");
    private static QMWizard INSTANCE;
    static final String TRANSITION_TO_SUMMARY = "TRANSITION_TO_SUMMARY";
    static final String IS_PROJECT_NAME_PRESET = "IS_PROJECT_NAME_PRESET";
    static final String PAGE_TITLE_KEY = "pagetitle";
    static final String PROJECT_NAME = "PROJECT_NAME";
    static final String PROJECT_DESC = "PROJECT_DESC";
    static final String OUTPUT_DIR = "OUTPUT_DIR";
    static final String CAPT_MODE_ONLINE = "CAPT_MODE_ONLINE";
    static final String CAPT_MODE_OFFLINE = "CAPT_MODE_OFFLINE";
    static final String GEN_MODE_ONLINE = "GEN_MODE_ONLINE";
    static final String GEN_MODE_OFFLINE = "GEN_MODE_OFFLINE";
    static final String DATMV_MODE_ONLINE = "DATMV_MODE_ONLINE";
    static final String DATMV_MODE_OFFLINE = "DATMV_MODE_OFFLINE";
    static final String SOURCE_DM_CONN = "SOURCE_DM_CONN";
    static final String SOURCE_CONN = "SOURCE_CONN";
    static final String OFF_CAPTURE_CONTROL = "OFF_CAPTURE_CONTROL";
    static final String OFFLINE_FILE_ENCODING = "OFFLINE_FILE_ENCODING";
    static final String AVAILABLE_DB_LIST = "AVAILABLE_DB_LIST";
    static final String SELECTED_DB_LIST = "SELECTED_DB_LIST";
    static final String TARGET_CONN = "TARGET_CONN";
    static final String DROP_TARGET_OBJECTS = "DROP_TARGET_OBJECTS";
    static final String SELECTED_TO_TRNSL_LIST = "SELECTED_TO_TRNSL_LIST";
    static final String SELECTED_TO_TRNSL_GROUPS = "SELECTED_TO_TRNSL_GROUPS";
    static final String TRUNC_TARGET_OBJECTS = "TRUNC_TARGET_OBJECTS";
    static final String REPO_PAGE_ID;
    static final String PROJ_PAGE_ID;
    static final String SRCDB_PAGE_ID;
    static final String CAPT_PAGE_ID;
    static final String CONV_PAGE_ID;
    static final String TRSLTE_PAGE_ID;
    static final String TGTDB_PAGE_ID;
    static final String MVDAT_PAGE_ID;

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(QMWizardArb.getString("STEP0"), WelcomePageMigration.class, "f1_qmhelp_id_for_step0");
        fSMBuilder.newStartState(step, (Object)"step0");
        Step step2 = new Step(QMWizardArb.getString("STEP1"), RepoPageMigration.class, "f1_qmhelp_id_for_step1");
        fSMBuilder.newState((Object)"step0", step2, (Object)"step1");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step3 = new Step(QMWizardArb.getString("STEP2"), ProjectPageMigration.class, "f1_qmhelp_id_for_step2");
        fSMBuilder.newState((Object)"step1", step3, (Object)"step2");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step4 = new Step(QMWizardArb.getString("STEP3"), SourceDBPageMigration.class, "f1_qmhelp_id_for_step3");
        fSMBuilder.newState((Object)"step2", step4, (Object)"step3");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step5 = new Step(QMWizardArb.getString("STEP4"), CapturePageMigration.class, "f1_qmhelp_id_for_step4");
        fSMBuilder.newState((Object)"step3", step5, (Object)"step4");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step6 = new Step(QMWizardArb.getString("STEP5"), ConvertPageMigration.class, "f1_qmhelp_id_for_step5");
        fSMBuilder.newState((Object)"step4", step6, (Object)"step5");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step7 = new Step(QMWizardArb.getString("STEP6"), TranslatePageMigration.class, "f1_qmhelp_id_for_step6");
        fSMBuilder.newState((Object)"step5", step7, (Object)"step6");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step8 = new Step(QMWizardArb.getString("STEP8"), TargetDBPageMigration.class, "f1_qmhelp_id_for_step8");
        fSMBuilder.newState((Object)"step6", step8, (Object)"step8");
        fSMBuilder.addStateTrans((Object)TRANSITION_TO_SUMMARY, (Object)"step9");
        Step step9 = new Step(QMWizardArb.getString("STEP9"), MoveDataPageMigration.class, "f1_qmhelp_id_for_step9");
        fSMBuilder.newState((Object)"step8", step9, (Object)"step9");
        Step step10 = new Step(QMWizardArb.getString("STEP10"), SummaryPageMigration.class, "f1_qmhelp_id_for_step10");
        fSMBuilder.newFinalState((Object)"step9", step10);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public static QMWizard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QMWizard();
        }
        return INSTANCE;
    }

    public static void removeExistingMigrationFileHandler(Logger logger) {
        Handler handler = null;
        for (Handler handler2 : logger.getHandlers()) {
            if (!(handler2 instanceof MigrationFileHandler)) continue;
            handler = handler2;
        }
        if (handler != null) {
            logger.removeHandler(handler);
        }
    }

    public static void updateLogFileHandler(String string) {
        try {
            QMWizard.removeExistingMigrationFileHandler(m_logger);
            if (string != null) {
                m_logger.addHandler(new MigrationFileHandler(string));
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public WizardDialog getWizard() {
        m_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        FSM fSM = QMWizard.getFSM();
        Namespace namespace = new Namespace();
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        fSMWizard.setWizardTitle(QMWizardArb.getString("MAIN_TITLE"));
        fSMWizard.setLogoImage(MigrationAddinArb.getImage("MIGRATION_PROJECT_WIZARD_HEADER"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(QMWizardArb.getImage("WIZ_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.setSize(800, 800);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public void launch() {
        ContextHelper.init();
        WizardDialog wizardDialog = this.getWizard();
        WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.requestFocusInWindow();
    }

    static {
        REPO_PAGE_ID = QMWizardArb.getString("STEP1");
        PROJ_PAGE_ID = QMWizardArb.getString("STEP2");
        SRCDB_PAGE_ID = QMWizardArb.getString("STEP3");
        CAPT_PAGE_ID = QMWizardArb.getString("STEP4");
        CONV_PAGE_ID = QMWizardArb.getString("STEP5");
        TRSLTE_PAGE_ID = QMWizardArb.getString("STEP6");
        TGTDB_PAGE_ID = QMWizardArb.getString("STEP8");
        MVDAT_PAGE_ID = QMWizardArb.getString("STEP9");
    }

    public static class ContextHelper {
        private static String _actnCmdStr;
        private static String _ctxProtocol;
        private static String _ctxObjType;
        private static String _ctxFldrType;
        private static String _ctxObjName;
        private static String _connName;
        private static String _connType;
        private static String _catalogName;
        private static String _schemaName;
        private static Collection<String> _dbFromNavSel;
        private static String _defaultRepos;
        private static ArrayList<String> _captureDBList;
        private static Collection<String> um_captureDBList;
        private static String _targetConnName;
        private static MigrationWizardFinisher _finisher;
        private static Element _nodeElem;
        private static MdProject _project;
        private static MdConnection _captConnection;
        private static MdConnection _convConnection;
        private static HashSet<String> _commitSet;
        private static HashMap<String, SummaryProvider> _summaryProvider;
        private static final String KEY_DELIMITER = "$#$";

        static void addCommitPage(String string) {
            _commitSet.add(string);
        }

        static void addSummaryProvider(String string, SummaryProvider summaryProvider) {
            if (_summaryProvider != null && string != null && string.trim().length() > 0) {
                _summaryProvider.put(string, summaryProvider);
            }
        }

        static void buildCaptureDBListForTheDummyCatalog(MdCatalog mdCatalog) {
            String string = "select schema_name from mgv_all_schema where catalog_id = ?";
            Connection connection = MigrationAddin.getPersistenceManager().getConn();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            long l = 0L;
            String string2 = null;
            try {
                l = mdCatalog.getKey().getId();
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                while (resultSet != null && resultSet.next()) {
                    string2 = resultSet.getString(1);
                    _captureDBList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
        }

        static void clearCaptureMode() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_on", false);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_off", false);
            }
        }

        static void clearDataMoveMode() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_off", false);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_on", false);
            }
        }

        static void clearScriptGenMode() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_on", false);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_off", false);
            }
        }

        public static String extractLabelTextWithoutMnemonic(String string) {
            String string2 = string;
            int n = string.length();
            if (string != null && n > 0) {
                int n2 = string.lastIndexOf(38);
                if (n2 >= 0) {
                    int n3 = string.lastIndexOf(40, n2 - 1);
                    int n4 = string.indexOf(41, n2 + 1);
                    StringBuffer stringBuffer = new StringBuffer(string);
                    if (n3 == n2 - 1 && n4 == n2 + 2) {
                        stringBuffer.delete(n3, n4 + 1);
                    } else {
                        stringBuffer.deleteCharAt(n2);
                    }
                    string2 = stringBuffer.toString();
                } else {
                    String string3;
                    boolean bl;
                    int n5 = -1;
                    if (string != null && string.trim().endsWith("...")) {
                        n5 = string.indexOf("...");
                        string = string.substring(0, n5).trim();
                    }
                    if (bl = (string3 = string.substring((n = string.length()) - 3)).matches("\\(\\w\\)")) {
                        string2 = string.substring(0, n - 3);
                        if (n5 > 0) {
                            string2 = string2 + "...";
                        }
                    }
                }
            }
            if (string2 != null && string2.length() > 0) {
                string2 = string2.trim();
            }
            return string2;
        }

        static String getActionName() {
            return _actnCmdStr;
        }

        static Iterator<String> getActiveCommitPages() {
            return _commitSet != null ? _commitSet.iterator() : null;
        }

        public static Collection<String> getAvailableDBListOffline(String string, String string2) {
            return DatabaseProviderRegistry.getAvailableDBListOffline(string, string2);
        }

        static Collection<String> getAvailableDBListOnline(String string, String string2) {
            return DatabaseProviderRegistry.getAvailableDBListOnline(string, string2);
        }

        static Collection<String> getCaptureDBList() {
            PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
            CloseableIterator<MgvAllCatalogsRec> closeableIterator = null;
            MgvAllCatalogsRec mgvAllCatalogsRec = null;
            if (_captureDBList == null && _captConnection != null) {
                try {
                    closeableIterator = persistenceUtility.getCatalogsForConnectionId(_captConnection.getKey());
                    MdCatalog mdCatalog = null;
                    while (closeableIterator != null && closeableIterator.hasNext()) {
                        if (_captureDBList == null) {
                            _captureDBList = new ArrayList();
                        }
                        if (!MigrationUtils.catalogIsDummy(mdCatalog = MdCatalog.retrieveExistingInstance(persistenceManager, (mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next()).getCatalogId()))) {
                            _captureDBList.add(mgvAllCatalogsRec.getCatalogName());
                            continue;
                        }
                        ContextHelper.buildCaptureDBListForTheDummyCatalog(mdCatalog);
                    }
                    um_captureDBList = _captureDBList == null ? (Collection<Object>)null : Collections.unmodifiableCollection(_captureDBList);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
            return um_captureDBList;
        }

        static MdConnection getCapturedConnectionObject() {
            return _captConnection;
        }

        static String getCapturedConnectionURL() {
            String string = _captConnection != null ? _captConnection.getDburl() : null;
            return string;
        }

        static ArrayList<String> getCapturedDBList(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Connection connection = null;
            String string2 = null;
            try {
                connection = Connections.getInstance().getConnection(string);
                string2 = connection != null ? connection.getCatalog() : null;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            arrayList.add(string2);
            return arrayList;
        }

        static String getConnName() {
            return _connName;
        }

        static String getConnType() {
            return _connType;
        }

        static Element getContextElement() {
            return _nodeElem;
        }

        static MdConnection getConvertedConnectionObject() {
            return _convConnection;
        }

        static String getCtxCatalogName() {
            return _catalogName;
        }

        static String getCtxFolderType() {
            return _ctxFldrType;
        }

        static String getCtxObjName() {
            return _ctxObjName;
        }

        static String getCtxSchemaName() {
            return _schemaName;
        }

        static String getDefaultRepository() {
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            String string = _defaultRepos = migrationConfig != null ? migrationConfig.getDefaultRepository() : "";
            if (_defaultRepos.trim().length() == 0) {
                _defaultRepos = null;
            }
            return _defaultRepos;
        }

        public static MigrationPlugin getMigrationPluginOffline(String string) throws Exception {
            MigrationPlugin migrationPlugin = null;
            File file = new File(string);
            String string2 = string.substring(string.lastIndexOf(File.separatorChar));
            if (string2.toUpperCase().endsWith("XML")) {
                return MigrationAddin.findPlugin("oracle.dbtools.migration.workbench.plugin.MSAccessPlugin");
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String string3 = (String)properties.get("OfflinePluginIdentifier");
            if (string3 == null || string3.trim().length() == 0) {
                String string4 = MigrationAddinArb.format("ERR_FILE_INVALID_FORMAT", file.getName());
                throw new Exception(string4);
            }
            migrationPlugin = MigrationAddin.findPlugin(string3);
            if (migrationPlugin == null) {
                throw new Exception(MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE"));
            }
            return migrationPlugin;
        }

        static MigrationPlugin getMigrationPluginOnline(String string) throws Exception {
            MigrationPlugin migrationPlugin = null;
            Connection connection = Connections.getInstance().getConnection(string);
            if (connection != null) {
                migrationPlugin = MigrationAddin.getPluginForConnection(connection);
            }
            if (migrationPlugin == null) {
                throw new Exception(MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE"));
            }
            return migrationPlugin;
        }

        static Collection<String> getMultiCatalogListFromNavSelection(String string) {
            if (_dbFromNavSel == null) {
                return null;
            }
            DatabaseProviderRegistry.bleachSystemObjects(string, _dbFromNavSel);
            Collection<String> collection = Collections.unmodifiableCollection(_dbFromNavSel);
            _dbFromNavSel = null;
            return collection;
        }

        static String getOfflineCaptureDir() {
            String string = _project != null ? _project.getProjectName() : null;
            String string2 = null;
            if (string2 == null && _captConnection != null) {
                string2 = MigrationAddin.getMigrationConfig().getStringProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "offline_captdir", null);
            }
            return string2;
        }

        static MigrationPlugin getPlugin() {
            MigrationPlugin migrationPlugin = null;
            try {
                MdConnection mdConnection = ContextHelper.getCapturedConnectionObject();
                if (mdConnection != null) {
                    String string = mdConnection.getProperty("PLUGIN_ID");
                    migrationPlugin = MigrationAddin.getPlugin(string);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            return migrationPlugin;
        }

        static MdProject getProject() {
            return _project;
        }

        static String getProjectDescription() {
            String string = null;
            if (_project != null) {
                string = _project.getComments();
            }
            return string;
        }

        static String getProjectName() {
            String string = null;
            if (_project != null) {
                string = _project.getProjectName();
            }
            return string;
        }

        static String getProjectOutputDir(String string) {
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            String string2 = null;
            if (string != null) {
                string2 = migrationConfig != null ? migrationConfig.getStringProperty(string + "_" + "outdir", null) : null;
            }
            QMWizard.updateLogFileHandler(string2);
            return string2;
        }

        static String getProjectSourceConnection(String string) {
            String string2 = null;
            string2 = MigrationAddin.getMigrationConfig().getStringProperty(string + KEY_DELIMITER + (_captConnection != null ? _captConnection.getKey() : "") + KEY_DELIMITER + "source_conn", null);
            return string2;
        }

        static SummaryProvider getProjectSummaryProvider(String string) {
            return _summaryProvider != null ? _summaryProvider.get(string) : null;
        }

        static String getProjectTargetConnection(String string) {
            String string2 = null;
            string2 = MigrationAddin.getMigrationConfig().getStringProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "target_conn", null);
            return string2;
        }

        static String getTargetConnectionName() {
            return _targetConnName;
        }

        static MigrationWizardFinisher getWizardFinisher() {
            _finisher.initCommitActionMask();
            return _finisher;
        }

        static void init() {
            Object object;
            ContextHelper.setNodesToNull();
            Context context = QMLauncher.getStaticContext();
            Element[] elementArray = (Element[])context.getProperty("Context.SELECTION");
            int n = elementArray != null ? elementArray.length : 0;
            ArrayList<String> arrayList = null;
            Element element = null;
            for (int i = 0; i < n; ++i) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (!((element = elementArray[i]) instanceof CatalogFolder) && !(element instanceof SchemaFolder)) continue;
                arrayList.add(element.getLongLabel());
            }
            _dbFromNavSel = arrayList;
            _nodeElem = null;
            _finisher = new MigrationWizardFinisher();
            Object object2 = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
            Object object3 = context.getProperty("Context.EVENT");
            ActionEvent actionEvent = null;
            if (object2 == null && n > 0 && (object = new DBObject(_nodeElem = elementArray[0])) != null) {
                object2 = object;
            }
            if (object2 != null) {
                if (object3 instanceof ActionEvent && (_actnCmdStr = (actionEvent = (ActionEvent)object3).getActionCommand()) != null) {
                    _actnCmdStr = ContextHelper.extractLabelTextWithoutMnemonic(_actnCmdStr);
                }
                _ctxProtocol = (object = object2.getURL()) == null ? null : ((URL)object).getProtocol();
                _ctxObjType = object2.getObjectType();
                _ctxFldrType = object2.getObjectFolderType();
                _ctxObjName = object2.getObjectName();
                _connType = object2.getConnectionType();
                _connName = object2.getConnectionName();
                if (_connType == null || !_connType.equals("MIGREPO") && !_connType.equals("MIGPROJ")) {
                    _actnCmdStr = null;
                }
                _catalogName = object2.getCatalog();
                _schemaName = object2.getSchemaName();
                _nodeElem = object2.getElement();
            }
            _commitSet = new HashSet();
            _summaryProvider = new HashMap();
            if (_nodeElem instanceof CapturedConnectionNode) {
                object = (CapturedConnectionNode)_nodeElem;
                _captConnection = ((MigrationConnectionNode)object).getMdConnection();
                DBObjectId dBObjectId = _captConnection.getProjectId();
                PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                try {
                    _project = MdProject.retrieveExistingInstance(persistenceManager, dBObjectId);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            } else if (_nodeElem instanceof MigrationProjectsFolderNode) {
                object = (MigrationProjectsFolderNode)_nodeElem;
                _actnCmdStr = null;
            } else if (_nodeElem instanceof MigrationProjectNode) {
                object = (MigrationProjectNode)_nodeElem;
                _project = ((MigrationProjectNode)object).getMdProject();
            } else if (_nodeElem instanceof CapturedObjectsFolderNode) {
                object = MigrationAddin.getPersistenceManager();
                CapturedObjectsFolderNode capturedObjectsFolderNode = (CapturedObjectsFolderNode)_nodeElem;
                DBObjectId dBObjectId = (DBObjectId)capturedObjectsFolderNode.getDict().get("CONNECTION_OBJID");
                DBObjectId dBObjectId2 = null;
                try {
                    _captConnection = MdConnection.retrieveExistingInstance((PersistenceManager)object, dBObjectId);
                    dBObjectId2 = _captConnection.getProjectId();
                    _project = MdProject.retrieveExistingInstance((PersistenceManager)object, dBObjectId2);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            } else if (_nodeElem instanceof ConvertedModelsFolderNode) {
                object = (ConvertedModelsFolderNode)_nodeElem;
                _convConnection = ((ConvertedModelsFolderNode)object).getConvertedConnection();
                DBObjectId dBObjectId = (DBObjectId)((ConvertedModelsFolderNode)object).getDict().get("CAPT_CONNECTION_OBJID");
                DBObjectId dBObjectId3 = ((ConvertedModelsFolderNode)object).getConvertedConnection().getProjectId();
                PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                try {
                    _project = MdProject.retrieveExistingInstance(persistenceManager, dBObjectId3);
                    _captConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            } else if (_nodeElem instanceof CatalogFolderNode) {
                object = (CatalogFolderNode)_nodeElem;
                DBObjectId dBObjectId = (DBObjectId)((CatalogFolderNode)object).getCatalogInstance().getProperty("CAPT_CONNECTION_OBJID");
                PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                DBObjectId dBObjectId4 = (DBObjectId)((CatalogFolderNode)object).getDict().get("CONNECTION_OBJID");
                DBObjectId dBObjectId5 = null;
                try {
                    _captConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
                    _convConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId4);
                    dBObjectId5 = _convConnection.getProjectId();
                    _project = MdProject.retrieveExistingInstance(persistenceManager, dBObjectId5);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            } else if (_nodeElem instanceof SchemaFolderNode) {
                object = (SchemaFolderNode)_nodeElem;
                DBObjectId dBObjectId = (DBObjectId)object.getSchemaInstance().getProperty("CAPT_CONNECTION_OBJID");
                PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                DBObjectId dBObjectId6 = (DBObjectId)object.getSchemaInstance().getProperty("CONNECTION_OBJID");
                DBObjectId dBObjectId7 = null;
                try {
                    _captConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
                    _convConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId6);
                    dBObjectId7 = _convConnection.getProjectId();
                    _project = MdProject.retrieveExistingInstance(persistenceManager, dBObjectId7);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
        }

        static boolean isActiveCommitPage(String string) {
            return _commitSet.contains(string);
        }

        static boolean isCaptureModeOffline() {
            String string;
            boolean bl = false;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_off") : false;
            }
            return bl;
        }

        static boolean isCaptureModeOnline() {
            String string;
            boolean bl = false;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_on") : false;
            }
            return bl;
        }

        static boolean isDataMoveModeOffline() {
            String string;
            boolean bl = false;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_off") : false;
            }
            return bl;
        }

        static boolean isDataMoveModeOnline() {
            boolean bl = false;
            String string = _project != null ? _project.getProjectName() : null;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            if (string != null && _captConnection != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_on") : false;
            }
            return bl;
        }

        static boolean isMigrationAction() {
            boolean bl = false;
            if (_ctxProtocol == null || _ctxProtocol.equals("sqldev.migration")) {
                bl = true;
            }
            return bl;
        }

        static boolean isScriptGenModeOffline() {
            boolean bl = false;
            String string = _project != null ? _project.getProjectName() : null;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            if (string != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + KEY_DELIMITER + "_" + "genmode_off") : false;
            }
            return bl;
        }

        static boolean isScriptGenModeOnline() {
            boolean bl = false;
            String string = _project != null ? _project.getProjectName() : null;
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            if (string != null) {
                bl = migrationConfig != null ? migrationConfig.getBooleanProperty(string + "_" + "genmode_on") : false;
            }
            return bl;
        }

        static void removeCommitPage(String string) {
            _commitSet.remove(string);
        }

        static void resetCapturedDBList() {
            _captureDBList = null;
            um_captureDBList = null;
        }

        static void setCaptureModeOffline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_off", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_on", false);
            }
        }

        static void setCaptureModeOnline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_on", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "captmode_off", false);
            }
        }

        static void setDataMoveModeOffline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_off", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_on", false);
            }
        }

        static void setDataMoveModeOnline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_on", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "datamove_mode_off", false);
            }
        }

        private static void setNodesToNull() {
            _convConnection = null;
            _project = null;
            _captConnection = null;
            _ctxFldrType = null;
            _ctxProtocol = null;
            _ctxObjType = null;
            _actnCmdStr = null;
            _ctxObjName = null;
            _connName = null;
            _connType = null;
            _catalogName = null;
            _schemaName = null;
            _defaultRepos = null;
            _targetConnName = null;
            _captureDBList = null;
            _dbFromNavSel = null;
        }

        static void setOfflineCaptureDir(String string) {
            String string2;
            String string3 = string2 = _project != null ? _project.getProjectName() : null;
            if (string2 != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setStringProperty(string2 + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "offline_captdir", string);
            }
        }

        static void setProjectOutputDir(String string) {
            String string2;
            String string3 = string2 = _project != null ? _project.getProjectName() : null;
            if (string2 != null) {
                MigrationAddin.getMigrationConfig().setStringProperty(string2 + "_" + "outdir", string);
            }
        }

        static void setProjectSourceConnection(String string, String string2) {
            if (_captConnection != null) {
                MigrationAddin.getMigrationConfig().setStringProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "source_conn", string2);
            }
        }

        static void setProjectTargetConnection(String string, String string2) {
            MigrationAddin.getMigrationConfig().setStringProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "target_conn", string2);
        }

        static void setScriptGenModeOffline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_off", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_on", false);
            }
        }

        static void setScriptGenModeOnline() {
            String string;
            String string2 = string = _project != null ? _project.getProjectName() : null;
            if (string != null && _captConnection != null) {
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_on", true);
                MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + _captConnection.getKey() + KEY_DELIMITER + "genmode_off", false);
            }
        }

        static String showDirectoryChooser() {
            String string = null;
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.clearChooseableURLFilters();
            uRLFileChooser.setSelectionScope(1);
            uRLFileChooser.setSelectionMode(0);
            int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), QMWizardArb.getString("ChooseDir"));
            if (n == 0) {
                URL uRL = uRLFileChooser.getSelectedURL();
                if (uRL != null && uRL.toString().length() > 0) {
                    File file = new File(uRL.getPath());
                    if (!file.isDirectory()) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)QMWizardArb.getString("InvalidOutputDir"), (String)QMWizardArb.getString("ChooseFile"), null);
                    } else {
                        string = file.getAbsolutePath();
                    }
                }
            } else {
                string = null;
            }
            return string;
        }
    }
}

