/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.EventExecute;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;

public class EventParse
implements IElapsedEvent,
IResourceEvent {
    private static final Logger LOGGER = Logger.getLogger(EventParse.class.getName());
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++):c=([0-9]++),e=([0-9]++),p=([0-9]++),cr=([0-9]++),cu=([0-9]++),mis=([0-9]++),r=([0-9]++),dep=([0-9]++),og=([0-9]++),tim=([0-9]++)");
    private long _curNum;
    private long _time;
    private long _optimizer;
    private long _misses;
    private long _rows;
    private long _depLevel;
    private long _logicalIO;
    private long _phyIO;
    private long _consisIO;
    private long _elapsed;
    private long _cpu;

    public EventParse(String string) {
        string = EventExecute.trimPLH(string);
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._curNum = Long.parseLong(matcher.group(1));
            this._cpu = Long.parseLong(matcher.group(2));
            this._elapsed = Long.parseLong(matcher.group(3));
            this._phyIO = Long.parseLong(matcher.group(4));
            this._consisIO = Long.parseLong(matcher.group(5));
            this._logicalIO = Long.parseLong(matcher.group(6));
            this._misses = Long.parseLong(matcher.group(7));
            this._rows = Long.parseLong(matcher.group(8));
            this._depLevel = Long.parseLong(matcher.group(9));
            this._optimizer = Long.parseLong(matcher.group(10));
            this._time = Long.parseLong(matcher.group(11));
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public String toString() {
        return String.format("PARSE #%d:c=%d,e=%d,p=%d,cr=%d,cu=%d,mis=%d,r=%d,dep=%d,og=%d,tim=%d", this._curNum, this._cpu, this._elapsed, this._phyIO, this._consisIO, this._logicalIO, this._misses, this._rows, this._depLevel, this._optimizer, this._time);
    }

    public static void main(String[] stringArray) {
        String string = "PARSE #51:c=10000,e=3613,p=0,cr=0,cu=0,mis=1,r=0,dep=0,og=0,tim=308762334929";
        EventParse eventParse = new EventParse(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + eventParse.toString());
    }

    @Override
    public long getConsistantIO() {
        return this._consisIO;
    }

    public long getCPU() {
        return this._cpu;
    }

    public long getCursorNum() {
        return this._curNum;
    }

    public long getDepLevel() {
        return this._depLevel;
    }

    @Override
    public long getElapsed() {
        return this._elapsed;
    }

    @Override
    public long getLogicalIO() {
        return this._logicalIO;
    }

    @Override
    public long getCacheMisses() {
        return this._misses;
    }

    public long getOptimizer() {
        return this._optimizer;
    }

    @Override
    public long getPhysicalIO() {
        return this._phyIO;
    }

    @Override
    public long getRows() {
        return this._rows;
    }

    @Override
    public long getTime() {
        return this._time;
    }
}

