/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.parser.EventConstants;
import oracle.dbtools.raptor.sqltrace.parser.EventExecute;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;

public class EventWait
implements IElapsedEvent {
    private static final Logger LOGGER = Logger.getLogger(EventWait.class.getName());
    private long _num;
    private String _name;
    private long _elapsed;
    private long _p1;
    private long _p2;
    private long _p3;
    private String _p1Name;
    private String _p2Name;
    private String _p3Name;
    private long _time;
    private long _obj;
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++): nam='([/:a-zA-Z0-9 \\*]++)' ela=[ ]??([0-9]++) p1=([0-9]++) p2=([0-9]++) p3=([0-9]++)");
    private static final Pattern PATTERN_11g = Pattern.compile("#([0-9]++): nam='(.*)' ela=[ ]??([0-9]++) (.*)=([0-9]++) (.*)=([0-9]++) (.*)=([0-9]++) obj#=([0-9]++) tim=([0-9]++)");

    public EventWait(String string) {
        string = EventExecute.trimPLH(string);
        String string2 = string.substring(string.indexOf("#") + 1, string.indexOf(":"));
        this._num = Long.parseLong(string2);
        this._name = string.substring(string.indexOf("nam='") + 5, string.indexOf("'", string.indexOf("'") + 1));
        string2 = string.substring(string.indexOf("ela=") + 4).trim();
        int n = 0;
        this._elapsed = Long.parseLong(string2.substring(n, string2.indexOf(" ")));
        string2 = string2.substring(string2.indexOf(" ")).trim();
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._num = Long.parseLong(matcher.group(1));
            this._name = matcher.group(2);
            this._elapsed = Long.parseLong(matcher.group(3));
            this._p1 = Long.parseLong(matcher.group(4));
            this._p2 = Long.parseLong(matcher.group(5));
            this._p3 = Long.parseLong(matcher.group(6));
        } else {
            matcher = PATTERN_11g.matcher(string);
            if (matcher.find()) {
                this._num = Long.parseLong(matcher.group(1));
                this._name = matcher.group(2);
                this._elapsed = Long.parseLong(matcher.group(3));
                this._p1Name = matcher.group(4);
                this._p1 = Long.parseLong(matcher.group(5));
                this._p2Name = matcher.group(6);
                this._p2 = Long.parseLong(matcher.group(7));
                this._p3Name = matcher.group(8);
                this._p3 = Long.parseLong(matcher.group(9));
                this._obj = Long.parseLong(matcher.group(10));
                this._time = Long.parseLong(matcher.group(11));
            } else {
                LOGGER.severe(TuningResources.getString("EventWait.10") + string);
            }
        }
    }

    public String toString() {
        return String.format("WAIT #%d: nam='%s' ela=%d p1=%d p2=%d p3=%d", this._num, this._name, this._elapsed, this._p1, this._p2, this._p3);
    }

    @Override
    public long getElapsed() {
        return this._elapsed;
    }

    public String getName() {
        return this._name;
    }

    public long getNum() {
        return this._num;
    }

    public long getP1() {
        return this._p1;
    }

    public long getP2() {
        return this._p2;
    }

    public long getP3() {
        return this._p3;
    }

    public String getP1Name() {
        return this._p1Name != null ? this._p1Name : EventConstants.getWaitP1(this._name);
    }

    public String getP2Name() {
        return this._p2Name != null ? this._p2Name : EventConstants.getWaitP2(this._name);
    }

    public String getP3Name() {
        return this._p3Name != null ? this._p3Name : EventConstants.getWaitP3(this._name);
    }

    public String getWaitClass() {
        return EventConstants.getWaitClass(this._name);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        for (String string : stringArray2 = new String[]{"WAIT #4: nam='SQL*Net message from client' ela= 1113 p1=1413697536 p2=1 p3=0", "WAIT #2: nam='latch: library cache' ela= 1022 p1=1612018620 p2=215 p3=0", "WAIT #4: nam='SQL*Net message from client' ela= 1113 p1=1413697536 p2=1 p3=0", "WAIT #0: nam='SQL*Net message from client' ela= 4500 driver id=675562835 #bytes=1 p3=0 obj#=45065 tim=1143252281575923", "WAIT #32: nam='gc cr grant 2-way' ela= 1357 p1=11 p2=33366 p3=1 obj#=69923 tim=1143252281541135"}) {
            EventWait eventWait = new EventWait(string);
            PrintStream printStream = System.out;
            printStream.println("TEST:" + string);
            printStream.println("REST:" + eventWait.toString());
            printStream.println(eventWait.getWaitClass());
            printStream.println(eventWait.getP1Name() + "=" + eventWait.getP1());
            printStream.println(eventWait.getP2Name() + "=" + eventWait.getP2());
            printStream.println(eventWait.getP3Name() + "=" + eventWait.getP3());
        }
    }
}

