/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Stat {
    private static final Logger LOGGER = Logger.getLogger(Stat.class.getName());
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++) id=([0-9]++) cnt=([0-9]++) pid=([0-9]++) pos=([0-9]++) obj=([0-9]++) op='(.*)'");
    private long _curNum;
    private long _rows;
    private int _pid;
    private int _pos;
    private long _obj;
    private String _op;
    private int _id;
    private ArrayList<Stat> _stats = new ArrayList();

    public Stat(String string) {
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._curNum = Long.parseLong(matcher.group(1));
            this._id = Integer.parseInt(matcher.group(2));
            this._rows = Long.parseLong(matcher.group(3));
            this._pid = Integer.parseInt(matcher.group(4));
            this._pos = Integer.parseInt(matcher.group(5));
            this._obj = Long.parseLong(matcher.group(6));
            this._op = matcher.group(7);
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public String toString() {
        return String.format("STAT #%d id=%d cnt=%d pid=%d pos=%d obj=%d op='%s'", this._curNum, this._id, this._rows, this._pid, this._pos, this._obj, this._op);
    }

    public static void main(String[] stringArray) {
        String string = "STAT #1 id=2 cnt=0 pid=1 pos=1 obj=37 op='INDEX RANGE SCAN I_OBJ2 (cr=2 pr=0 pw=0 time=87 us)'";
        Stat stat = new Stat(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + stat.toString());
    }

    public long getCursorNumber() {
        return this._curNum;
    }

    public int getId() {
        return this._id;
    }

    public long getObjectId() {
        return this._obj;
    }

    public String getOperation() {
        return this._op;
    }

    public int getPid() {
        return this._pid;
    }

    public int getPosition() {
        return this._pos;
    }

    public long getRows() {
        return this._rows;
    }

    public void addChild(Stat stat) {
        this._stats.add(stat);
    }

    public ArrayList<Stat> getStats() {
        return this._stats;
    }
}

