/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.printers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.parser.EventWait;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.SqlTraceUtils;

public class DBTablePrinter {
    Connection _conn;

    private void logSummary(ArrayList<SqlCursor> arrayList) {
        int n = 0;
        int n2 = 0;
        for (SqlCursor sqlCursor : arrayList) {
            n = (int)((long)n + sqlCursor.getParseMissCount());
        }
        for (SqlCursor sqlCursor : arrayList) {
            n2 = (int)((long)n2 + sqlCursor.getExecuteMissCount());
        }
        long l = this.createTraceRecord(n, n2);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (SqlCursor object2 : arrayList) {
            f += object2.getParseCount();
            f2 += object2.getParseCPU();
            f3 += object2.getParseElapsed(false);
            f4 += object2.getParseDisk();
            f5 += object2.getParseQuery();
            f6 += object2.getParseCurrent();
            f7 += object2.getParseRows();
        }
        this.insertTraceFileSummary(l, TuningResources.getString("DBTablePrinter.0"), f, SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), f4, f5, f6, f7);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += (float)sqlCursor.getExecuteCount();
            f2 += sqlCursor.getExecuteCPU();
            f3 += sqlCursor.getExecuteElapsed(false);
            f4 += sqlCursor.getExecuteDisk();
            f5 += sqlCursor.getExecuteQuery();
            f6 += sqlCursor.getExecuteCurrent();
            f7 += sqlCursor.getExecuteRows();
        }
        this.insertTraceFileSummary(l, TuningResources.getString("DBTablePrinter.1"), f, SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), f4, f5, f6, f7);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += sqlCursor.getFetchCount();
            f2 += sqlCursor.getFetchCPU();
            f3 += sqlCursor.getFetchElapsed(false);
            f4 += sqlCursor.getFetchDisk();
            f5 += sqlCursor.getFetchQuery();
            f6 += sqlCursor.getFetchCurrent();
            f7 += sqlCursor.getFetchRows();
        }
        this.insertTraceFileSummary(l, TuningResources.getString("DBTablePrinter.2"), f, SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), f4, f5, f6, f7);
        f7 = 0.0f;
        f6 = 0.0f;
        f5 = 0.0f;
        f4 = 0.0f;
        f3 = 0.0f;
        f2 = 0.0f;
        f = 0.0f;
        for (SqlCursor sqlCursor : arrayList) {
            f += sqlCursor.getTotalCount();
            f2 += sqlCursor.getTotalCPU();
            f3 += sqlCursor.getTotalElapsed(false);
            f4 += sqlCursor.getTotalDisk();
            f5 += sqlCursor.getTotalQuery();
            f6 += sqlCursor.getTotalCurrent();
            f7 += sqlCursor.getTotalRows();
        }
        this.insertTraceFileSummary(l, TuningResources.getString("DBTablePrinter.3"), f, SqlTraceUtils.toSec(f2), SqlTraceUtils.toSec(f3), f4, f5, f6, f7);
        Object object3 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string = null;
        for (SqlCursor sqlCursor : arrayList) {
            for (IElapsedEvent iElapsedEvent : sqlCursor.getEvents()) {
                if (!(iElapsedEvent instanceof EventWait)) continue;
                object3 = (EventWait)iElapsedEvent;
                string = ((EventWait)object3).getName().intern();
                if (!arrayList2.contains(string)) {
                    arrayList2.add(string);
                    hashMap.put(string + ".times", new Long(1L));
                    hashMap.put(string + ".total", ((EventWait)object3).getElapsed());
                    hashMap.put(string + ".max", ((EventWait)object3).getElapsed());
                    continue;
                }
                hashMap.put(string + ".times", (Long)hashMap.get(string + ".times") + 1L);
                hashMap.put(string + ".total", (Long)hashMap.get(string + ".total") + ((EventWait)object3).getElapsed());
                if ((Long)hashMap.get(string + ".max") >= ((EventWait)object3).getElapsed()) continue;
                hashMap.put(string + ".max", ((EventWait)object3).getElapsed());
            }
        }
        for (String string2 : arrayList2) {
            this.insertWaitSummary(string2, (Long)hashMap.get(string2 + ".times"), SqlTraceUtils.toSec((Long)hashMap.get(string2 + ".max")), SqlTraceUtils.toSec((Long)hashMap.get(string2 + ".total")));
        }
    }

    private void insertWaitSummary(String string, Long l, float f, float f2) {
    }

    private void insertTraceFileSummary(long l, String string, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createTraceRecord(int n, int n2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long l = 0L;
        try {
            preparedStatement = this._conn.prepareStatement("select trace_id_seq.nextval from dual");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            l = resultSet.getLong(1);
            resultSet.close();
            preparedStatement.close();
            preparedStatement = this._conn.prepareStatement("insert into tracefile(id,parse_misses,execute_misses) values(?,?,?)");
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return l;
    }

    private void validateTables() {
    }
}

