/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public abstract class AbstractConnectionCreator
implements ConnectionCreator {
    @Deprecated
    protected ResourceBundle getBundle() {
        return DBAdapterBundle.getBundle();
    }

    protected Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    @Override
    public boolean shouldEncrypt(String propName) {
        return "password".equals(propName);
    }

    @Override
    public boolean shouldPromptForPassword(Properties props) {
        String savePass;
        String pass;
        boolean retval = false;
        Collection<String> allowedProps = this.listAllowedProperties();
        if (allowedProps.contains("password") && (pass = props.getProperty("password")) == null && (savePass = props.getProperty("SavePassword")) != null && !Boolean.valueOf(savePass).booleanValue()) {
            retval = true;
        }
        return retval;
    }

    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        String params = connProps.getProperty("parameters");
        JDBCParametersParser.parseParameterString(params, jdbcProps);
    }

    @Override
    public final Properties getJDBCProperties(Properties props) throws SQLException {
        String username = this.trimINN(props.getProperty("user"));
        String password = props.getProperty("password");
        if (this.hasLength(username) && !this.hasLength(password) && !this.allowNullPassword()) {
            throw new SQLException(DBAdapterBundle.get("ERROR_MISSING_PASS"), "");
        }
        Properties retval = new Properties();
        if (this.hasLength(username)) {
            retval.put("user", username);
        }
        if (this.hasLength(password)) {
            retval.put("password", password);
        }
        this.setCustomProperties(props, retval);
        return retval;
    }

    @Override
    public Connection getConnection(Properties props) throws SQLException {
        Connection conn;
        block4: {
            String url = this.getConnectionURL(props);
            Properties jdbcProps = this.getJDBCProperties(props);
            Driver driver = this.getDriver(props);
            conn = null;
            try {
                conn = driver.connect(url, jdbcProps);
            }
            catch (UnsatisfiedLinkError e) {
                throw new SQLException(e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                if (!(driver instanceof OracleDriver)) break block4;
                throw new SQLException(DBAdapterBundle.get("ERROR_UNSUPPORTED_ORACLE_VERSION"));
            }
        }
        if (conn == null) {
            throw new SQLException(this.getInvalidURLMessage());
        }
        return conn;
    }

    protected String getInvalidURLMessage() {
        return DBAdapterBundle.get("ERROR_INVALID_URL");
    }

    private String trimINN(String s) {
        return s == null ? s : s.trim();
    }

    protected boolean allowNullPassword() {
        Collection<String> allowedProps = this.listAllowedProperties();
        return !allowedProps.contains("password");
    }

    protected final boolean hasLength(String s) {
        return s != null && s.length() > 0;
    }

    protected final String getPropertyOrThrow(Properties props, String name) throws SQLException {
        String retval = props.getProperty(name);
        if (!this.hasLength(retval = this.trimINN(retval))) {
            this.throwMissingPropertyException(name);
        }
        return retval;
    }

    protected final void throwMissingPropertyException(String name) throws SQLException {
        throw new SQLException("Required property '" + name + "' cannot be null or empty");
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        return props.getProperty("customUrl");
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        return props.getProperty("driver");
    }

    protected Driver getDriver(Properties props) throws SQLException {
        String driverClassName = this.getDriverClassName(props);
        return this.loadDriver(driverClassName);
    }

    protected Driver loadDriver(String driverClassName) throws SQLException {
        try {
            ClassLoader cl = DatabaseProvider.getClassLoader(driverClassName, this.getClass().getClassLoader());
            Class<?> cls = Class.forName(driverClassName, true, cl);
            return (Driver)cls.newInstance();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (ClassNotFoundException cne) {
            throw new SQLException(DBAdapterBundle.get("ERROR_DRIVER_CLASS_NOT_FOUND"));
        }
        catch (Throwable t) {
            SQLException ex = new SQLException(t.getLocalizedMessage());
            ex.initCause(t);
            throw ex;
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("user");
        retval.add("password");
        retval.add("customUrl");
        retval.add("driver");
        retval.add("parameters");
        retval.add("subtype");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JDBCParameterInfo> listJDBCParameterInfos(Properties connProperties) throws SQLException {
        Properties testProps = new Properties();
        for (String prop : connProperties.stringPropertyNames()) {
            testProps.put(prop, connProperties.getProperty(prop));
        }
        for (String prop : this.listRequiredProperties()) {
            if (this.hasLength(testProps.getProperty(prop))) continue;
            testProps.setProperty(prop, "testValue");
        }
        String url = this.getConnectionURL(testProps);
        Driver driver = this.getDriver(testProps);
        DriverPropertyInfo[] infos = null;
        try {
            infos = driver.getPropertyInfo(url, connProperties);
        }
        catch (RuntimeException e) {
            this.getLogger().log(Level.FINE, "getPropertyInfo failed", e);
        }
        return this.convertToJDBCParameterInfos(infos);
    }

    protected Collection<JDBCParameterInfo> convertToJDBCParameterInfos(DriverPropertyInfo[] infos) {
        ArrayList<JDBCParameterInfo> retval = new ArrayList<JDBCParameterInfo>();
        if (infos != null) {
            for (DriverPropertyInfo info : infos) {
                if ("user".equals(info.name) || "password".equals(info.name)) continue;
                retval.add(new JDBCParameterInfo(info));
            }
        }
        return retval;
    }
}

