/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class DB2ConnectionCreator
extends AbstractConnectionCreator {
    public static final String DB2_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    public static final String DB2_WEBLOGIC_DRIVER_CLASS = "weblogic.jdbc.db2.DB2Driver";
    public static final String SUBTYPE_DB2 = "DB2";

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String retval = super.getDriverClassName(props);
        if (!this.hasLength(retval)) {
            retval = DB2_DRIVER_CLASS;
        }
        return retval;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String retval;
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            retval = customURL;
        } else {
            String server = this.getPropertyOrThrow(props, "hostname");
            String port = props.getProperty("port");
            String dbase = this.getPropertyOrThrow(props, "dataSourceName");
            boolean weblogic = DB2_WEBLOGIC_DRIVER_CLASS.equals(this.getDriverClassName(props));
            StringBuilder url = new StringBuilder("jdbc:");
            if (weblogic) {
                url.append("weblogic:");
            }
            url.append("db2://").append(server);
            if (this.hasLength(port)) {
                url.append(":").append(port);
            }
            if (weblogic) {
                url.append(";DatabaseName=").append(dbase);
            } else {
                url.append("/").append(dbase);
            }
            retval = url.toString();
        }
        return retval;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add("hostname");
        retval.add("port");
        retval.add("dataSourceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("hostname");
        retval.add("dataSourceName");
        return retval;
    }
}

