/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.sql.DataSource;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DB2ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdeveloper.db.adapter.DerbyConnectionCreator;
import oracle.jdeveloper.db.adapter.MySQLConnectionCreator;
import oracle.jdeveloper.db.adapter.ODBCConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleLiteConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLServerConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLiteConnectionCreator;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class DatabaseProvider
implements Referenceable,
DataSource {
    private static Map<String, ConnectionCreator> s_creators = new HashMap<String, ConnectionCreator>();
    static final Class PROVIDER_CLASS = DatabaseProvider.class;
    static final String PROVIDER_CLASSNAME = PROVIDER_CLASS.getName();
    public static final String SUBTYPE_CLASS_REFTYPE = "subtype";
    public static final String CUSTOM_URL_CLASS_REFTYPE = "customUrl";
    public static final String DRIVER_CLASS_REFTYPE = "driver";
    public static final String USERNAME_CLASS_REFTYPE = "user";
    public static final String PASSWORD_CLASS_REFTYPE = "password";
    public static final String ROLE_CLASS_REFTYPE = "role";
    public static final String HOSTNAME_CLASS_REFTYPE = "hostname";
    public static final String PORT_CLASS_REFTYPE = "port";
    public static final String SID_CLASS_REFTYPE = "sid";
    public static final String DSN_CLASS_REFTYPE = "dataSourceName";
    @Deprecated
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";
    public static final String PARAMETERS_CLASS_REFTYPE = "parameters";
    public static final String SERVICENAME_CLASS_REFTYPE = "serviceName";
    public static final String SAVE_PASSWORD_CLASS_REFTYPE = "SavePassword";
    @Deprecated
    public static final String DEPLOY_PASSWORD_CLASS_REFTYPE = "DeployPassword";
    @Deprecated
    public static final String ALL_SCHEMAS_REFTYPE = "allSchemas";
    private static DatabaseProviderClassLoaderFactory s_clFactory;
    private Properties m_properties;
    private String m_name;
    private transient PrintWriter m_pw;
    private transient int m_timeout;
    private ReferenceWorker m_worker;

    public DatabaseProvider() {
        this(null, null);
    }

    public DatabaseProvider(Properties props) {
        this(null, props);
    }

    public DatabaseProvider(String name, Properties props) {
        this.m_name = name;
        this.m_properties = props == null ? new Properties() : props;
    }

    public void setReferenceWorker(ReferenceWorker worker) {
        this.m_worker = worker;
    }

    @Override
    public Reference getReference() {
        ConnectionCreator cc = null;
        try {
            cc = DatabaseProvider.getCreator(this);
        }
        catch (SQLException sqe) {
            cc = new OracleConnectionCreator();
        }
        ReferenceWorker encryptionWorker = this.m_worker == null ? DatabaseProviderHelper.getDefaultWorker() : this.m_worker;
        Class factoryClass = encryptionWorker == null ? DatabaseProviderFactory1212.class : encryptionWorker.getFactoryClass();
        Reference ref = new Reference(PROVIDER_CLASSNAME, factoryClass.getName(), null);
        Enumeration<Object> keys = this.m_properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = this.getProperty(name);
            if (value == null) {
                Object actual = this.m_properties.get(name);
                if (actual == null) continue;
                DatabaseProvider.getLogger().log(Level.WARNING, "Invalid property in connection for key: " + name);
                continue;
            }
            if (cc.shouldEncrypt(name)) {
                DatabaseProviderHelper.PasswordPrompter pp;
                String savePass = this.getProperty(SAVE_PASSWORD_CLASS_REFTYPE);
                if (savePass == null || Boolean.valueOf(savePass).booleanValue()) {
                    char[] pwd = value.toCharArray();
                    Object addr = encryptionWorker == null ? new SecureRefAddr(name, pwd) : encryptionWorker.encrypt(name, pwd, this.m_name);
                    ref.add((RefAddr)addr);
                    continue;
                }
                if (value == null || (pp = DatabaseProviderHelper.getPasswordPrompter()) == null) continue;
                pp.cache(this.m_properties);
                continue;
            }
            if (name.equals("INTERNAL_STRINGS_TO_FILE")) continue;
            ref.add(new StringRefAddr(name, value));
        }
        return ref;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.m_properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = (Properties)this.m_properties.clone();
        props.setProperty(USERNAME_CLASS_REFTYPE, username);
        props.setProperty(PASSWORD_CLASS_REFTYPE, password);
        return this.getConnection(props);
    }

    private Connection getConnection(Properties props) throws SQLException {
        DatabaseProviderHelper.PasswordPrompter pp;
        ConnectionCreator creator;
        if (this.m_name != null && this.m_name.length() > 0) {
            Object obj = null;
            try {
                InitialContext ic = new InitialContext();
                try {
                    obj = ic.lookup("jdbc/" + this.m_name + "DS");
                }
                catch (NameNotFoundException nnfe) {
                    // empty catch block
                }
                if (obj == null) {
                    try {
                        obj = ic.lookup("java:comp/env/jdbc/" + this.m_name + "DS");
                    }
                    catch (NameNotFoundException nnfe) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (obj instanceof DataSource) {
                return ((DataSource)obj).getConnection();
            }
        }
        if ((creator = DatabaseProvider.getCreator(this)).shouldPromptForPassword(props) && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            return pp.promptForPassword(props, this.m_name, creator);
        }
        return creator.getConnection(props);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pw;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pw = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() {
        return DatabaseProvider.getLogger();
    }

    public String getConnectionURL() throws SQLException {
        return DatabaseProvider.getCreator(this).getConnectionURL(this.m_properties);
    }

    public Properties getJDBCProperties() throws SQLException {
        return DatabaseProvider.getCreator(this).getJDBCProperties(this.m_properties);
    }

    public String getDriverClassName() throws SQLException {
        return DatabaseProvider.getCreator(this).getDriverClassName(this.m_properties);
    }

    public boolean shouldPromptForCredentials() {
        ConnectionCreator creator = DatabaseProvider.getCreatorImpl(this);
        return creator != null && creator.shouldPromptForPassword(this.getProperties());
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public Properties getProperties() {
        return (Properties)this.m_properties.clone();
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.setProperty(name, value);
        }
    }

    public void disconnect() {
        DatabaseProviderHelper.PasswordPrompter pp = DatabaseProviderHelper.getPasswordPrompter();
        if (pp != null) {
            pp.disconnect(this.m_properties);
        }
    }

    public int hashCode() {
        return this.m_properties.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseProvider && this.equalsImpl((DatabaseProvider)obj);
    }

    private boolean equalsImpl(DatabaseProvider prov) {
        return DatabaseProvider.areEqual(this.m_properties, prov.m_properties);
    }

    public Attributes getAttributes() {
        BasicAttributes attrs = new BasicAttributes();
        Enumeration<Object> keys = this.m_properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = this.getProperty(name);
            if (value == null) continue;
            attrs.put(new BasicAttribute(name, value));
        }
        return attrs;
    }

    @Deprecated
    static ClassLoader getClassLoader(String driverClass) {
        return DatabaseProvider.getClassLoader(driverClass, null);
    }

    static ClassLoader getClassLoader(String driverClass, ClassLoader creatorClassLoader) {
        ClassLoader cl = null;
        if (s_clFactory != null) {
            cl = s_clFactory.getClassLoader(driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(Thread.currentThread().getContextClassLoader(), driverClass);
        }
        if (cl == null && creatorClassLoader != null) {
            cl = DatabaseProvider.tryLoad(creatorClassLoader, driverClass);
        }
        ClassLoader ourClassLoader = PROVIDER_CLASS.getClassLoader();
        if (cl == null && creatorClassLoader != ourClassLoader) {
            cl = DatabaseProvider.tryLoad(ourClassLoader, driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(ClassLoader.getSystemClassLoader(), driverClass);
        }
        return cl;
    }

    private static ClassLoader tryLoad(ClassLoader l, String name) {
        if (l == null) {
            return null;
        }
        try {
            l.loadClass(name);
            return l;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static void setClassLoaderFactory(DatabaseProviderClassLoaderFactory factory) {
        s_clFactory = factory;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static ConnectionCreator getCreator(DatabaseProvider dp) throws SQLException {
        ConnectionCreator retval = DatabaseProvider.getCreatorImpl(dp);
        if (retval == null) {
            throw new SQLException(DBAdapterBundle.format("ERROR_INVALID_SUBTYPE", dp.getProperty(SUBTYPE_CLASS_REFTYPE)));
        }
        return retval;
    }

    private static ConnectionCreator getCreatorImpl(DatabaseProvider dp) {
        String subtype = dp.getProperty(SUBTYPE_CLASS_REFTYPE);
        return s_creators.get(subtype);
    }

    public static synchronized void registerConnectionCreator(String subtype, ConnectionCreator creator) {
        if (s_creators.containsKey(subtype)) {
            DatabaseProvider.getLogger().log(Level.FINE, "DB Adapter warning: Replacing connection creator " + s_creators.remove(subtype).getClass().getName() + " for subtype " + subtype + " with " + (creator == null ? "null" : creator.getClass().getName()));
        }
        if (creator == null) {
            s_creators.remove(subtype);
        } else {
            s_creators.put(subtype, creator);
        }
    }

    private static Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    static {
        s_creators.put("oraJDBC", new OracleConnectionCreator());
        s_creators.put("oraLite", new OracleLiteConnectionCreator());
        s_creators.put("thirdParty", new CustomConnectionCreator());
        s_creators.put("ODBCBridge", new ODBCConnectionCreator());
        s_creators.put("MYSQL", new MySQLConnectionCreator());
        s_creators.put("DB2", new DB2ConnectionCreator());
        s_creators.put("SQLServer", new SQLServerConnectionCreator());
        s_creators.put("SQLite", new SQLiteConnectionCreator());
        s_creators.put("derby", new DerbyConnectionCreator());
    }
}

