/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class SQLServerConnectionCreator
extends AbstractConnectionCreator {
    public static final String SQLSERVER_WEBLOGIC_DRIVER_CLASS = "weblogic.jdbc.sqlserver.SQLServerDriver";
    public static final String SQLSERVER_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String SUBTYPE_SQLSERVER = "SQLServer";
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return SQLSERVER_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String retval;
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            retval = customURL;
        } else {
            String host = this.getPropertyOrThrow(props, "hostname");
            String port = props.getProperty("port");
            String dbase = props.getProperty("dataSourceName");
            String dbInstance = props.getProperty(INSTANCE_CLASS_REFTYPE);
            StringBuilder url = new StringBuilder("jdbc:");
            if (SQLSERVER_WEBLOGIC_DRIVER_CLASS.equals(this.getDriverClassName(props))) {
                url.append("weblogic:");
            }
            url.append("sqlserver://").append(host);
            if (this.hasLength(dbInstance)) {
                url.append("\\").append(dbInstance);
            }
            if (this.hasLength(port)) {
                url.append(":").append(port);
            }
            if (this.hasLength(dbase)) {
                url.append(";databaseName=").append(dbase);
            }
            retval = url.toString();
        }
        return retval;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add("hostname");
        retval.add("port");
        retval.add("dataSourceName");
        retval.add(INSTANCE_CLASS_REFTYPE);
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("hostname");
    }
}

