/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class SQLiteConnectionCreator
extends AbstractConnectionCreator {
    public static final String SQLITE_DRIVER_CLASS = "org.sqlite.JDBC";
    public static final String SUBTYPE_SQLITE = "SQLite";

    @Override
    public Connection getConnection(Properties props) throws SQLException {
        return super.getConnection(props);
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return SQLITE_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String retval;
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            retval = customURL;
        } else {
            String path = props.getProperty("dataSourceName");
            if (path == null) {
                path = props.getProperty("parameters");
            }
            if (!this.hasLength(path)) {
                this.throwMissingPropertyException("dataSourceName");
            }
            retval = "jdbc:sqlite:" + path;
        }
        return retval;
    }

    @Override
    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        if (connProps.containsKey("dataSourceName")) {
            super.setCustomProperties(connProps, jdbcProps);
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.remove("user");
        retval.remove("password");
        retval.add("dataSourceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("dataSourceName");
    }
}

