/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.TokenTypes;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SyntaxScheme
implements Cloneable,
TokenTypes {
    private Style[] styles = new Style[35];
    private static final String VERSION = "*ver1";
    static /* synthetic */ Class class$org$fife$ui$rsyntaxtextarea$Token;

    public SyntaxScheme(boolean bl) {
        if (bl) {
            this.restoreDefaults(null);
        }
    }

    public SyntaxScheme(Font font) {
        this(font, true);
    }

    public SyntaxScheme(Font font, boolean bl) {
        this.restoreDefaults(font, bl);
    }

    void changeBaseFont(Font font, Font font2) {
        for (int i = 0; i < this.styles.length; ++i) {
            Style style = this.styles[i];
            if (style == null || style.font == null || !style.font.getFamily().equals(font.getFamily()) || style.font.getSize() != font.getSize()) continue;
            int n = style.font.getStyle();
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            style.font = styleContext.getFont(font2.getFamily(), n, font2.getSize());
        }
    }

    public Object clone() {
        SyntaxScheme syntaxScheme = null;
        try {
            syntaxScheme = (SyntaxScheme)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        syntaxScheme.styles = new Style[35];
        for (int i = 0; i < 35; ++i) {
            Style style = this.styles[i];
            if (style == null) continue;
            syntaxScheme.styles[i] = (Style)style.clone();
        }
        return syntaxScheme;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntaxScheme)) {
            return false;
        }
        Style[] styleArray = ((SyntaxScheme)object).styles;
        int n = this.styles.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.styles[i] == null ? styleArray[i] != null : !this.styles[i].equals(styleArray[i]))) continue;
            return false;
        }
        return true;
    }

    private static final String getHexString(Color color) {
        return "$" + Integer.toHexString((color.getRGB() & 0xFFFFFF) + 0x1000000).substring(1);
    }

    public Style getStyle(int n) {
        return this.styles[n];
    }

    public int getStyleCount() {
        return this.styles.length;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.styles.length;
        for (int i = 0; i < n2; ++i) {
            if (this.styles[i] == null) continue;
            n ^= this.styles[i].hashCode();
            break;
        }
        return n;
    }

    public static SyntaxScheme load(Font font, InputStream inputStream) throws IOException {
        if (font == null) {
            font = RSyntaxTextArea.getDefaultFont();
        }
        return XmlParser.load(font, inputStream);
    }

    public static SyntaxScheme loadFromString(String string) {
        SyntaxScheme syntaxScheme = new SyntaxScheme(true);
        try {
            if (string != null) {
                String[] stringArray = string.split(",", -1);
                if (stringArray.length == 0 || !VERSION.equals(stringArray[0])) {
                    return syntaxScheme;
                }
                int n = 35;
                int n2 = n * 7 + 1;
                if (stringArray.length != n2) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + n2 + ", found " + stringArray.length);
                }
                for (int i = 0; i < n; ++i) {
                    int n3 = i * 7 + 1;
                    int n4 = Integer.parseInt(stringArray[n3]);
                    if (n4 != i) {
                        throw new Exception("Expected " + i + ", found " + n4);
                    }
                    Color color = null;
                    String string2 = stringArray[n3 + 1];
                    if (!"-".equals(string2)) {
                        color = SyntaxScheme.stringToColor(string2);
                    }
                    Color color2 = null;
                    string2 = stringArray[n3 + 2];
                    if (!"-".equals(string2)) {
                        color2 = SyntaxScheme.stringToColor(string2);
                    }
                    if (!"t".equals(string2 = stringArray[n3 + 3]) && !"f".equals(string2)) {
                        throw new Exception("Expected 't' or 'f', found " + string2);
                    }
                    boolean bl = "t".equals(string2);
                    Font font = null;
                    String string3 = stringArray[n3 + 4];
                    if (!"-".equals(string3)) {
                        font = new Font(string3, Integer.parseInt(stringArray[n3 + 5]), Integer.parseInt(stringArray[n3 + 6]));
                    }
                    syntaxScheme.styles[i] = new Style(color, color2, font, bl);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return syntaxScheme;
    }

    void refreshFontMetrics(Graphics2D graphics2D) {
        for (int i = 0; i < this.styles.length; ++i) {
            Style style = this.styles[i];
            if (style == null) continue;
            style.fontMetrics = style.font == null ? null : graphics2D.getFontMetrics(style.font);
        }
    }

    public void restoreDefaults(Font font) {
        this.restoreDefaults(font, true);
    }

    public void restoreDefaults(Font font, boolean bl) {
        Color color = new Color(0, 128, 0);
        Color color2 = new Color(164, 0, 0);
        Color color3 = Color.BLUE;
        Color color4 = new Color(173, 128, 0);
        Color color5 = new Color(128, 64, 64);
        Color color6 = new Color(0, 128, 164);
        Color color7 = new Color(255, 153, 0);
        Color color8 = new Color(100, 0, 200);
        Color color9 = new Color(220, 0, 156);
        Color color10 = new Color(148, 148, 0);
        if (font == null) {
            font = RSyntaxTextArea.getDefaultFont();
        }
        Font font2 = font;
        Font font3 = font;
        if (bl) {
            Font font4;
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            Font font5 = styleContext.getFont(font.getFamily(), 1, font.getSize());
            font2 = font4 = styleContext.getFont(font.getFamily(), 2, font.getSize());
            font3 = font5;
        }
        this.styles[1] = new Style(color, null, font2);
        this.styles[2] = new Style(color, null, font2);
        this.styles[3] = new Style(color2, null, font2);
        this.styles[4] = new Style(new Color(255, 152, 0), null, font2);
        this.styles[5] = new Style(Color.gray, null, font2);
        this.styles[6] = new Style(color3, null, font3);
        this.styles[7] = new Style(color3, null, font3);
        this.styles[8] = new Style(color4);
        this.styles[9] = new Style(color8);
        this.styles[10] = new Style(color8);
        this.styles[11] = new Style(color8);
        this.styles[12] = new Style(color8);
        this.styles[13] = new Style(color9);
        this.styles[14] = new Style(color9);
        this.styles[15] = new Style(color9);
        this.styles[16] = new Style(new Color(0, 128, 128));
        this.styles[17] = new Style(color7);
        this.styles[18] = new Style(color6);
        this.styles[19] = new Style(Color.gray);
        this.styles[20] = new Style(null);
        this.styles[21] = new Style(Color.gray);
        this.styles[22] = new Style(Color.RED);
        this.styles[23] = new Style(color5);
        this.styles[24] = new Style(Color.gray);
        this.styles[25] = new Style(Color.RED);
        this.styles[26] = new Style(Color.BLUE);
        this.styles[27] = new Style(new Color(63, 127, 127));
        this.styles[28] = new Style(color9);
        this.styles[29] = new Style(color5);
        this.styles[30] = new Style(color7);
        this.styles[31] = new Style(color10);
        this.styles[32] = new Style(color10);
        this.styles[33] = new Style(color10);
        this.styles[34] = new Style(color10);
    }

    public void setStyle(int n, Style style) {
        this.styles[n] = style;
    }

    private static final Color stringToColor(String string) {
        char c = string.charAt(0);
        return new Color(c == '$' || c == '#' ? Integer.parseInt(string.substring(1), 16) : Integer.parseInt(string));
    }

    public String toCommaSeparatedString() {
        StringBuffer stringBuffer = new StringBuffer(VERSION);
        stringBuffer.append(',');
        for (int i = 0; i < 35; ++i) {
            stringBuffer.append(i).append(',');
            Style style = this.styles[i];
            if (style == null) {
                stringBuffer.append("-,-,f,-,,,");
                continue;
            }
            Color color = style.foreground;
            stringBuffer.append(color != null ? SyntaxScheme.getHexString(color) + "," : "-,");
            color = style.background;
            stringBuffer.append(color != null ? SyntaxScheme.getHexString(color) + "," : "-,");
            stringBuffer.append(style.underline ? "t," : "f,");
            Font font = style.font;
            if (font != null) {
                stringBuffer.append(font.getFamily()).append(',').append(font.getStyle()).append(',').append(font.getSize()).append(',');
                continue;
            }
            stringBuffer.append("-,,,");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static class XmlParser
    extends DefaultHandler {
        private Font baseFont;
        private SyntaxScheme scheme;

        public XmlParser(Font font) {
            this.scheme = new SyntaxScheme(font);
        }

        private static XMLReader createReader() throws IOException {
            XMLReader xMLReader = null;
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException sAXException2) {
                    throw new IOException(sAXException2.toString());
                }
            }
            return xMLReader;
        }

        public static SyntaxScheme load(Font font, InputStream inputStream) throws IOException {
            XMLReader xMLReader = XmlParser.createReader();
            XmlParser xmlParser = new XmlParser(font);
            xmlParser.baseFont = font;
            xMLReader.setContentHandler(xmlParser);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding("UTF-8");
            try {
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
            return xmlParser.scheme;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("style".equals(string3)) {
                String string4 = attributes.getValue("token");
                Field field = null;
                try {
                    field = (class$org$fife$ui$rsyntaxtextarea$Token == null ? (class$org$fife$ui$rsyntaxtextarea$Token = SyntaxScheme.class$("org.fife.ui.rsyntaxtextarea.Token")) : class$org$fife$ui$rsyntaxtextarea$Token).getField(string4);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    System.err.println("Invalid token type: " + string4);
                    return;
                }
                if (field.getType() == Integer.TYPE) {
                    String string5;
                    String string6;
                    Object object;
                    int n = 0;
                    try {
                        n = field.getInt(this.scheme);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        return;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        return;
                    }
                    String string7 = attributes.getValue("fg");
                    if (string7 != null) {
                        ((SyntaxScheme)this.scheme).styles[n].foreground = object = SyntaxScheme.stringToColor(string7);
                    }
                    if ((object = attributes.getValue("bg")) != null) {
                        Color color;
                        ((SyntaxScheme)this.scheme).styles[n].background = color = SyntaxScheme.stringToColor((String)object);
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string8 = attributes.getValue("bold");
                    if (string8 != null) {
                        bl2 = Boolean.valueOf(string8);
                        bl = true;
                    }
                    if ((string6 = attributes.getValue("italic")) != null) {
                        bl3 = Boolean.valueOf(string6);
                        bl = true;
                    }
                    if (bl) {
                        int n2 = 0;
                        if (bl2) {
                            n2 |= 1;
                        }
                        if (bl3) {
                            n2 |= 2;
                        }
                        ((SyntaxScheme)this.scheme).styles[n].font = this.baseFont.deriveFont(n2);
                    }
                    if ((string5 = attributes.getValue("underline")) != null) {
                        boolean bl4;
                        ((SyntaxScheme)this.scheme).styles[n].underline = bl4 = Boolean.valueOf(string5).booleanValue();
                    }
                }
            }
        }
    }
}

