/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesAdapter;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;

public class RunConfigurations
extends SharedPropertiesAdapter {
    public static final String DATA_KEY = "oracle.jdeveloper.runner.RunConfigurations";
    public static final String RUN_CONFIGURATION_LIST = "runConfigurationList";
    public static final String RUN_CONFIGURATION_DEFINITIONS = "runConfigurationDefinitions";
    public static final String RUN_CONFIGURATION_NAME = "name";
    public static final String RUN_CONFIGURATION_ACTIVE_NAME = "activeName";
    private static final Logger LOG = Logger.getLogger(RunConfigurations.class.getName());
    private static final SharedPropertiesManager sharedPropertiesManager = SharedPropertiesManager.get();

    public RunConfigurations(HashStructure hash) {
        super(hash);
    }

    public static RunConfigurations getInstance(Project project, boolean useWorkspacePropertyStorage) {
        if (useWorkspacePropertyStorage) {
            Workspace workspace = project.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            if (workspace == null) {
                workspace = Ide.getDefaultWorkspace();
            }
            return RunConfigurations.getInstance((PropertyStorage)workspace);
        }
        return RunConfigurations.getInstance((PropertyStorage)project);
    }

    public static RunConfigurations getInstance(PropertyStorage ps) {
        HashStructure properties = ps.getProperties();
        HashStructure hash = properties.getOrCreateHashStructure(DATA_KEY);
        RunConfigurations instance = new RunConfigurations(hash);
        HashStructure defs = instance.getRunConfigurationDefinitions();
        ListStructure names = instance.getRunConfigurationList();
        if (defs.keySet().isEmpty()) {
            boolean useWorkspacePropertyStorage = ps instanceof Workspace;
            RunConfiguration runConfig = RunConfiguration.createNewInstance(null, null, false, useWorkspacePropertyStorage);
            defs.putPlaceholderHashStructure(runConfig.getName(), runConfig.getProperties());
            names.addPlaceholder((Object)runConfig.getName());
        } else if (names.isEmpty()) {
            for (String key : defs.keySet()) {
                names.addPlaceholder((Object)key);
            }
        }
        return instance;
    }

    @Deprecated
    public static RunConfigurations getInstance(Project project, Workspace workspace, boolean useWorkspacePropertyStorage) {
        PropertyStorage ps = RunConfigurations.getActivePropertyStorage((Project)project, (Workspace)workspace, (String)DATA_KEY);
        HashStructure properties = ps.getProperties();
        HashStructure hash = properties.getOrCreateHashStructure(DATA_KEY);
        RunConfigurations instance = new RunConfigurations(hash);
        HashStructure defs = instance.getRunConfigurationDefinitions();
        ListStructure names = instance.getRunConfigurationList();
        if (defs.keySet().isEmpty()) {
            RunConfiguration runConfig = RunConfiguration.createNewInstance(null, null, false, useWorkspacePropertyStorage);
            defs.putPlaceholderHashStructure(runConfig.getName(), runConfig.getProperties());
            names.addPlaceholder((Object)runConfig.getName());
        } else if (names.isEmpty()) {
            for (String key : defs.keySet()) {
                names.addPlaceholder((Object)key);
            }
        }
        return instance;
    }

    @Deprecated
    public static void addRunConfiguration(Project project, RunConfiguration runConfiguration) {
        Workspace workspace;
        Workspace workspace2 = workspace = project == null ? null : project.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getActiveWorkspace();
        }
        RunConfigurations.addRunConfiguration(project, workspace, runConfiguration);
    }

    public static void addRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration) {
        boolean custom;
        String name = runConfiguration.getName();
        HashStructure runConfigurationHashStructure = runConfiguration.getProperties();
        HashStructure activeProperties = sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY) ? workspace.getSharedPropertiesOnly() : ((custom = runConfiguration.isCustom()) ? project.getUserPropertiesOnly() : project.getSharedPropertiesOnly());
        HashStructure runConfigurationsProperties = activeProperties.getOrCreateHashStructure(DATA_KEY);
        HashStructure runConfigurationDefinitions = runConfigurationsProperties.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
        runConfigurationDefinitions.putHashStructure(name, runConfigurationHashStructure);
        ListStructure runConfigurationList = runConfigurationsProperties.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
        runConfigurationList.add((Object)name);
    }

    private HashStructure getRunConfigurationDefinitions() {
        return this.getHashStructure().getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
    }

    private ListStructure getRunConfigurationList() {
        return this.getHashStructure().getOrCreateListStructure(RUN_CONFIGURATION_LIST);
    }

    public static String getActiveName(Project project, Workspace workspace) {
        if (sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY)) {
            return RunConfigurations.getActiveName(project, workspace, true);
        }
        return RunConfigurations.getActiveName(project, workspace, false);
    }

    public static String getActiveName(Project project, Workspace workspace, boolean useWorkspacePropertyStorage) {
        Workspace propertyStorage = null;
        if (useWorkspacePropertyStorage) {
            propertyStorage = workspace;
            if (workspace == null || workspace.getUserPropertiesOnly() == null || workspace.getUserPropertiesOnly().getOrCreateHashStructure(DATA_KEY) == null) {
                return RunMgrArb.getString(2);
            }
        } else {
            propertyStorage = project;
            if (project == null || project.getUserPropertiesOnly() == null || project.getUserPropertiesOnly().getOrCreateHashStructure(DATA_KEY) == null) {
                return RunMgrArb.getString(0);
            }
        }
        HashStructure customProjectProperties = ((HashStructureNode)propertyStorage).getUserPropertiesOnly();
        HashStructure customRunConfigurations = customProjectProperties.getOrCreateHashStructure(DATA_KEY);
        String activeName = customRunConfigurations.getString(RUN_CONFIGURATION_ACTIVE_NAME);
        RunConfigurations runConfigurations = RunConfigurations.getInstance((PropertyStorage)propertyStorage);
        ListStructure runConfigurationList = runConfigurations.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            String string = activeName = useWorkspacePropertyStorage ? RunMgrArb.getString(2) : RunMgrArb.getString(1);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            activeName = RunMgrArb.getString(0);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            int size = runConfigurationList.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)runConfigurationList.get(i);
                if (!runConfigurationDefinitions.containsKey(name)) continue;
                activeName = name;
                customRunConfigurations.putString(RUN_CONFIGURATION_ACTIVE_NAME, activeName);
                break;
            }
        }
        return activeName;
    }

    private static void setActiveName(Project project, Workspace workspace, String activeName) {
        HashStructure customProjectProperties = sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY) ? workspace.getUserPropertiesOnly() : project.getUserPropertiesOnly();
        HashStructure customRunConfigurations = customProjectProperties.getOrCreateHashStructure(DATA_KEY);
        customRunConfigurations.putString(RUN_CONFIGURATION_ACTIVE_NAME, activeName);
    }

    public Map getDefinedRunConfigurations() {
        HashMap<String, RunConfiguration> map = new HashMap<String, RunConfiguration>();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (String name : runConfigurationDefinitions.keySet()) {
            try {
                HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                map.put(name, runConfiguration);
            }
            catch (ClassCastException cce) {
                LOG.warning("Unable to load RunConfiguration " + name + " because " + cce.getMessage());
            }
        }
        return map;
    }

    public RunConfiguration[] getVisibleRunConfigurations() {
        ArrayList<RunConfiguration> list = new ArrayList<RunConfiguration>();
        ListStructure runConfigurationList = this.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (int i = runConfigurationList.size() - 1; i >= 0; --i) {
            String name = (String)runConfigurationList.get(i);
            HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            if (runConfigurationHashStructure != null) {
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                list.add(0, runConfiguration);
                continue;
            }
            runConfigurationList.remove(i);
        }
        return list.toArray(new RunConfiguration[list.size()]);
    }

    public void setRunConfigurations(RunConfiguration[] runConfigs, boolean editingCustomProperties) {
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        ArrayList<String> tempList = new ArrayList<String>();
        int size = runConfigs.length;
        for (int i = 0; i < size; ++i) {
            String name = runConfigs[i].getName();
            tempList.add(name);
            if (runConfigurationDefinitions.containsKey(name)) continue;
            runConfigurationDefinitions.putHashStructure(name, runConfigs[i].getProperties());
        }
        Collections.sort(tempList);
        ListStructure runConfigurationList = this.getRunConfigurationList();
        runConfigurationList.mirror(tempList);
        String[] names = runConfigurationDefinitions.keySet().toArray(new String[runConfigurationDefinitions.size()]);
        for (int i = names.length - 1; i >= 0; --i) {
            String name = names[i];
            HashStructure runConfigurationHashStructure = null;
            try {
                runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            }
            catch (ClassCastException cce) {
                continue;
            }
            RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
            if (runConfiguration.isCustom() != editingCustomProperties || tempList.contains(name)) continue;
            runConfigurationDefinitions.remove(name);
        }
    }

    public static boolean isActiveRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration, boolean useWorkspacePropertyStorage) {
        return RunConfigurations.getActiveName(project, workspace, useWorkspacePropertyStorage).equals(runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        Workspace workspace;
        Workspace workspace2 = workspace = project == null ? null : project.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getActiveWorkspace();
        }
        RunConfigurations.setActiveName(project, workspace, runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration) {
        RunConfigurations.setActiveName(project, workspace, runConfiguration.getName());
    }

    private static RunConfiguration getRunConfigurationByName(Project project, String name, boolean createTemp) {
        boolean isUsingSharedProperties = sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY);
        RunConfigurations runConfigurations = RunConfigurations.getInstance(project, isUsingSharedProperties);
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
        if (runConfigurationHashStructure == null) {
            if (createTemp) {
                runConfigurationHashStructure = HashStructure.newInstance();
            } else {
                return null;
            }
        }
        RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
        return runConfiguration;
    }

    public static RunConfiguration getRunConfigurationByName(Project project, String name) {
        boolean createTemp = false;
        return RunConfigurations.getRunConfigurationByName(project, name, createTemp);
    }

    @Deprecated
    public static RunConfiguration getActiveRunConfiguration(Project project) {
        Workspace workspace;
        Workspace workspace2 = workspace = project == null ? null : project.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getActiveWorkspace();
        }
        return RunConfigurations.getActiveRunConfiguration(project, workspace);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project, Workspace workspace) {
        if (sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY)) {
            return RunConfigurations.getActiveRunConfiguration(project, workspace, true);
        }
        return RunConfigurations.getActiveRunConfiguration(project, workspace, false);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project, Workspace workspace, boolean useWorkspacePropertyStorage) {
        String name = RunConfigurations.getActiveName(project, workspace, useWorkspacePropertyStorage);
        return RunConfigurations.getRunConfigurationByName(project, name, true);
    }
}

