/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightContext;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.InsightSupport;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.DefaultCompletionSupport;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.insight.JavaCellRenderer;

public class ClassProvider
implements CompletionProvider {
    private ClassNameCompletionModel model;
    private Set<Character> triggers;

    public CompletionModel getModel(CompletionContext completionContext) {
        this.model = new ClassNameCompletionModel();
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public CompletionModel updateModel(CompletionContext completionContext, CompletionModel d) {
        this.model = (ClassNameCompletionModel)d;
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public Collection getTriggerCharacters() {
        if (this.triggers == null) {
            this.triggers = new HashSet<Character>();
            this.triggers.add(Character.valueOf('.'));
            for (int i = 0; i < 65535; ++i) {
                if (!Character.isJavaIdentifierPart((char)i)) continue;
                this.triggers.add(Character.valueOf((char)i));
            }
        }
        return this.triggers;
    }

    public boolean isExactMatch(CompletionModel d) {
        return ((ClassNameCompletionModel)d).isExactMatch();
    }

    public void customizeView(InsightViewCustomizer customizer) {
        JavaCellRenderer renderer = new JavaCellRenderer(customizer);
        customizer.setRenderer((ListCellRenderer)((Object)renderer));
    }

    public String getDisplayName() {
        return "";
    }

    public InsightModel getModel(InsightContext insightContext) {
        return null;
    }

    public InsightModel updateModel(InsightContext insightContext, InsightModel lastModel) {
        return null;
    }

    static class ClassInsightItem
    extends InsightItem {
        private String name;

        public ClassInsightItem(String className) {
            this.name = className;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"class.png");
        }

        public String getDisplayValue() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class PackageInsightItem
    extends InsightItem {
        private String name;

        public PackageInsightItem(String packageName) {
            this.name = packageName;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"package.png");
        }

        public String getDisplayValue() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class ClassNameCompletionModel
    implements CompletionModel {
        protected CompletionContext completionContext;
        protected Context ideContext;
        protected Project project;
        protected String userInput;
        protected JTextComponent textComponent;
        protected boolean exactMatch = false;
        protected InsightOptions options;

        ClassNameCompletionModel() {
        }

        protected void updateFromCompletionContext(CompletionContext context) {
            this.completionContext = context;
            if (context.getSupport() instanceof DefaultCompletionSupport) {
                InsightSupport insightSupport = this.completionContext.getSupport();
                this.textComponent = insightSupport.getTextComponent();
                this.userInput = this.textComponent.getText();
                this.ideContext = insightSupport.getContext();
                assert (this.ideContext != null);
                this.project = this.ideContext.getProject();
                this.options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            }
        }

        public void partialComplete() {
        }

        public String getMatchingText() {
            return this.userInput;
        }

        public List<InsightItem> getItems() {
            if (this.userInput != null) {
                return this.getMatchingItems();
            }
            String packagePrefix = "";
            String partialPackageOrClassName = "";
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            results.addAll(this.getPackageNames(packagePrefix, partialPackageOrClassName));
            results.addAll(this.getClassNames(packagePrefix, partialPackageOrClassName));
            return results;
        }

        private List<InsightItem> getPackageNames(String packagePrefix, String partial) {
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClassLocator locator = javaManager.getJavaClassLocator();
            Collection packageNames = locator.getPackages(packagePrefix);
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            partial = partial.toLowerCase();
            boolean filterByContains = this.options.isFilterByContains();
            for (String s : packageNames) {
                if ((!filterByContains || !s.contains(partial)) && (filterByContains || !s.startsWith(partial))) continue;
                if (s.equals(partial)) {
                    this.exactMatch = true;
                }
                results.add(new PackageInsightItem(s));
            }
            return results;
        }

        private List<InsightItem> getClassNames(String packagePrefix, String partial) {
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClassLocator locator = javaManager.getJavaClassLocator();
            Collection classNames = locator.getClassesInPackage(packagePrefix);
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            partial = partial.toLowerCase();
            boolean filterByContains = this.options.isFilterByContains();
            for (String s : classNames) {
                String slc = s.toLowerCase();
                if ((!filterByContains || !slc.contains(partial)) && (filterByContains || !slc.startsWith(partial))) continue;
                if (slc.equals(partial)) {
                    this.exactMatch = true;
                }
                results.add(new ClassInsightItem(s));
            }
            return results;
        }

        public List<InsightItem> getMatchingItems() {
            String packagePrefix = "";
            String partialPackageOrClassName = null;
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            if (this.userInput != null) {
                int lastDot = this.userInput.lastIndexOf(46);
                if (lastDot != -1) {
                    packagePrefix = this.userInput.substring(0, lastDot);
                    partialPackageOrClassName = this.userInput.substring(lastDot + 1);
                } else {
                    partialPackageOrClassName = this.userInput;
                }
                if (partialPackageOrClassName != null && partialPackageOrClassName.length() > 0 && Character.isLowerCase(partialPackageOrClassName.charAt(0))) {
                    results.addAll(this.getPackageNames(packagePrefix, partialPackageOrClassName));
                    results.addAll(this.getClassNames(packagePrefix, partialPackageOrClassName));
                } else {
                    results.addAll(this.getClassNames(packagePrefix, partialPackageOrClassName));
                    results.addAll(this.getPackageNames(packagePrefix, partialPackageOrClassName));
                }
            }
            return results;
        }

        public InsightItem getDefaultItem() {
            return null;
        }

        public InsightModel.Result complete(InsightItem selectedItem) {
            int lastDot;
            String userInput = this.textComponent.getText();
            String textToPreserve = "";
            if (userInput != null && (lastDot = userInput.lastIndexOf(46)) > 0 && lastDot < userInput.length()) {
                textToPreserve = userInput.substring(0, lastDot + 1);
            }
            if (selectedItem.getName().startsWith(textToPreserve)) {
                textToPreserve = "";
            }
            if (selectedItem instanceof PackageInsightItem) {
                this.textComponent.setText(textToPreserve + selectedItem.getName() + ".");
                return InsightModel.Result.RETRIGGER;
            }
            this.textComponent.setText(textToPreserve + selectedItem.getName());
            return InsightModel.Result.DONE;
        }

        public boolean isExactMatch() {
            return this.exactMatch;
        }
    }
}

