/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.insight.ClassProvider;

public class ExceptionProvider
extends ClassProvider {
    private ExceptionCompletionModel model;

    @Override
    public CompletionModel getModel(CompletionContext completionContext) {
        this.model = new ExceptionCompletionModel();
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    @Override
    public CompletionModel updateModel(CompletionContext completionContext, CompletionModel d) {
        this.model = (ExceptionCompletionModel)d;
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    static class ExceptionCompletionModel
    extends ClassProvider.ClassNameCompletionModel {
        ExceptionCompletionModel() {
        }

        @Override
        public List<InsightItem> getItems() {
            if (this.userInput != null) {
                return this.getMatchingItems();
            }
            ArrayList<InsightItem> filtered = new ArrayList<InsightItem>();
            List<InsightItem> unfiltered = super.getItems();
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClass throwableClass = javaManager.getClass("java.lang.Throwable");
            for (InsightItem candidate : unfiltered) {
                if (candidate instanceof ClassProvider.PackageInsightItem) {
                    filtered.add(candidate);
                    continue;
                }
                JavaClass currentClass = javaManager.getClass(candidate.getName());
                if (currentClass == null || !throwableClass.isAssignableFrom((JavaType)currentClass)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }

        @Override
        public List<InsightItem> getMatchingItems() {
            String partial = null;
            String packageName = "";
            if (this.userInput != null) {
                int lastDot = this.userInput.lastIndexOf(46);
                if (lastDot != -1) {
                    packageName = this.userInput.substring(0, lastDot + 1);
                    partial = this.userInput.substring(lastDot + 1).toLowerCase();
                } else {
                    partial = this.userInput.toLowerCase();
                }
            }
            ArrayList<InsightItem> filtered = new ArrayList<InsightItem>();
            List<InsightItem> unfiltered = super.getMatchingItems();
            boolean filterByContains = this.options.isFilterByContains();
            ArrayList<InsightItem> wellKnown = new ArrayList<InsightItem>();
            this.addWellKnownExceptions(wellKnown);
            for (InsightItem wk : wellKnown) {
                String lcname = wk.getName().toLowerCase();
                String lcPackageOnly = wk.getName().toLowerCase().substring(0, wk.getName().lastIndexOf(46) + 1);
                if (packageName.length() > 0 && lcPackageOnly.equals(packageName.toLowerCase()) || packageName.length() > 0 && !lcPackageOnly.startsWith(packageName.toLowerCase())) continue;
                String lcClassOnly = wk.getName().toLowerCase().substring(wk.getName().lastIndexOf(46) + 1);
                if (!(filterByContains && lcname.contains(partial) || !filterByContains && lcname.startsWith(partial)) && (filterByContains || !lcClassOnly.startsWith(partial))) continue;
                filtered.add(wk);
            }
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClass throwableClass = javaManager.getClass("java.lang.Throwable");
            for (InsightItem candidate : unfiltered) {
                String cname = candidate.getName();
                String cnamelc = cname.toLowerCase();
                if ((!filterByContains || !cnamelc.contains(partial)) && (filterByContains || !cnamelc.startsWith(partial))) continue;
                if (candidate instanceof ClassProvider.PackageInsightItem) {
                    filtered.add(candidate);
                    continue;
                }
                JavaClass currentClass = javaManager.getClass(packageName + cname);
                if (currentClass == null || !throwableClass.isAssignableFrom((JavaType)currentClass)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }

        private void addWellKnownExceptions(List<InsightItem> list) {
            String[] itemsToAdd;
            for (String toAdd : itemsToAdd = new String[]{"java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.ArrayStoreException", "java.lang.ClassCastException", "java.lang.Exception", "java.lang.IllegalAccessException", "java.lang.IllegalArgumentException", "java.lang.IllegalStateException", "java.lang.IndexOutOfBoundsException", "java.lang.NumberFormatException", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StringIndexOutOfBoundsException", "java.lang.UnsupportedOperationException", "java.lang.Error", "java.lang.Throwable", "oracle.jbo.JboException", "$Oracle.EXCEPTION_ORA_6502"}) {
                list.add(new ClassProvider.ClassInsightItem(toAdd));
            }
        }
    }
}

