/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightContext;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.DefaultCompletionSupport;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.insight.JavaCellRenderer;

public class FileProvider
implements CompletionProvider {
    private JavaFileCompletionModel model;
    private Set<Character> triggers;
    public static final String USERDATA_PACKAGENAME_COMPONENT = "packagename_component";

    public CompletionModel getModel(CompletionContext completionContext) {
        this.model = new JavaFileCompletionModel();
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public CompletionModel updateModel(CompletionContext completionContext, CompletionModel d) {
        this.model = (JavaFileCompletionModel)d;
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    public Collection getTriggerCharacters() {
        if (this.triggers == null) {
            this.triggers = new HashSet<Character>();
            this.triggers.add(Character.valueOf('.'));
            for (int i = 0; i < 65535; ++i) {
                if (!Character.isJavaIdentifierPart((char)i)) continue;
                this.triggers.add(Character.valueOf((char)i));
            }
        }
        return this.triggers;
    }

    public boolean isExactMatch(CompletionModel d) {
        return ((JavaFileCompletionModel)d).isExactMatch();
    }

    public void customizeView(InsightViewCustomizer customizer) {
        customizer.setRenderer((ListCellRenderer)((Object)new JavaCellRenderer(customizer)));
    }

    public String getDisplayName() {
        return "";
    }

    public InsightModel getModel(InsightContext insightContext) {
        return null;
    }

    public InsightModel updateModel(InsightContext insightContext, InsightModel lastModel) {
        return null;
    }

    static class FileInsightItem
    extends InsightItem {
        private String name;

        public FileInsightItem(String filename) {
            this.name = filename;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"file.png");
        }

        public String getDisplayValue() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class JavaFileCompletionModel
    implements CompletionModel {
        protected CompletionContext completionContext;
        protected Context ideContext;
        protected Project project;
        protected String userInput;
        protected JTextComponent textComponent;
        protected boolean exactMatch = false;
        protected InsightOptions options;
        protected JTextComponent packageTextComponent;
        protected String packageName;

        JavaFileCompletionModel() {
        }

        protected void updateFromCompletionContext(CompletionContext context) {
            this.completionContext = context;
            if (context.getSupport() instanceof DefaultCompletionSupport) {
                DefaultCompletionSupport tcic = (DefaultCompletionSupport)this.completionContext.getSupport();
                this.textComponent = tcic.getTextComponent();
                this.userInput = this.textComponent.getText();
                this.ideContext = tcic.getContext();
                assert (this.ideContext != null);
                this.project = this.ideContext.getProject();
                this.options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                this.packageTextComponent = (JTextComponent)tcic.getObject(FileProvider.USERDATA_PACKAGENAME_COMPONENT);
                this.packageName = this.packageTextComponent.getText();
                this.packageTextComponent.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent evt) {
                        JavaFileCompletionModel.this.packageName = JavaFileCompletionModel.this.packageTextComponent.getText();
                    }
                });
            }
        }

        public void partialComplete() {
            System.out.println("FP$JFCM.partialComplete() returning null");
        }

        public String getMatchingText() {
            return this.userInput;
        }

        public List<InsightItem> getItems() {
            if (this.userInput != null) {
                return this.getMatchingItems();
            }
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClassLocator locator = javaManager.getJavaClassLocator();
            if (this.packageName.endsWith(".")) {
                this.packageName = this.packageName.substring(0, this.packageName.length());
            }
            Collection classNames = locator.getClassesInPackage(this.packageName);
            for (String className : classNames) {
                results.add(new FileInsightItem(className + ".java"));
            }
            return results;
        }

        public List<InsightItem> getMatchingItems() {
            String partialFileName = this.userInput.toLowerCase();
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            JavaManager javaManager = JavaManager.getAnyInstance((Project)this.project);
            JavaClassLocator locator = javaManager.getJavaClassLocator();
            if (this.packageName.endsWith(".")) {
                this.packageName = this.packageName.substring(0, this.packageName.length());
            }
            Collection classNames = locator.getClassesInPackage(this.packageName);
            boolean filterByContains = this.options.isFilterByContains();
            for (String className : classNames) {
                String classNameLc = className.toLowerCase();
                if ((!filterByContains || !classNameLc.contains(partialFileName)) && (filterByContains || !classNameLc.startsWith(partialFileName))) continue;
                if (classNameLc.equals(partialFileName)) {
                    this.exactMatch = true;
                }
                results.add(new FileInsightItem(className + ".java"));
            }
            return results;
        }

        public InsightItem getDefaultItem() {
            return null;
        }

        public InsightModel.Result complete(InsightItem selectedItem) {
            this.textComponent.setText(selectedItem.getName());
            return InsightModel.Result.DONE;
        }

        public boolean isExactMatch() {
            return this.exactMatch;
        }
    }
}

