/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.filter.CamelCaseInsightSorter;
import oracle.ide.model.Project;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.insight.ClassProvider;

public class MethodProvider
extends ClassProvider {
    private MethodCompletionModel model;

    @Override
    public CompletionModel getModel(CompletionContext completionContext) {
        this.model = new MethodCompletionModel();
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    @Override
    public CompletionModel updateModel(CompletionContext completionContext, CompletionModel d) {
        this.model = (MethodCompletionModel)d;
        this.model.updateFromCompletionContext(completionContext);
        return this.model;
    }

    static class MethodInsightItem
    extends InsightItem {
        private String name;

        public MethodInsightItem(JavaMethod method) {
            this.name = method.getName();
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"method.png");
        }

        public String getDisplayValue() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class MethodCompletionModel
    extends ClassProvider.ClassNameCompletionModel {
        MethodCompletionModel() {
        }

        @Override
        public InsightModel.Result complete(InsightItem selectedItem) {
            int lastDot;
            String userInput = this.textComponent.getText();
            String textToPreserve = "";
            if (userInput != null && (lastDot = userInput.lastIndexOf(46)) > 0 && lastDot < userInput.length()) {
                textToPreserve = userInput.substring(0, lastDot + 1);
            }
            if (selectedItem instanceof ClassProvider.PackageInsightItem || selectedItem instanceof ClassProvider.ClassInsightItem) {
                this.textComponent.setText(textToPreserve + selectedItem.getName() + ".");
                return InsightModel.Result.RETRIGGER;
            }
            this.textComponent.setText(textToPreserve + selectedItem.getName());
            return InsightModel.Result.RETRIGGER;
        }

        @Override
        public List<InsightItem> getItems() {
            if (this.userInput != null) {
                return this.getMatchingItems();
            }
            return super.getItems();
        }

        @Override
        public List<InsightItem> getMatchingItems() {
            JavaManager javaManager;
            JavaClass currentClass;
            String partial = null;
            String completedTokens = "";
            if (this.userInput != null) {
                int lastDot = this.userInput.lastIndexOf(46);
                if (lastDot != -1) {
                    completedTokens = this.userInput.substring(0, lastDot);
                    partial = this.userInput.substring(lastDot + 1).toLowerCase();
                } else {
                    partial = this.userInput.toLowerCase();
                }
            }
            if ((currentClass = (javaManager = JavaManager.getAnyInstance((Project)this.project)).getClass(completedTokens)) == null) {
                return super.getMatchingItems();
            }
            ArrayList<InsightItem> results = new ArrayList<InsightItem>();
            HashSet<String> matches = new HashSet<String>();
            Collection methods = currentClass.getMethods();
            boolean filterByContains = this.options.isFilterByContains();
            for (JavaMethod method : methods) {
                partial = partial.toLowerCase();
                String methodnamelc = method.getName().toLowerCase();
                if ((!filterByContains || !methodnamelc.contains(partial)) && (filterByContains || !methodnamelc.startsWith(partial))) continue;
                if (methodnamelc.equals(partial)) {
                    this.exactMatch = true;
                }
                if (!matches.add(method.getName())) continue;
                results.add(new MethodInsightItem(method));
            }
            CamelCaseInsightSorter sorter = new CamelCaseInsightSorter();
            sorter.sort(results, partial);
            return results;
        }
    }
}

