/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;

class DebugJDIBreakpointFileLine
extends DebugJDIBreakpoint
implements DebugBreakpointFileLine {
    protected String filename;
    protected int line;

    DebugJDIBreakpointFileLine(DebugJDI dj, String filename, int line) {
        super(dj);
        this.filename = filename;
        this.line = line;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setFileLine(String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.filename = filename;
            this.line = line;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        return "";
    }

    @Override
    boolean needsVerification() {
        if (this.filename.endsWith(".txt") || this.filename.endsWith(".text") || this.filename.indexOf(46) == -1) {
            return false;
        }
        return !this.filename.endsWith(".js");
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        try {
            int size;
            String defaultStratum = rt.defaultStratum();
            ArrayList<Location> locationsOfLine = null;
            try {
                locationsOfLine = DebugJDI.getLocationsOfLine(rt, defaultStratum, this.filename, this.line);
            }
            catch (ClassNotPreparedException cnpe) {
                return false;
            }
            catch (AbsentInformationException aie) {
                // empty catch block
            }
            if (locationsOfLine == null) {
                List<Location> l = rt.allLineLocations(defaultStratum, this.filename);
                ArrayList<Location> v = new ArrayList<Location>();
                int size2 = l.size();
                for (int i = 0; i < size2; ++i) {
                    Location location = l.get(i);
                    if (DebugJDI.getLineNumber(location, defaultStratum) != this.line) continue;
                    v.add(location);
                }
                locationsOfLine = v;
            }
            if ((size = locationsOfLine.size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    Location location = (Location)locationsOfLine.get(i);
                    this.locationIdentified(location);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

