/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.connect.Connector;
import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugConnectArg2;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DebugJDIConnectArg
implements DebugConnectArg2 {
    private int factory;
    Map<String, Connector.Argument> defArgs;
    private Connector.Argument arg;
    private String name;
    private String value;
    private Map<String, Object> userData = new HashMap<String, Object>();
    private static Map defaultConnectArgValues = null;

    DebugJDIConnectArg(int factory, Map<String, Connector.Argument> defArgs, Connector.Argument arg) {
        this.factory = factory;
        this.defArgs = defArgs;
        this.arg = arg;
        this.name = arg.name();
        String defaultValue = DebugJDIConnectArg.getDefaultConnectArgValue(factory, this.name);
        if (defaultValue != null) {
            this.setValue(defaultValue);
        }
    }

    DebugJDIConnectArg(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.arg == null ? this.name : this.arg.label();
    }

    @Override
    public void setValue(String value) {
        if (this.arg == null) {
            this.value = value;
            return;
        }
        if (this.name.equals("timeout")) {
            try {
                int seconds = Integer.parseInt(value);
                int millis = seconds * 1000;
                value = Integer.toString(millis);
            }
            catch (Exception exception) {}
        } else if (this.name.equals("hostname") && (value == null || value.length() == 0)) {
            value = DbgArb.getString(188);
        }
        this.arg.setValue(value);
    }

    @Override
    public String getValue() {
        String value;
        String string = value = this.arg == null ? this.value : this.arg.value();
        if (this.name.equals("timeout")) {
            try {
                int millis = Integer.parseInt(value);
                int seconds = millis / 1000;
                value = Integer.toString(seconds);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public boolean allowBlank() {
        return this.arg == null ? true : !this.arg.mustSpecify();
    }

    private static synchronized String getDefaultConnectArgValue(int factory, String name) {
        if (defaultConnectArgValues == null) {
            defaultConnectArgValues = new HashMap();
            defaultConnectArgValues.put("hostname", "");
            defaultConnectArgValues.put("port", "4000");
            defaultConnectArgValues.put("timeout", "2");
        }
        if (factory == DebugFactory.FACTORY_JPDA_Listen && name.equals("timeout")) {
            return "0";
        }
        return (String)defaultConnectArgValues.get(name);
    }

    @Override
    public void setAdditionalInfo(String key, Object value) {
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getAdditionalInfo(String key) {
        return this.userData.get(key);
    }
}

