/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebuggerEngine;

public abstract class DebugJDIConnector
implements DebugConnector {
    protected int factory;
    protected Connector connector;
    protected DebuggerEngine coreDebuggerEngine;

    public static String getVersion() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        int major = vmm.majorInterfaceVersion();
        int minor = vmm.minorInterfaceVersion();
        return Integer.toString(major) + "." + Integer.toString(minor);
    }

    protected DebugJDIConnector(int factory) {
        this.factory = factory;
        this.connector = this.findConnector();
    }

    protected Project getProject() {
        return this.coreDebuggerEngine.getProject();
    }

    protected Workspace getWorkspace() {
        return this.coreDebuggerEngine.getWorkspace();
    }

    protected abstract Connector findConnector();

    @Override
    public synchronized DebugConnectArg[] getConnectArgs() {
        Map<String, Connector.Argument> defArgs = this.connector.defaultArguments();
        DebugConnectArg[] args = new DebugConnectArg[defArgs.size()];
        int count = 0;
        for (Connector.Argument arg : defArgs.values()) {
            args[count++] = new DebugJDIConnectArg(this.factory, defArgs, arg);
        }
        Arrays.sort(args, new Comparator(){

            public int compare(Object o1, Object o2) {
                int sort1 = this.getSortValue((DebugConnectArg)o1);
                int sort2 = this.getSortValue((DebugConnectArg)o2);
                return sort1 - sort2;
            }

            private int getSortValue(DebugConnectArg arg) {
                String name = arg.getName();
                if (name.equals("hostname")) {
                    return 0;
                }
                if (name.equals("port")) {
                    return 1;
                }
                if (name.equals("timeout")) {
                    return 2;
                }
                return 3;
            }
        });
        return args;
    }
}

