/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import java.util.Map;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnectArg;
import oracle.jdevimpl.debugger.jdi.DebugJDIConnector;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerEngine;

public final class DebugJDIConnectorListen
extends DebugJDIConnector
implements Runnable {
    private Object listeningSync = new Integer(1);
    private boolean listening;
    protected Map<String, Connector.Argument> defArgs;
    private DebugConnectionListener connectionListener;
    private Thread listeningThread;

    public DebugJDIConnectorListen() {
        super(DebugFactory.FACTORY_JPDA_Listen);
    }

    @Override
    protected Connector findConnector() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        for (ListeningConnector connector : vmm.listeningConnectors()) {
            if (!connector.transport().name().equals("dt_socket")) continue;
            return connector;
        }
        throw new IllegalArgumentException("Can not find listening connector for transport dt_socket");
    }

    @Override
    public synchronized DebugVirtualMachine connect(DebugConnectArg[] connectArgs, DebuggerEngine engine) throws Exception {
        this.coreDebuggerEngine = engine;
        Map<String, Connector.Argument> defArgs = ((DebugJDIConnectArg)connectArgs[0]).defArgs;
        ListeningConnector lc = (ListeningConnector)this.connector;
        lc.startListening(defArgs);
        VirtualMachine vm = lc.accept(defArgs);
        lc.stopListening(defArgs);
        return new DebugJDI(vm, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startListening(DebugConnectArg[] connectArgs, DebugConnectionListener connectionListener) throws Exception {
        Object object = this.listeningSync;
        synchronized (object) {
            if (!this.listening) {
                this.defArgs = ((DebugJDIConnectArg)connectArgs[0]).defArgs;
                this.connectionListener = connectionListener;
                ListeningConnector lc = (ListeningConnector)this.connector;
                lc.startListening(this.defArgs);
                this.listening = true;
                connectionListener.listeningStarted();
                this.listeningThread = new Thread((Runnable)this, "JPDA Listener");
                this.listeningThread.start();
                this.listeningSync.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopListening() throws Exception {
        Object object = this.listeningSync;
        synchronized (object) {
            if (this.listening) {
                ListeningConnector lc = (ListeningConnector)this.connector;
                lc.stopListening(this.defArgs);
                this.listening = false;
                this.connectionListener.listeningStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isListening() {
        Object object = this.listeningSync;
        synchronized (object) {
            return this.listening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            ListeningConnector lc = (ListeningConnector)this.connector;
            try {
                while (this.isListening()) {
                    Object object = this.listeningSync;
                    synchronized (object) {
                        this.listeningSync.notify();
                    }
                    VirtualMachine vm = lc.accept(this.defArgs);
                    DebugJDI dj = new DebugJDI(vm, this.coreDebuggerEngine);
                    boolean keepListening = this.connectionListener.connectionEstablished(dj);
                    if (keepListening && lc.supportsMultipleConnections()) continue;
                    break;
                }
            }
            catch (Exception e) {
                if (!this.isListening()) break block8;
                e.printStackTrace();
            }
        }
        try {
            this.stopListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listeningThread = null;
    }
}

