/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

class DebugJDIDataCompositeInfo
extends DebugJDIDataInfo
implements DebugDataCompositeInfo {
    DebugJDIDataCompositeInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    @Override
    public boolean isNull() {
        this.throwIfExpired();
        return this.value == null;
    }

    @Override
    public long getAddressOfObject() {
        this.throwIfExpired();
        return this.getUniqueID();
    }

    @Override
    public boolean canSetAddressOfObject() {
        return false;
    }

    @Override
    public boolean canSetAddressOfObjectToNull() {
        return this.owner != null && !this.isFinal();
    }

    @Override
    public boolean setAddressOfObject(long address) {
        this.throwIfExpired();
        if (address == 0L) {
            return this.modifyData(null);
        }
        return false;
    }

    @Override
    public DebugPinnedInfo pinObject(DebugPinListener pinListener) {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return this.dj.pinObject((ObjectReference)this.value, pinListener);
        }
        return null;
    }

    @Override
    public long getUniqueID() {
        this.throwIfExpired();
        if (this.value instanceof ObjectReference) {
            return ((ObjectReference)this.value).uniqueID();
        }
        return 0L;
    }

    @Override
    public String getCourtesyValue() {
        this.throwIfExpired();
        String s = DebugJDIDataCompositeInfo.getCourtesyValueForValue(this.value);
        return s;
    }

    @Override
    public boolean canGetWholeThing() {
        ClassType ct;
        String name;
        ObjectReference or;
        ReferenceType rt;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return true;
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference ar = (ArrayReference)this.value;
            ReferenceType rt2 = ar.referenceType();
            String name2 = rt2.name();
            if (name2.equals("char[]")) {
                return true;
            }
            if (name2.equals("byte[]")) {
                return true;
            }
            if (name2.equals("short[]")) {
                return true;
            }
            if (name2.equals("int[]")) {
                return true;
            }
            if (name2.equals("long[]")) {
                return true;
            }
        } else if (this.value instanceof ObjectReference && (rt = (or = (ObjectReference)this.value).referenceType()) instanceof ClassType && (name = (ct = (ClassType)rt).name()).equals("java.lang.StringBuffer")) {
            return true;
        }
        return false;
    }

    @Override
    public Object getWholeThing() {
        ClassType ct;
        String name;
        ObjectReference or;
        ReferenceType rt;
        this.throwIfExpired();
        if (this.value instanceof StringReference) {
            return ((StringReference)this.value).value();
        }
        if (this.value instanceof ArrayReference) {
            ArrayReference ar = (ArrayReference)this.value;
            ReferenceType rt2 = ar.referenceType();
            String name2 = rt2.name();
            if (name2.equals("char[]")) {
                StringBuffer sb = new StringBuffer();
                int length = ar.length();
                for (int i = 0; i < length; ++i) {
                    char c = ((CharValue)ar.getValue(i)).value();
                    sb.append(c);
                }
                return sb.toString();
            }
            if (name2.equals("byte[]")) {
                int length = ar.length();
                byte[] b = new byte[length];
                for (int i = 0; i < length; ++i) {
                    b[i] = ((ByteValue)ar.getValue(i)).value();
                }
                return b;
            }
            if (name2.equals("short[]")) {
                int length = ar.length();
                short[] b = new short[length];
                for (int i = 0; i < length; ++i) {
                    b[i] = ((ShortValue)ar.getValue(i)).value();
                }
                return b;
            }
            if (name2.equals("int[]")) {
                int length = ar.length();
                int[] b = new int[length];
                for (int i = 0; i < length; ++i) {
                    b[i] = ((IntegerValue)ar.getValue(i)).value();
                }
                return b;
            }
            if (name2.equals("long[]")) {
                int length = ar.length();
                long[] b = new long[length];
                for (int i = 0; i < length; ++i) {
                    b[i] = ((LongValue)ar.getValue(i)).value();
                }
                return b;
            }
        } else if (this.value instanceof ObjectReference && (rt = (or = (ObjectReference)this.value).referenceType()) instanceof ClassType && (name = (ct = (ClassType)rt).name()).equals("java.lang.StringBuffer")) {
            char c;
            ArrayReference ar = (ArrayReference)or.getValue(rt.fieldByName("value"));
            List<Value> values = ar.getValues();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < values.size() && (c = ((CharValue)values.get(i)).value()) != '\u0000'; ++i) {
                sb.append(c);
            }
            return sb.toString();
        }
        return null;
    }

    private static String getCourtesyValueForValue(Value value) {
        try {
            ObjectReference or;
            ReferenceType rt;
            if (value instanceof ClassObjectReference) {
                return ((ClassObjectReference)value).reflectedType().name();
            }
            if (value instanceof StringReference) {
                return ((StringReference)value).value();
            }
            if (value instanceof ArrayReference) {
                ArrayReference ar = (ArrayReference)value;
                ReferenceType rt2 = ar.referenceType();
                String name = rt2.name();
                if (name.equals("char[]")) {
                    StringBuffer sb = new StringBuffer();
                    int length = ar.length();
                    for (int i = 0; i < length; ++i) {
                        char c = ((CharValue)ar.getValue(i)).value();
                        sb.append(c);
                    }
                    return sb.toString();
                }
            } else if (value instanceof ObjectReference && (rt = (or = (ObjectReference)value).referenceType()) instanceof ClassType) {
                for (ClassType ct = (ClassType)rt; ct != null; ct = ct.superclass()) {
                    char c;
                    String name = ct.name();
                    if (!name.equals("java.lang.StringBuffer")) continue;
                    ArrayReference ar = (ArrayReference)or.getValue(rt.fieldByName("value"));
                    List<Value> values = ar.getValues();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < values.size() && (c = ((CharValue)values.get(i)).value()) != '\u0000'; ++i) {
                        sb.append(c);
                    }
                    return sb.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DebugMonitorInfo getMonitor() {
        this.throwIfExpired();
        if (this.dj.canGetMonitors() && this.value != null) {
            ObjectReference or = (ObjectReference)this.value;
            return new DebugJDIMonitorInfo(this.dj, or);
        }
        return null;
    }

    @Override
    public String getValue() {
        this.throwIfExpired();
        if (this.value == null) {
            return "null";
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataCompositeInfo) {
            return super.equals(o);
        }
        return false;
    }
}

