/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIArrayElementInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

class DebugJDIDataInfo
extends JDIInformationProvider
implements DebugDataInfo {
    DebugJDI dj;
    DebugJDIClassInfo clazz;
    Value value;
    Object owner;
    int stoppedCount;
    DebugJDIFieldInfo staticField;
    private int hashCode;

    DebugJDIDataInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        this.dj = dj;
        this.clazz = clazz;
        this.value = value;
        this.owner = owner;
        this.stoppedCount = dj.stoppedCount;
    }

    void setStaticField(DebugJDIFieldInfo staticField) {
        this.staticField = staticField;
    }

    @Override
    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    @Override
    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && this.staticField != null && !this.staticField.hasExpired()) {
            this.value = this.staticField.updateStaticFieldValue();
            this.clazz = this.value != null ? this.dj.findClassByType(this.value.type()) : (DebugJDIClassInfo)this.staticField.getClassInfo();
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public String getHexValue() {
        return "";
    }

    @Override
    public boolean canModifyDataWithString() {
        DebugDataInfo _valueFieldData;
        if (this.owner != null) {
            if (this.isFinal()) {
                return false;
            }
            if (this.value instanceof BooleanValue || this.value instanceof ByteValue || this.value instanceof CharValue || this.value instanceof DoubleValue || this.value instanceof FloatValue || this.value instanceof IntegerValue || this.value instanceof LongValue || this.value instanceof ShortValue || this.value instanceof StringReference) {
                return true;
            }
            if (this.value == null && this.clazz != null && (this.clazz.name.equals("java.lang.String") || this.clazz.name.equals("java.lang.StringBuffer") || this.clazz.name.equals("java.lang.StringBuilder"))) {
                return true;
            }
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (_valueFieldData = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return _valueFieldData.canModifyDataWithString();
        }
        return false;
    }

    @Override
    public boolean modifyDataWithString(String newValue) {
        DebugDataInfo _valueFieldData;
        Value v = null;
        if (this.value instanceof BooleanValue) {
            v = this.dj.makeBooleanValue(newValue);
        } else if (this.value instanceof ByteValue) {
            v = this.dj.makeByteValue(newValue);
        } else if (this.value instanceof CharValue) {
            v = this.dj.makeCharValue(newValue);
        } else if (this.value instanceof DoubleValue) {
            v = this.dj.makeDoubleValue(newValue);
        } else if (this.value instanceof FloatValue) {
            v = this.dj.makeFloatValue(newValue);
        } else if (this.value instanceof IntegerValue) {
            v = this.dj.makeIntegerValue(newValue);
        } else if (this.value instanceof LongValue) {
            v = this.dj.makeLongValue(newValue);
        } else if (this.value instanceof ShortValue) {
            v = this.dj.makeShortValue(newValue);
        } else if (this.value instanceof StringReference) {
            v = this.dj.makeStringValue(newValue);
        } else if (this.value == null && this.clazz != null && (this.clazz.name.equals("java.lang.String") || this.clazz.name.equals("java.lang.StringBuffer") || this.clazz.name.equals("java.lang.StringBuilder"))) {
            v = this.dj.makeStringValue(newValue);
        }
        if (v != null) {
            return this.modifyData(v);
        }
        if (this instanceof DebugJDIDataObjectInfo && this.clazz != null && this.clazz.name.startsWith("$Oracle.Builtin.") && (_valueFieldData = DebugShared.findFieldData((DebugDataObjectInfo)((Object)this), "_value", "java.lang.String")) != null) {
            return _valueFieldData.modifyDataWithString(newValue);
        }
        return false;
    }

    @Override
    public boolean canModifyDataWithData() {
        return this.owner != null && !this.isFinal();
    }

    @Override
    public boolean modifyDataWithData(DebugDataInfo newValue) {
        Value v = ((DebugJDIDataInfo)newValue).value;
        return this.modifyData(v);
    }

    @Override
    public boolean canModifyDataWithNewObject() {
        return this.owner != null && !this.isFinal() && this.value instanceof ObjectReference && this.dj.eventThread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifyDataWithNewObject(DebugMethodInfo method, String[] arguments) {
        boolean modified = false;
        DebugJDIMethodInfo jmi = (DebugJDIMethodInfo)method;
        ClassType ct = (ClassType)jmi.ci.getReferenceType();
        Method m = jmi.m;
        List<Value> argList = this.dj.makeArgumentsFromStrings(m, arguments);
        if (this.value instanceof ObjectReference && this.dj.eventThread != null && argList != null) {
            Value v;
            block14: {
                v = null;
                List prev = this.dj.tempDisableRequests();
                try {
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.ct = ct;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.NEW_INSTANCE;
                        worker.dj = this.dj;
                        worker.m = m;
                        worker.argList = argList;
                        try {
                            v = this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {}
                        break block14;
                    }
                    try {
                        Log logger = JDebugger.logger;
                        if (logger.isEnabled()) {
                            logger.trace("Invoking newInstance method: {0}.{1}", (Object)ct.name(), (Object)m.name());
                        }
                        int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        v = ct.newInstance(this.dj.eventThread, m, argList, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(v == null ? "null" : "not null"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            if (v != null) {
                try {
                    modified = this.modifyData(v);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return modified;
    }

    protected boolean isFinal() {
        return this.owner != null && this.owner instanceof DebugJDIFieldInfo && ((DebugJDIFieldInfo)this.owner).isFinal();
    }

    protected boolean modifyData(Value newValue) {
        try {
            if (this.owner instanceof DebugJDIVariableInfo) {
                DebugJDIVariableInfo var = (DebugJDIVariableInfo)this.owner;
                var.djsf.sf.setValue(var.lv, newValue);
                return true;
            }
            if (this.owner instanceof DebugJDIFieldInfo) {
                DebugJDIFieldInfo field = (DebugJDIFieldInfo)this.owner;
                if (field.or != null) {
                    field.or.setValue(field.field, newValue);
                    return true;
                }
                if (field.isStatic) {
                    ((ClassType)field.declaringClass.getReferenceType()).setValue(field.field, newValue);
                    return true;
                }
            } else if (this.owner instanceof DebugJDIArrayElementInfo) {
                DebugJDIArrayElementInfo elem = (DebugJDIArrayElementInfo)this.owner;
                ((ArrayReference)elem.array.value).setValue(elem.index, newValue);
                return true;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.dj.hashCode();
            if (this.clazz != null) {
                this.hashCode += 17;
                int clazzHashCode = this.clazz.hashCode();
                if (clazzHashCode != 0) {
                    this.hashCode *= clazzHashCode;
                }
            }
            if (this.value != null) {
                this.hashCode -= 13;
                int valueHashCode = this.value.hashCode();
                if (valueHashCode != 0) {
                    this.hashCode *= valueHashCode;
                }
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataInfo) {
            DebugJDIDataInfo other = (DebugJDIDataInfo)o;
            return this.dj.equals(other.dj) && this.clazz.equals(other.clazz) && (this.value == null ? other.value == null : this.value.equals(other.value));
        }
        return false;
    }

    @Override
    public Value getJDIValue() {
        return this.value;
    }
}

