/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIFieldInfo
extends JDIInformationProvider
implements DebugFieldInfo,
DebugHasAnnotations {
    DebugJDI dj;
    Field field;
    DebugJDIClassInfo declaringClass;
    ObjectReference or;
    int stoppedCount;
    boolean isStatic;
    private int annotationCount = -1;
    private int hashCode;

    DebugJDIFieldInfo(DebugJDI dj, Field field, DebugJDIClassInfo declaringClass, ObjectReference or) {
        this.dj = dj;
        this.field = field;
        this.declaringClass = declaringClass;
        this.or = or;
        this.stoppedCount = dj.stoppedCount;
        this.isStatic = field.isStatic();
    }

    @Override
    public boolean hasExpired() {
        if (this.dj.stoppedCount != this.stoppedCount && !this.isStatic && !this.declaringClass.hasExpired()) {
            this.stoppedCount = this.dj.stoppedCount;
        }
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public DebugClassInfo getClassInfo() {
        this.throwIfExpired();
        try {
            DebugJDIClassInfo c = this.dj.findClassByType(this.field.type());
            if (c != null) {
                return c;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DebugJDIClassInfo c;
            Value v = null;
            if (this.or != null) {
                v = this.or.getValue(this.field);
            } else if (this.isStatic) {
                v = this.declaringClass.getReferenceType().getValue(this.field);
            }
            if (v != null && (c = this.dj.findClassByType(v.type())) != null) {
                return c;
            }
            return this.dj.findClassByName(this.field.typeName(), true);
        }
        catch (VMDisconnectedException vmde) {
            return new DebugJDIClassInfo("unknown");
        }
    }

    @Override
    public String getGenericSignature() {
        return this.field.genericSignature();
    }

    @Override
    public DebugClassInfo getDeclaringClassInfo() {
        this.hasExpired();
        return this.dj.findClassByType(this.field.declaringType());
    }

    @Override
    public boolean isStatic() {
        this.throwIfExpired();
        return this.isStatic;
    }

    @Override
    public boolean isFinal() {
        this.throwIfExpired();
        return this.field.isFinal();
    }

    @Override
    public String getName() {
        this.throwIfExpired();
        return this.field.name();
    }

    @Override
    public int getAccess() {
        this.throwIfExpired();
        return this.field.modifiers();
    }

    @Override
    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        try {
            boolean gotValue = false;
            Value v = null;
            if (this.or != null) {
                v = this.or.getValue(this.field);
                gotValue = true;
            } else if (this.isStatic) {
                v = this.declaringClass.getReferenceType().getValue(this.field);
                gotValue = true;
            }
            if (gotValue) {
                DebugJDIDataInfo data = v != null ? this.dj.makeData(v, this) : this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
                if (this.isStatic) {
                    data.setStaticField(this);
                }
                return data;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return null;
    }

    Value updateStaticFieldValue() {
        return this.declaringClass.getReferenceType().getValue(this.field);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.field.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIFieldInfo) {
            DebugJDIFieldInfo other = (DebugJDIFieldInfo)o;
            return this.field.equals(other.field);
        }
        return false;
    }

    @Override
    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        if (this.annotationCount < 0) {
            this.getAnnotations();
        }
        return this.annotationCount < 0 ? 0 : this.annotationCount;
    }

    @Override
    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ObjectReference orField;
            if (this.dj.isSafeToGetAnnotations() && (orField = this.getReflectedField()) != null) {
                DebugAnnotationInfo[] result = this.dj.getAnnotations(orField);
                this.annotationCount = result.length;
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectReference getReflectedField() {
        try {
            if (this.dj.eventThread == null) return null;
            ReferenceType rt = this.field.declaringType();
            if (rt == null) return null;
            ClassObjectReference orClass = rt.classObject();
            if (orClass == null) return null;
            ClassType ctClass = (ClassType)orClass.referenceType();
            Method mGetDeclaredField = ctClass.concreteMethodByName("getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            if (mGetDeclaredField == null) return null;
            ArrayList<Value> argsGetDeclaredField = new ArrayList<Value>(1);
            argsGetDeclaredField.add(this.dj.vm.mirrorOf(this.field.name()));
            Object object = this.dj.methodCallLock;
            synchronized (object) {
                List prev = this.dj.tempDisableRequests();
                try {
                    ObjectReference orField = null;
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.or = orClass;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                        worker.dj = this.dj;
                        worker.m = mGetDeclaredField;
                        worker.argList = argsGetDeclaredField;
                        try {
                            orField = (ObjectReference)this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {}
                    } else {
                        Log logger = JDebugger.logger;
                        if (logger.isEnabled()) {
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)mGetDeclaredField.name());
                        }
                        int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        orField = (ObjectReference)orClass.invokeMethod(this.dj.eventThread, mGetDeclaredField, argsGetDeclaredField, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(orField == null ? "null" : "not null"));
                        }
                    }
                    ObjectReference objectReference = orField;
                    return objectReference;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Field getJDIField() {
        return this.field;
    }
}

