/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;

abstract class DebugJDIHeapAncestor
implements DebugHeapAncestor {
    DebugJDI dj;
    long address;
    int depth;
    int stoppedCount;
    DebugJDIDataCompositeInfo data;

    DebugJDIHeapAncestor(DebugJDI dj, long address) {
        this.dj = dj;
        this.address = address;
        this.stoppedCount = dj.stoppedCount;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public DebugDataCompositeInfo getDataInfo() {
        if (this.data != null) {
            return this.data;
        }
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.dj.getObjectFromAddress(this.address);
        }
        return this.data;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIHeapAncestor) {
            DebugJDIHeapAncestor other = (DebugJDIHeapAncestor)o;
            return this.dj.equals(other.dj) && this.address == other.address;
        }
        return false;
    }
}

