/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ObjectReference;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataArrayInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;

final class DebugJDIHeapObjectInfo
implements DebugHeapObjectInfo {
    DebugJDI dj;
    int stoppedCount;
    long address;
    boolean root;
    int size;
    DebugJDIClassInfo clazz;
    DebugJDIDataCompositeInfo data;
    ObjectReference or;
    private int hashCode;

    DebugJDIHeapObjectInfo(DebugJDI dj, ObjectReference or, boolean root, int size, DebugJDIClassInfo clazz) {
        this.dj = dj;
        this.stoppedCount = dj.stoppedCount;
        this.address = or.uniqueID();
        this.root = root;
        this.size = size;
        this.clazz = clazz;
        this.or = or;
    }

    @Override
    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public long getAddressOfObject() {
        return this.address;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    @Override
    public DebugDataCompositeInfo getDataInfo() {
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.clazz.isObject() ? new DebugJDIDataObjectInfo(this.dj, this.clazz, this.or, null) : (this.clazz.isArray() ? new DebugJDIDataArrayInfo(this.dj, this.clazz, this.or, null) : new DebugJDIDataCompositeInfo(this.dj, this.clazz, this.or, null));
        }
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIHeapObjectInfo) {
            DebugJDIHeapObjectInfo other = (DebugJDIHeapObjectInfo)o;
            return this.address == other.address;
        }
        return false;
    }

    ObjectReference getObjectReference() {
        return this.or;
    }
}

