/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import java.util.List;
import oracle.ide.util.Assert;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugJDILocation
implements DebugLocation {
    DebugJDI dj;
    Location location;
    DebugJDIClassInfo clazz;
    Method m;
    DebugJDIMethodInfo method;
    int line;
    boolean exactLine;

    DebugJDILocation(DebugJDI dj, Location location) {
        this.dj = dj;
        this.location = location;
        ReferenceType rt = location.declaringType();
        String defaultStratum = rt.defaultStratum();
        this.clazz = dj.findClass(rt);
        this.m = location.method();
        this.method = new DebugJDIMethodInfo(dj, this.clazz, this.m);
        try {
            if (!this.m.isNative()) {
                this.line = DebugJDI.getLineNumber(location, defaultStratum);
            }
        }
        catch (InternalError e) {
            Assert.println((String)("Ignoring " + e + " (while getting lineNumber from location)."));
        }
        if (this.line > 0) {
            try {
                List locationsOfLine = DebugJDI.getLocationsOfLine(this.m, null, null, this.line);
                Location first = DebugJDI.getFirstLocation(locationsOfLine);
                if (first != null && first.codeIndex() == location.codeIndex()) {
                    this.exactLine = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public DebugMethodInfo getMethod() {
        return this.method;
    }

    @Override
    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    @Override
    public String getPath() {
        try {
            return this.location.sourcePath();
        }
        catch (VMDisconnectedException e) {
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return "";
    }

    public String getFilename() {
        try {
            return this.location.sourceName();
        }
        catch (VMDisconnectedException e) {
        }
        catch (AbsentInformationException e) {
        }
        catch (InternalException ie) {
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        return "";
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    @Override
    public int getBytecodeOffset() {
        if (!this.m.isNative()) {
            return (int)this.location.codeIndex();
        }
        return -1;
    }

    @Override
    public boolean isBytecodeExact() {
        return true;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public boolean isLineExact() {
        return this.exactLine;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDILocation) {
            DebugJDILocation other = (DebugJDILocation)o;
            return this.location.equals(other.location);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public String toString() {
        try {
            return "DebugJDILocation " + this.location.sourceName() + ":" + this.location.lineNumber();
        }
        catch (AbsentInformationException e) {
            return "DebugJDILocation [source not available] : " + this.location.lineNumber();
        }
    }
}

